// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/kube-reporting/metering-operator/pkg/apis/metering/v1"
	scheme "github.com/kube-reporting/metering-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ReportQueriesGetter has a method to return a ReportQueryInterface.
// A group's client should implement this interface.
type ReportQueriesGetter interface {
	ReportQueries(namespace string) ReportQueryInterface
}

// ReportQueryInterface has methods to work with ReportQuery resources.
type ReportQueryInterface interface {
	Create(*v1.ReportQuery) (*v1.ReportQuery, error)
	Update(*v1.ReportQuery) (*v1.ReportQuery, error)
	UpdateStatus(*v1.ReportQuery) (*v1.ReportQuery, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ReportQuery, error)
	List(opts metav1.ListOptions) (*v1.ReportQueryList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ReportQuery, err error)
	ReportQueryExpansion
}

// reportQueries implements ReportQueryInterface
type reportQueries struct {
	client rest.Interface
	ns     string
}

// newReportQueries returns a ReportQueries
func newReportQueries(c *MeteringV1Client, namespace string) *reportQueries {
	return &reportQueries{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the reportQuery, and returns the corresponding reportQuery object, and an error if there is any.
func (c *reportQueries) Get(name string, options metav1.GetOptions) (result *v1.ReportQuery, err error) {
	result = &v1.ReportQuery{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("reportqueries").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ReportQueries that match those selectors.
func (c *reportQueries) List(opts metav1.ListOptions) (result *v1.ReportQueryList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ReportQueryList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("reportqueries").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested reportQueries.
func (c *reportQueries) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("reportqueries").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a reportQuery and creates it.  Returns the server's representation of the reportQuery, and an error, if there is any.
func (c *reportQueries) Create(reportQuery *v1.ReportQuery) (result *v1.ReportQuery, err error) {
	result = &v1.ReportQuery{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("reportqueries").
		Body(reportQuery).
		Do().
		Into(result)
	return
}

// Update takes the representation of a reportQuery and updates it. Returns the server's representation of the reportQuery, and an error, if there is any.
func (c *reportQueries) Update(reportQuery *v1.ReportQuery) (result *v1.ReportQuery, err error) {
	result = &v1.ReportQuery{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("reportqueries").
		Name(reportQuery.Name).
		Body(reportQuery).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *reportQueries) UpdateStatus(reportQuery *v1.ReportQuery) (result *v1.ReportQuery, err error) {
	result = &v1.ReportQuery{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("reportqueries").
		Name(reportQuery.Name).
		SubResource("status").
		Body(reportQuery).
		Do().
		Into(result)
	return
}

// Delete takes name of the reportQuery and deletes it. Returns an error if one occurs.
func (c *reportQueries) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("reportqueries").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *reportQueries) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("reportqueries").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched reportQuery.
func (c *reportQueries) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ReportQuery, err error) {
	result = &v1.ReportQuery{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("reportqueries").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
