/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.prestosql.plugin.prometheus;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * allow for settable Clock for testing
 */
public class PrometheusTimeMachine
{
    private PrometheusTimeMachine()
    {
        // no default or public constructor for utility class
    }

    private static Clock clock = Clock.systemDefaultZone();
    private static ZoneId zoneId = ZoneId.systemDefault();

    public static LocalDateTime now()
    {
        return LocalDateTime.now(getClock());
    }

    public static void useFixedClockAt(LocalDateTime date)
    {
        clock = Clock.fixed(date.atZone(zoneId).toInstant(), zoneId);
    }

    private static Clock getClock()
    {
        return clock;
    }
}
