// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/job_service.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An enum that specifies the job attributes that are returned in the
// [MatchingJob.Job][] in
// [SearchJobsResponse][google.cloud.talent.v4beta1.SearchJobsResponse] or
// [Job][google.cloud.talent.v4beta1.Job] objects in
// [ListJobsResponse][google.cloud.talent.v4beta1.ListJobsResponse].
type JobView int32

const (
	// Default value.
	JobView_JOB_VIEW_UNSPECIFIED JobView = 0
	// A ID only view of job, with following attributes:
	// [Job.name][google.cloud.talent.v4beta1.Job.name],
	// [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code].
	JobView_JOB_VIEW_ID_ONLY JobView = 1
	// A minimal view of the job, with the following attributes:
	// [Job.name][google.cloud.talent.v4beta1.Job.name],
	// [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id],
	// [Job.job_title][],
	// [Job.company_name][google.cloud.talent.v4beta1.Job.company_name],
	// [Job.DerivedInfo.locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code].
	JobView_JOB_VIEW_MINIMAL JobView = 2
	// A small view of the job, with the following attributes in the search
	// results: [Job.name][google.cloud.talent.v4beta1.Job.name],
	// [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id],
	// [Job.job_title][],
	// [Job.company_name][google.cloud.talent.v4beta1.Job.company_name],
	// [Job.DerivedInfo.locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations],
	// [Job.visibility][google.cloud.talent.v4beta1.Job.visibility],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
	// [Job.description][google.cloud.talent.v4beta1.Job.description].
	JobView_JOB_VIEW_SMALL JobView = 3
	// All available attributes are included in the search results.
	JobView_JOB_VIEW_FULL JobView = 4
)

var JobView_name = map[int32]string{
	0: "JOB_VIEW_UNSPECIFIED",
	1: "JOB_VIEW_ID_ONLY",
	2: "JOB_VIEW_MINIMAL",
	3: "JOB_VIEW_SMALL",
	4: "JOB_VIEW_FULL",
}
var JobView_value = map[string]int32{
	"JOB_VIEW_UNSPECIFIED": 0,
	"JOB_VIEW_ID_ONLY":     1,
	"JOB_VIEW_MINIMAL":     2,
	"JOB_VIEW_SMALL":       3,
	"JOB_VIEW_FULL":        4,
}

func (x JobView) String() string {
	return proto.EnumName(JobView_name, int32(x))
}
func (JobView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{0}
}

// A string-represented enumeration of the job search mode. The service
// operate differently for different modes of service.
type SearchJobsRequest_SearchMode int32

const (
	// The mode of the search method isn't specified.
	SearchJobsRequest_SEARCH_MODE_UNSPECIFIED SearchJobsRequest_SearchMode = 0
	// The job search matches against all jobs, and featured jobs
	// (jobs with promotionValue > 0) are not specially handled.
	SearchJobsRequest_JOB_SEARCH SearchJobsRequest_SearchMode = 1
	// The job search matches only against featured jobs (jobs with a
	// promotionValue > 0). This method doesn't return any jobs having a
	// promotionValue <= 0. The search results order is determined by the
	// promotionValue (jobs with a higher promotionValue are returned higher up
	// in the search results), with relevance being used as a tiebreaker.
	SearchJobsRequest_FEATURED_JOB_SEARCH SearchJobsRequest_SearchMode = 2
)

var SearchJobsRequest_SearchMode_name = map[int32]string{
	0: "SEARCH_MODE_UNSPECIFIED",
	1: "JOB_SEARCH",
	2: "FEATURED_JOB_SEARCH",
}
var SearchJobsRequest_SearchMode_value = map[string]int32{
	"SEARCH_MODE_UNSPECIFIED": 0,
	"JOB_SEARCH":              1,
	"FEATURED_JOB_SEARCH":     2,
}

func (x SearchJobsRequest_SearchMode) String() string {
	return proto.EnumName(SearchJobsRequest_SearchMode_name, int32(x))
}
func (SearchJobsRequest_SearchMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{7, 0}
}

// Controls whether highly similar jobs are returned next to each other in
// the search results. Jobs are identified as highly similar based on
// their titles, job categories, and locations. Highly similar results are
// clustered so that only one representative job of the cluster is
// displayed to the job seeker higher up in the results, with the other jobs
// being displayed lower down in the results.
type SearchJobsRequest_DiversificationLevel int32

const (
	// The diversification level isn't specified.
	SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED SearchJobsRequest_DiversificationLevel = 0
	// Disables diversification. Jobs that would normally be pushed to the last
	// page would not have their positions altered. This may result in highly
	// similar jobs appearing in sequence in the search results.
	SearchJobsRequest_DISABLED SearchJobsRequest_DiversificationLevel = 1
	// Default diversifying behavior. The result list is ordered so that
	// highly similar results are pushed to the end of the last page of search
	// results.
	SearchJobsRequest_SIMPLE SearchJobsRequest_DiversificationLevel = 2
)

var SearchJobsRequest_DiversificationLevel_name = map[int32]string{
	0: "DIVERSIFICATION_LEVEL_UNSPECIFIED",
	1: "DISABLED",
	2: "SIMPLE",
}
var SearchJobsRequest_DiversificationLevel_value = map[string]int32{
	"DIVERSIFICATION_LEVEL_UNSPECIFIED": 0,
	"DISABLED":                          1,
	"SIMPLE":                            2,
}

func (x SearchJobsRequest_DiversificationLevel) String() string {
	return proto.EnumName(SearchJobsRequest_DiversificationLevel_name, int32(x))
}
func (SearchJobsRequest_DiversificationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{7, 1}
}

// The importance level for
// [CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression].
type SearchJobsRequest_CustomRankingInfo_ImportanceLevel int32

const (
	// Default value if the importance level isn't specified.
	SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 0
	// The given ranking expression is of None importance, existing relevance
	// score (determined by API algorithm) dominates job's final ranking
	// position.
	SearchJobsRequest_CustomRankingInfo_NONE SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 1
	// The given ranking expression is of Low importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_LOW SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 2
	// The given ranking expression is of Mild importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_MILD SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 3
	// The given ranking expression is of Medium importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_MEDIUM SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 4
	// The given ranking expression is of High importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_HIGH SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 5
	// The given ranking expression is of Extreme importance, and dominates
	// job's final ranking position with existing relevance
	// score (determined by API algorithm) ignored.
	SearchJobsRequest_CustomRankingInfo_EXTREME SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 6
)

var SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name = map[int32]string{
	0: "IMPORTANCE_LEVEL_UNSPECIFIED",
	1: "NONE",
	2: "LOW",
	3: "MILD",
	4: "MEDIUM",
	5: "HIGH",
	6: "EXTREME",
}
var SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value = map[string]int32{
	"IMPORTANCE_LEVEL_UNSPECIFIED": 0,
	"NONE":                         1,
	"LOW":                          2,
	"MILD":                         3,
	"MEDIUM":                       4,
	"HIGH":                         5,
	"EXTREME":                      6,
}

func (x SearchJobsRequest_CustomRankingInfo_ImportanceLevel) String() string {
	return proto.EnumName(SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name, int32(x))
}
func (SearchJobsRequest_CustomRankingInfo_ImportanceLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{7, 0, 0}
}

// Input only.
//
// Create job request.
type CreateJobRequest struct {
	// Required.
	//
	// The resource name of the project under which the job is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The Job to be created.
	Job                  *Job     `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateJobRequest) Reset()         { *m = CreateJobRequest{} }
func (m *CreateJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateJobRequest) ProtoMessage()    {}
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{0}
}
func (m *CreateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateJobRequest.Unmarshal(m, b)
}
func (m *CreateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateJobRequest.Marshal(b, m, deterministic)
}
func (dst *CreateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateJobRequest.Merge(dst, src)
}
func (m *CreateJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateJobRequest.Size(m)
}
func (m *CreateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateJobRequest proto.InternalMessageInfo

func (m *CreateJobRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Input only.
//
// Get job request.
type GetJobRequest struct {
	// Required.
	//
	// The resource name of the job to retrieve.
	//
	// The format is "projects/{project_id}/jobs/{job_id}",
	// for example, "projects/api-test-project/jobs/1234".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobRequest) Reset()         { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()    {}
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{1}
}
func (m *GetJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobRequest.Unmarshal(m, b)
}
func (m *GetJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobRequest.Marshal(b, m, deterministic)
}
func (dst *GetJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobRequest.Merge(dst, src)
}
func (m *GetJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobRequest.Size(m)
}
func (m *GetJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobRequest proto.InternalMessageInfo

func (m *GetJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Input only.
//
// Update job request.
type UpdateJobRequest struct {
	// Required.
	//
	// The Job to be updated.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Optional but strongly recommended to be provided for the best service
	// experience.
	//
	// If [update_mask][google.cloud.talent.v4beta1.UpdateJobRequest.update_mask]
	// is provided, only the specified fields in
	// [job][google.cloud.talent.v4beta1.UpdateJobRequest.job] are updated.
	// Otherwise all the fields are updated.
	//
	// A field mask to restrict the fields that are updated. Only
	// top level fields of [Job][google.cloud.talent.v4beta1.Job] are supported.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateJobRequest) Reset()         { *m = UpdateJobRequest{} }
func (m *UpdateJobRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateJobRequest) ProtoMessage()    {}
func (*UpdateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{2}
}
func (m *UpdateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateJobRequest.Unmarshal(m, b)
}
func (m *UpdateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateJobRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobRequest.Merge(dst, src)
}
func (m *UpdateJobRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateJobRequest.Size(m)
}
func (m *UpdateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobRequest proto.InternalMessageInfo

func (m *UpdateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *UpdateJobRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Input only.
//
// Delete job request.
type DeleteJobRequest struct {
	// Required.
	//
	// The resource name of the job to be deleted.
	//
	// The format is "projects/{project_id}/jobs/{job_id}",
	// for example, "projects/api-test-project/jobs/1234".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteJobRequest) Reset()         { *m = DeleteJobRequest{} }
func (m *DeleteJobRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteJobRequest) ProtoMessage()    {}
func (*DeleteJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{3}
}
func (m *DeleteJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteJobRequest.Unmarshal(m, b)
}
func (m *DeleteJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteJobRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteJobRequest.Merge(dst, src)
}
func (m *DeleteJobRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteJobRequest.Size(m)
}
func (m *DeleteJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteJobRequest proto.InternalMessageInfo

func (m *DeleteJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Input only.
//
// Batch delete jobs request.
type BatchDeleteJobsRequest struct {
	// Required.
	//
	// The resource name of the project under which the job is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The filter string specifies the jobs to be deleted.
	//
	// Supported operator: =, AND
	//
	// The fields eligible for filtering are:
	//
	// * `companyName` (Required)
	// * `requisitionId` (Required)
	//
	// Sample Query: companyName = "projects/api-test-project/companies/123" AND
	// requisitionId = "req-1"
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteJobsRequest) Reset()         { *m = BatchDeleteJobsRequest{} }
func (m *BatchDeleteJobsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteJobsRequest) ProtoMessage()    {}
func (*BatchDeleteJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{4}
}
func (m *BatchDeleteJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteJobsRequest.Unmarshal(m, b)
}
func (m *BatchDeleteJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteJobsRequest.Marshal(b, m, deterministic)
}
func (dst *BatchDeleteJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteJobsRequest.Merge(dst, src)
}
func (m *BatchDeleteJobsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteJobsRequest.Size(m)
}
func (m *BatchDeleteJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteJobsRequest proto.InternalMessageInfo

func (m *BatchDeleteJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Input only.
//
// List jobs request.
type ListJobsRequest struct {
	// Required.
	//
	// The resource name of the project under which the job is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The filter string specifies the jobs to be enumerated.
	//
	// Supported operator: =, AND
	//
	// The fields eligible for filtering are:
	//
	// * `companyName` (Required)
	// * `requisitionId` (Optional)
	// * `status` (Optional) Available values: OPEN, EXPIRED, ALL. Defaults to
	// OPEN if no value is specified.
	//
	// Sample Query:
	//
	// * companyName = "projects/api-test-project/companies/123"
	// * companyName = "projects/api-test-project/companies/123" AND requisitionId
	// = "req-1"
	// * companyName = "projects/api-test-project/companies/123" AND status =
	// "EXPIRED"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional.
	//
	// The starting point of a query result.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional.
	//
	// The maximum number of jobs to be returned per page of results.
	//
	// If [job_view][google.cloud.talent.v4beta1.ListJobsRequest.job_view] is set
	// to
	// [JobView.JOB_VIEW_ID_ONLY][google.cloud.talent.v4beta1.JobView.JOB_VIEW_ID_ONLY],
	// the maximum allowed page size is 1000. Otherwise, the maximum allowed page
	// size is 100.
	//
	// Default is 100 if empty or a number < 1 is specified.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional.
	//
	// The desired job attributes returned for jobs in the
	// search response. Defaults to
	// [JobView.JOB_VIEW_FULL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_FULL]
	// if no value is specified.
	JobView              JobView  `protobuf:"varint,5,opt,name=job_view,json=jobView,proto3,enum=google.cloud.talent.v4beta1.JobView" json:"job_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsRequest) Reset()         { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()    {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{5}
}
func (m *ListJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsRequest.Unmarshal(m, b)
}
func (m *ListJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsRequest.Marshal(b, m, deterministic)
}
func (dst *ListJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsRequest.Merge(dst, src)
}
func (m *ListJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListJobsRequest.Size(m)
}
func (m *ListJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsRequest proto.InternalMessageInfo

func (m *ListJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobsRequest) GetJobView() JobView {
	if m != nil {
		return m.JobView
	}
	return JobView_JOB_VIEW_UNSPECIFIED
}

// Output only.
//
// List jobs response.
type ListJobsResponse struct {
	// The Jobs for a given company.
	//
	// The maximum number of items returned is based on the limit field
	// provided in the request.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata             *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListJobsResponse) Reset()         { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()    {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{6}
}
func (m *ListJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsResponse.Unmarshal(m, b)
}
func (m *ListJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsResponse.Marshal(b, m, deterministic)
}
func (dst *ListJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsResponse.Merge(dst, src)
}
func (m *ListJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListJobsResponse.Size(m)
}
func (m *ListJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsResponse proto.InternalMessageInfo

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListJobsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Input only.
//
// The Request body of the `SearchJobs` call.
type SearchJobsRequest struct {
	// Required.
	//
	// The resource name of the project to search within.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional.
	//
	// Mode of a search.
	//
	// Defaults to
	// [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
	SearchMode SearchJobsRequest_SearchMode `protobuf:"varint,2,opt,name=search_mode,json=searchMode,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_SearchMode" json:"search_mode,omitempty"`
	// Required.
	//
	// The meta information collected about the job searcher, used to improve the
	// search quality of the service.. The identifiers, (such as `user_id`) are
	// provided by users, and must be unique and consistent.
	RequestMetadata *RequestMetadata `protobuf:"bytes,3,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// Optional.
	//
	// Query used to search against jobs, such as keyword, location filters, etc.
	JobQuery *JobQuery `protobuf:"bytes,4,opt,name=job_query,json=jobQuery,proto3" json:"job_query,omitempty"`
	// Optional.
	//
	// Controls whether to broaden the search when it produces sparse results.
	// Broadened queries append results to the end of the matching results
	// list.
	//
	// Defaults to false.
	EnableBroadening bool `protobuf:"varint,5,opt,name=enable_broadening,json=enableBroadening,proto3" json:"enable_broadening,omitempty"`
	// Optional.
	//
	// Controls if the search job request requires the return of a precise
	// count of the first 300 results. Setting this to `true` ensures
	// consistency in the number of results per page. Best practice is to set this
	// value to true if a client allows users to jump directly to a
	// non-sequential search results page.
	//
	// Enabling this flag may adversely impact performance.
	//
	// Defaults to false.
	RequirePreciseResultSize bool `protobuf:"varint,6,opt,name=require_precise_result_size,json=requirePreciseResultSize,proto3" json:"require_precise_result_size,omitempty"`
	// Optional.
	//
	// An expression specifies a histogram request against matching jobs.
	//
	// Expression syntax is an aggregation function call with histogram facets and
	// other options.
	//
	// Available aggregation function calls are:
	// * `count(string_histogram_facet)`: Count the number of matching entities,
	// for each distinct attribute value.
	// * `count(numeric_histogram_facet, list of buckets)`: Count the number of
	// matching entities within each bucket.
	//
	// Data types:
	//
	// * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
	// * String: string like "any string with backslash escape for quote(\")."
	// * Number: whole number and floating point number like 10, -1 and -0.01.
	// * List: list of elements with comma(,) separator surrounded by square
	// brackets, for example, [1, 2, 3] and ["one", "two", "three"].
	//
	// Built-in constants:
	//
	// * MIN (minimum number similar to java Double.MIN_VALUE)
	// * MAX (maximum number similar to java Double.MAX_VALUE)
	//
	// Built-in functions:
	//
	// * bucket(start, end[, label]): bucket built-in function creates a bucket
	// with range of [start, end). Note that the end is exclusive, for example,
	// bucket(1, MAX, "positive number") or bucket(1, 10).
	//
	// Job histogram facets:
	//
	// * company_id: histogram by [Job.distributor_company_id][].
	// * company_display_name: histogram by
	// [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
	// * employment_type: histogram by
	// [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types],
	// for example, "FULL_TIME", "PART_TIME".
	// * company_size: histogram by
	// [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example,
	// "SMALL", "MEDIUM", "BIG".
	// * publish_time_in_month: histogram by the [Job.publish_time][] in months.
	// Must specify list of numeric buckets in spec.
	// * publish_time_in_year: histogram by the [Job.publish_time][] in years.
	// Must specify list of numeric buckets in spec.
	// * degree_type: histogram by the [Job.degree_type][], for example,
	// "Bachelors", "Masters".
	// * job_level: histogram by the
	// [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example,
	// "Entry Level".
	// * country: histogram by the country code of jobs, for example, "US", "FR".
	// * admin1: histogram by the admin1 code of jobs, which is a global
	// placeholder referring to the state, province, or the particular term a
	// country uses to define the geographic structure below the country level,
	// for example, "CA", "IL".
	// * city: histogram by a combination of the "city name, admin1 code". For
	// example,  "Mountain View, CA", "New York, NY".
	// * admin1_country: histogram by a combination of the "admin1 code, country",
	// for example, "CA, US", "IL, US".
	// * city_coordinate: histogram by the city center's GPS coordinates (latitude
	// and longitude), for example, 37.4038522,-122.0987765. Since the coordinates
	// of a city center can change, customers may need to refresh them
	// periodically.
	// * locale: histogram by the
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for
	// example, "en-US", "fr-FR".
	// * language: histogram by the language subtag of the
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for
	// example, "en", "fr".
	// * category: histogram by the
	// [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
	// "COMPUTER_AND_IT", "HEALTHCARE".
	// * base_compensation_unit: histogram by the [CompensationUnit][] of base
	// salary, for example, "WEEKLY", "MONTHLY".
	// * base_compensation: histogram by the base salary. Must specify list of
	// numeric buckets to group results by.
	// * annualized_base_compensation: histogram by the base annualized salary.
	// Must specify list of numeric buckets to group results by.
	// * annualized_total_compensation: histogram by the total annualized salary.
	// Must specify list of numeric buckets to group results by.
	// * string_custom_attribute: histogram by string
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
	// Values can be accessed via square bracket notations like
	// string_custom_attribute["key1"].
	// * numeric_custom_attribute: histogram by numeric
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
	// Values can be accessed via square bracket notations like
	// numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
	// group results by.
	//
	// Example expressions:
	// * count(admin1)
	// * count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
	// bucket(100000, MAX)])
	// * count(string_custom_attribute["some-string-custom-attribute"])
	// * count(numeric_custom_attribute["some-numeric-custom-attribute"],
	// [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative"])
	HistogramQueries []*HistogramQuery `protobuf:"bytes,7,rep,name=histogram_queries,json=histogramQueries,proto3" json:"histogram_queries,omitempty"`
	// Optional.
	//
	// The desired job attributes returned for jobs in the
	// search response. Defaults to [JobView.SMALL][] if no value is specified.
	JobView JobView `protobuf:"varint,8,opt,name=job_view,json=jobView,proto3,enum=google.cloud.talent.v4beta1.JobView" json:"job_view,omitempty"`
	// Optional.
	//
	// An integer that specifies the current offset (that is, starting result
	// location, amongst the jobs deemed by the API as relevant) in search
	// results. This field is only considered if
	// [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is
	// unset.
	//
	// For example, 0 means to  return results starting from the first matching
	// job, and 10 means to return from the 11th job. This can be used for
	// pagination, (for example, pageSize = 10 and offset = 10 means to return
	// from the second page).
	Offset int32 `protobuf:"varint,9,opt,name=offset,proto3" json:"offset,omitempty"`
	// Optional.
	//
	// A limit on the number of jobs returned in the search results.
	// Increasing this value above the default value of 10 can increase search
	// response time. The value can be between 1 and 100.
	PageSize int32 `protobuf:"varint,10,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional.
	//
	// The token specifying the current offset within
	// search results. See
	// [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token]
	// for an explanation of how to obtain the next set of query results.
	PageToken string `protobuf:"bytes,11,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional.
	//
	// The criteria determining how search results are sorted. Default is
	// "relevance desc".
	//
	// Supported options are:
	//
	// * "relevance desc": By relevance descending, as determined by the API
	// algorithms. Relevance thresholding of query results is only available
	// with this ordering.
	// * "posting`_`publish`_`time desc": By
	// [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	// descending.
	// * "posting`_`update`_`time desc": By
	// [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
	// descending.
	// * "title": By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
	// * "title desc": By [Job.title][google.cloud.talent.v4beta1.Job.title]
	// descending.
	// * "annualized`_`base`_`compensation": By job's
	// [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range]
	// ascending. Jobs whose annualized base compensation is unspecified are put
	// at the end of search results.
	// * "annualized`_`base`_`compensation desc": By job's
	// [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range]
	// descending. Jobs whose annualized base compensation is unspecified are put
	// at the end of search results.
	// * "annualized`_`total`_`compensation": By job's
	// [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range]
	// ascending. Jobs whose annualized base compensation is unspecified are put
	// at the end of search results.
	// * "annualized`_`total`_`compensation desc": By job's
	// [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range]
	// descending. Jobs whose annualized base compensation is unspecified are put
	// at the end of search results.
	// * "custom`_`ranking desc": By the relevance score adjusted to the
	// [SearchJobsRequest.custom_ranking_info.ranking_expression][] with weight
	// factor assigned by
	// [SearchJobsRequest.custom_ranking_info.importance_level][] in descending
	// order.
	// * "location`_`distance": By the distance between the location on jobs and
	//  locations specified in the
	// [SearchJobsRequest.job_query.location_filters][].
	// When this order is selected, the
	// [SearchJobsRequest.job_query.location_filters][] must not be empty. When
	// a job has multiple locations, the location closest to one of the locations
	// specified in the location filter will be used to calculate location
	// distance. Distance is calculated by the distance between two lat/long
	// coordinates, with a precision of 10e-4 degrees (11.3 meters).
	// Jobs that don't have locations specified will be ranked below jobs having
	// locations.
	// Diversification strategy is still applied unless explicitly disabled in
	// [SearchJobsRequest.diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
	OrderBy string `protobuf:"bytes,12,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional.
	//
	// Controls whether highly similar jobs are returned next to each other in
	// the search results. Jobs are identified as highly similar based on
	// their titles, job categories, and locations. Highly similar results are
	// clustered so that only one representative job of the cluster is
	// displayed to the job seeker higher up in the results, with the other jobs
	// being displayed lower down in the results.
	//
	// Defaults to
	// [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE]
	// if no value is specified.
	DiversificationLevel SearchJobsRequest_DiversificationLevel `protobuf:"varint,13,opt,name=diversification_level,json=diversificationLevel,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_DiversificationLevel" json:"diversification_level,omitempty"`
	// Optional.
	//
	// Controls over how job documents get ranked on top of existing relevance
	// score (determined by API algorithm).
	CustomRankingInfo *SearchJobsRequest_CustomRankingInfo `protobuf:"bytes,14,opt,name=custom_ranking_info,json=customRankingInfo,proto3" json:"custom_ranking_info,omitempty"`
	// Optional.
	//
	// Controls whether to disable exact keyword match on [Job.job_title][],
	// [Job.description][google.cloud.talent.v4beta1.Job.description],
	// [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name],
	// [Job.locations][0],
	// [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When
	// disable keyword match is turned off, a keyword match returns jobs that do
	// not match given category filters when there are matching keywords. For
	// example, for the query "program manager," a result is returned even if the
	// job posting has the title "software developer," which doesn't fall into
	// "program manager" ontology, but does have "program manager" appearing in
	// its description.
	//
	// For queries like "cloud" that don't contain title or
	// location specific ontology, jobs with "cloud" keyword matches are returned
	// regardless of this flag's value.
	//
	// Please use [Company.keyword_searchable_custom_fields][] or
	// [Company.keyword_searchable_custom_attributes][] if company specific
	// globally matched custom field/attribute string values is needed. Enabling
	// keyword match improves recall of subsequent search requests.
	//
	// Defaults to false.
	DisableKeywordMatch  bool     `protobuf:"varint,16,opt,name=disable_keyword_match,json=disableKeywordMatch,proto3" json:"disable_keyword_match,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchJobsRequest) Reset()         { *m = SearchJobsRequest{} }
func (m *SearchJobsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchJobsRequest) ProtoMessage()    {}
func (*SearchJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{7}
}
func (m *SearchJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsRequest.Unmarshal(m, b)
}
func (m *SearchJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsRequest.Marshal(b, m, deterministic)
}
func (dst *SearchJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsRequest.Merge(dst, src)
}
func (m *SearchJobsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchJobsRequest.Size(m)
}
func (m *SearchJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsRequest proto.InternalMessageInfo

func (m *SearchJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchJobsRequest) GetSearchMode() SearchJobsRequest_SearchMode {
	if m != nil {
		return m.SearchMode
	}
	return SearchJobsRequest_SEARCH_MODE_UNSPECIFIED
}

func (m *SearchJobsRequest) GetRequestMetadata() *RequestMetadata {
	if m != nil {
		return m.RequestMetadata
	}
	return nil
}

func (m *SearchJobsRequest) GetJobQuery() *JobQuery {
	if m != nil {
		return m.JobQuery
	}
	return nil
}

func (m *SearchJobsRequest) GetEnableBroadening() bool {
	if m != nil {
		return m.EnableBroadening
	}
	return false
}

func (m *SearchJobsRequest) GetRequirePreciseResultSize() bool {
	if m != nil {
		return m.RequirePreciseResultSize
	}
	return false
}

func (m *SearchJobsRequest) GetHistogramQueries() []*HistogramQuery {
	if m != nil {
		return m.HistogramQueries
	}
	return nil
}

func (m *SearchJobsRequest) GetJobView() JobView {
	if m != nil {
		return m.JobView
	}
	return JobView_JOB_VIEW_UNSPECIFIED
}

func (m *SearchJobsRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SearchJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchJobsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *SearchJobsRequest) GetDiversificationLevel() SearchJobsRequest_DiversificationLevel {
	if m != nil {
		return m.DiversificationLevel
	}
	return SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED
}

func (m *SearchJobsRequest) GetCustomRankingInfo() *SearchJobsRequest_CustomRankingInfo {
	if m != nil {
		return m.CustomRankingInfo
	}
	return nil
}

func (m *SearchJobsRequest) GetDisableKeywordMatch() bool {
	if m != nil {
		return m.DisableKeywordMatch
	}
	return false
}

// Input only.
//
// Custom ranking information for
// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
type SearchJobsRequest_CustomRankingInfo struct {
	// Required.
	//
	// Controls over how important the score of
	// [CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression]
	// gets applied to job's final ranking position.
	//
	// An error is thrown if not specified.
	ImportanceLevel SearchJobsRequest_CustomRankingInfo_ImportanceLevel `protobuf:"varint,1,opt,name=importance_level,json=importanceLevel,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_CustomRankingInfo_ImportanceLevel" json:"importance_level,omitempty"`
	// Required.
	//
	// Controls over how job documents get ranked on top of existing relevance
	// score (determined by API algorithm). The product of ranking expression
	// and relevance score is used to determine job's final ranking position.
	//
	// The syntax for this expression is a subset of Google SQL syntax.
	//
	// Supported operators are: +, -, *, /, where the left and right side of
	// the operator is either a numeric
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes]
	// key, integer/double value or an expression that can be evaluated to a
	// number.
	//
	// Parenthesis are supported to adjust calculation precedence. The
	// expression must be < 100 characters in length.
	//
	// Sample ranking expression
	// (year + 25) * 0.25 - (freshness / 0.5)
	RankingExpression    string   `protobuf:"bytes,2,opt,name=ranking_expression,json=rankingExpression,proto3" json:"ranking_expression,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchJobsRequest_CustomRankingInfo) Reset()         { *m = SearchJobsRequest_CustomRankingInfo{} }
func (m *SearchJobsRequest_CustomRankingInfo) String() string { return proto.CompactTextString(m) }
func (*SearchJobsRequest_CustomRankingInfo) ProtoMessage()    {}
func (*SearchJobsRequest_CustomRankingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{7, 0}
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Unmarshal(m, b)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Marshal(b, m, deterministic)
}
func (dst *SearchJobsRequest_CustomRankingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Merge(dst, src)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_Size() int {
	return xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Size(m)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsRequest_CustomRankingInfo proto.InternalMessageInfo

func (m *SearchJobsRequest_CustomRankingInfo) GetImportanceLevel() SearchJobsRequest_CustomRankingInfo_ImportanceLevel {
	if m != nil {
		return m.ImportanceLevel
	}
	return SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED
}

func (m *SearchJobsRequest_CustomRankingInfo) GetRankingExpression() string {
	if m != nil {
		return m.RankingExpression
	}
	return ""
}

// Output only.
//
// Response for SearchJob method.
type SearchJobsResponse struct {
	// The Job entities that match the specified
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	MatchingJobs []*SearchJobsResponse_MatchingJob `protobuf:"bytes,1,rep,name=matching_jobs,json=matchingJobs,proto3" json:"matching_jobs,omitempty"`
	// The histogram results that match with specified
	// [SearchJobsRequest.histogram_queries][google.cloud.talent.v4beta1.SearchJobsRequest.histogram_queries].
	HistogramQueryResults []*HistogramQueryResult `protobuf:"bytes,2,rep,name=histogram_query_results,json=histogramQueryResults,proto3" json:"histogram_query_results,omitempty"`
	// The token that specifies the starting position of the next page of results.
	// This field is empty if there are no more results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The location filters that the service applied to the specified query. If
	// any filters are lat-lng based, the [JobLocation.location_type][] is
	// [JobLocation.LocationType#LOCATION_TYPE_UNSPECIFIED][].
	LocationFilters []*Location `protobuf:"bytes,4,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// An estimation of the number of jobs that match the specified query.
	//
	// This number isn't guaranteed to be accurate. For accurate results,
	// see [enable_precise_result_size][].
	EstimatedTotalSize int32 `protobuf:"varint,5,opt,name=estimated_total_size,json=estimatedTotalSize,proto3" json:"estimated_total_size,omitempty"`
	// The precise result count, which is available only if the client set
	// [enable_precise_result_size][] to `true`, or if the response
	// is the last page of results. Otherwise, the value is `-1`.
	TotalSize int32 `protobuf:"varint,6,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *ResponseMetadata `protobuf:"bytes,7,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// If query broadening is enabled, we may append additional results from the
	// broadened query. This number indicates how many of the jobs returned in the
	// jobs field are from the broadened query. These results are always at the
	// end of the jobs list. In particular, a value of 0, or if the field isn't
	// set, all the jobs in the jobs list are from the original
	// (without broadening) query. If this field is non-zero, subsequent requests
	// with offset after this result set should contain all broadened results.
	BroadenedQueryJobsCount int32 `protobuf:"varint,8,opt,name=broadened_query_jobs_count,json=broadenedQueryJobsCount,proto3" json:"broadened_query_jobs_count,omitempty"`
	// The spell checking result, and correction.
	SpellCorrection      *SpellingCorrection `protobuf:"bytes,9,opt,name=spell_correction,json=spellCorrection,proto3" json:"spell_correction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SearchJobsResponse) Reset()         { *m = SearchJobsResponse{} }
func (m *SearchJobsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchJobsResponse) ProtoMessage()    {}
func (*SearchJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{8}
}
func (m *SearchJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsResponse.Unmarshal(m, b)
}
func (m *SearchJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsResponse.Marshal(b, m, deterministic)
}
func (dst *SearchJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsResponse.Merge(dst, src)
}
func (m *SearchJobsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchJobsResponse.Size(m)
}
func (m *SearchJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsResponse proto.InternalMessageInfo

func (m *SearchJobsResponse) GetMatchingJobs() []*SearchJobsResponse_MatchingJob {
	if m != nil {
		return m.MatchingJobs
	}
	return nil
}

func (m *SearchJobsResponse) GetHistogramQueryResults() []*HistogramQueryResult {
	if m != nil {
		return m.HistogramQueryResults
	}
	return nil
}

func (m *SearchJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchJobsResponse) GetLocationFilters() []*Location {
	if m != nil {
		return m.LocationFilters
	}
	return nil
}

func (m *SearchJobsResponse) GetEstimatedTotalSize() int32 {
	if m != nil {
		return m.EstimatedTotalSize
	}
	return 0
}

func (m *SearchJobsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

func (m *SearchJobsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SearchJobsResponse) GetBroadenedQueryJobsCount() int32 {
	if m != nil {
		return m.BroadenedQueryJobsCount
	}
	return 0
}

func (m *SearchJobsResponse) GetSpellCorrection() *SpellingCorrection {
	if m != nil {
		return m.SpellCorrection
	}
	return nil
}

// Output only.
//
// Job entry with metadata inside
// [SearchJobsResponse][google.cloud.talent.v4beta1.SearchJobsResponse].
type SearchJobsResponse_MatchingJob struct {
	// Job resource that matches the specified
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// A summary of the job with core information that's displayed on the search
	// results listing page.
	JobSummary string `protobuf:"bytes,2,opt,name=job_summary,json=jobSummary,proto3" json:"job_summary,omitempty"`
	// Contains snippets of text from the [Job.job_title][] field most
	// closely matching a search query's keywords, if available. The matching
	// query keywords are enclosed in HTML bold tags.
	JobTitleSnippet string `protobuf:"bytes,3,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	// Contains snippets of text from the
	// [Job.description][google.cloud.talent.v4beta1.Job.description] and
	// similar fields that most closely match a search query's keywords, if
	// available. All HTML tags in the original fields are stripped when
	// returned in this field, and matching query keywords are enclosed in HTML
	// bold tags.
	SearchTextSnippet string `protobuf:"bytes,4,opt,name=search_text_snippet,json=searchTextSnippet,proto3" json:"search_text_snippet,omitempty"`
	// Commute information which is generated based on specified
	//  [CommuteFilter][google.cloud.talent.v4beta1.CommuteFilter].
	CommuteInfo          *SearchJobsResponse_CommuteInfo `protobuf:"bytes,5,opt,name=commute_info,json=commuteInfo,proto3" json:"commute_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SearchJobsResponse_MatchingJob) Reset()         { *m = SearchJobsResponse_MatchingJob{} }
func (m *SearchJobsResponse_MatchingJob) String() string { return proto.CompactTextString(m) }
func (*SearchJobsResponse_MatchingJob) ProtoMessage()    {}
func (*SearchJobsResponse_MatchingJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{8, 0}
}
func (m *SearchJobsResponse_MatchingJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsResponse_MatchingJob.Unmarshal(m, b)
}
func (m *SearchJobsResponse_MatchingJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsResponse_MatchingJob.Marshal(b, m, deterministic)
}
func (dst *SearchJobsResponse_MatchingJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsResponse_MatchingJob.Merge(dst, src)
}
func (m *SearchJobsResponse_MatchingJob) XXX_Size() int {
	return xxx_messageInfo_SearchJobsResponse_MatchingJob.Size(m)
}
func (m *SearchJobsResponse_MatchingJob) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsResponse_MatchingJob.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsResponse_MatchingJob proto.InternalMessageInfo

func (m *SearchJobsResponse_MatchingJob) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *SearchJobsResponse_MatchingJob) GetJobSummary() string {
	if m != nil {
		return m.JobSummary
	}
	return ""
}

func (m *SearchJobsResponse_MatchingJob) GetJobTitleSnippet() string {
	if m != nil {
		return m.JobTitleSnippet
	}
	return ""
}

func (m *SearchJobsResponse_MatchingJob) GetSearchTextSnippet() string {
	if m != nil {
		return m.SearchTextSnippet
	}
	return ""
}

func (m *SearchJobsResponse_MatchingJob) GetCommuteInfo() *SearchJobsResponse_CommuteInfo {
	if m != nil {
		return m.CommuteInfo
	}
	return nil
}

// Output only.
//
// Commute details related to this job.
type SearchJobsResponse_CommuteInfo struct {
	// Location used as the destination in the commute calculation.
	JobLocation *Location `protobuf:"bytes,1,opt,name=job_location,json=jobLocation,proto3" json:"job_location,omitempty"`
	// The number of seconds required to travel to the job location from the
	// query location. A duration of 0 seconds indicates that the job isn't
	// reachable within the requested duration, but was returned as part of an
	// expanded query.
	TravelDuration       *duration.Duration `protobuf:"bytes,2,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SearchJobsResponse_CommuteInfo) Reset()         { *m = SearchJobsResponse_CommuteInfo{} }
func (m *SearchJobsResponse_CommuteInfo) String() string { return proto.CompactTextString(m) }
func (*SearchJobsResponse_CommuteInfo) ProtoMessage()    {}
func (*SearchJobsResponse_CommuteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_job_service_259db9e6c393408c, []int{8, 1}
}
func (m *SearchJobsResponse_CommuteInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsResponse_CommuteInfo.Unmarshal(m, b)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsResponse_CommuteInfo.Marshal(b, m, deterministic)
}
func (dst *SearchJobsResponse_CommuteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsResponse_CommuteInfo.Merge(dst, src)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_Size() int {
	return xxx_messageInfo_SearchJobsResponse_CommuteInfo.Size(m)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsResponse_CommuteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsResponse_CommuteInfo proto.InternalMessageInfo

func (m *SearchJobsResponse_CommuteInfo) GetJobLocation() *Location {
	if m != nil {
		return m.JobLocation
	}
	return nil
}

func (m *SearchJobsResponse_CommuteInfo) GetTravelDuration() *duration.Duration {
	if m != nil {
		return m.TravelDuration
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateJobRequest)(nil), "google.cloud.talent.v4beta1.CreateJobRequest")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.talent.v4beta1.GetJobRequest")
	proto.RegisterType((*UpdateJobRequest)(nil), "google.cloud.talent.v4beta1.UpdateJobRequest")
	proto.RegisterType((*DeleteJobRequest)(nil), "google.cloud.talent.v4beta1.DeleteJobRequest")
	proto.RegisterType((*BatchDeleteJobsRequest)(nil), "google.cloud.talent.v4beta1.BatchDeleteJobsRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.talent.v4beta1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.talent.v4beta1.ListJobsResponse")
	proto.RegisterType((*SearchJobsRequest)(nil), "google.cloud.talent.v4beta1.SearchJobsRequest")
	proto.RegisterType((*SearchJobsRequest_CustomRankingInfo)(nil), "google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo")
	proto.RegisterType((*SearchJobsResponse)(nil), "google.cloud.talent.v4beta1.SearchJobsResponse")
	proto.RegisterType((*SearchJobsResponse_MatchingJob)(nil), "google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob")
	proto.RegisterType((*SearchJobsResponse_CommuteInfo)(nil), "google.cloud.talent.v4beta1.SearchJobsResponse.CommuteInfo")
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobView", JobView_name, JobView_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.SearchJobsRequest_SearchMode", SearchJobsRequest_SearchMode_name, SearchJobsRequest_SearchMode_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.SearchJobsRequest_DiversificationLevel", SearchJobsRequest_DiversificationLevel_name, SearchJobsRequest_DiversificationLevel_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.SearchJobsRequest_CustomRankingInfo_ImportanceLevel", SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name, SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists jobs by filter.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Deletes a list of [Job][google.cloud.talent.v4beta1.Job]s by filter.
	BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs that the caller has permission to
	// search against.
	SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), and has different algorithmic
	// adjustments that are targeted to passive job seekers.
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs the caller has permission to search
	// against.
	SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/CreateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/DeleteJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchDeleteJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/SearchJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/SearchJobsForAlert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(context.Context, *DeleteJobRequest) (*empty.Empty, error)
	// Lists jobs by filter.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Deletes a list of [Job][google.cloud.talent.v4beta1.Job]s by filter.
	BatchDeleteJobs(context.Context, *BatchDeleteJobsRequest) (*empty.Empty, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs that the caller has permission to
	// search against.
	SearchJobs(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), and has different algorithmic
	// adjustments that are targeted to passive job seekers.
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs the caller has permission to search
	// against.
	SearchJobsForAlert(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/DeleteJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchDeleteJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchDeleteJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, req.(*BatchDeleteJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/SearchJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobs(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobsForAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/SearchJobsForAlert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobService_UpdateJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobService_DeleteJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "BatchDeleteJobs",
			Handler:    _JobService_BatchDeleteJobs_Handler,
		},
		{
			MethodName: "SearchJobs",
			Handler:    _JobService_SearchJobs_Handler,
		},
		{
			MethodName: "SearchJobsForAlert",
			Handler:    _JobService_SearchJobsForAlert_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/job_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/job_service.proto", fileDescriptor_job_service_259db9e6c393408c)
}

var fileDescriptor_job_service_259db9e6c393408c = []byte{
	// 1805 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x4f, 0x73, 0xdb, 0xc6,
	0x15, 0x2f, 0xa8, 0x7f, 0xe4, 0xa3, 0x24, 0x42, 0x6b, 0xc5, 0x66, 0xa8, 0xb4, 0x51, 0xe8, 0xda,
	0x55, 0xe4, 0x88, 0x74, 0xe8, 0x74, 0xa6, 0x8d, 0x26, 0xd3, 0xf2, 0x0f, 0x14, 0xc1, 0x25, 0x25,
	0x16, 0xa4, 0xec, 0xd4, 0x87, 0xa0, 0x20, 0xb8, 0xa2, 0x20, 0x81, 0x58, 0x04, 0x58, 0xca, 0x56,
	0x32, 0x3e, 0xb4, 0xbd, 0xf5, 0xd0, 0x43, 0x7b, 0xe9, 0x4c, 0x67, 0x72, 0xc8, 0x47, 0xe8, 0x74,
	0xa6, 0x87, 0xce, 0xf4, 0x2b, 0xf4, 0xd0, 0xaf, 0xd0, 0x0f, 0xd2, 0xd9, 0x3f, 0x80, 0x48, 0x9a,
	0x26, 0x29, 0x7b, 0x72, 0xe3, 0xbe, 0xf7, 0xdb, 0xb7, 0xbf, 0xf7, 0x07, 0x6f, 0xf7, 0x11, 0xf6,
	0x7a, 0x84, 0xf4, 0x5c, 0x5c, 0xb4, 0x5d, 0x32, 0xe8, 0x16, 0xa9, 0xe5, 0x62, 0x8f, 0x16, 0x2f,
	0x3f, 0xe9, 0x60, 0x6a, 0x7d, 0x5c, 0x3c, 0x27, 0x1d, 0x33, 0xc4, 0xc1, 0xa5, 0x63, 0xe3, 0x82,
	0x1f, 0x10, 0x4a, 0xd0, 0x96, 0x80, 0x17, 0x38, 0xbc, 0x20, 0xe0, 0x05, 0x09, 0xcf, 0xbd, 0x27,
	0x6d, 0x59, 0xbe, 0x53, 0xb4, 0x3c, 0x8f, 0x50, 0x8b, 0x3a, 0xc4, 0x0b, 0xc5, 0xd6, 0xdc, 0x4f,
	0xa6, 0x9d, 0xd4, 0xb1, 0xa8, 0x7d, 0x26, 0x81, 0x3b, 0xd3, 0x80, 0x36, 0xe9, 0xf7, 0x89, 0x27,
	0x91, 0x1f, 0x4e, 0x43, 0x9e, 0x3a, 0x2e, 0xc5, 0x41, 0x74, 0xfa, 0x83, 0x69, 0xd0, 0x33, 0x27,
	0xa4, 0xa4, 0x17, 0x58, 0x7d, 0x09, 0xbe, 0x37, 0x23, 0x28, 0x12, 0x76, 0x57, 0xc2, 0x5c, 0xe2,
	0xf5, 0x82, 0x81, 0xe7, 0x39, 0x5e, 0xaf, 0x48, 0x7c, 0x1c, 0x8c, 0xb8, 0xfd, 0x23, 0x09, 0xe2,
	0xab, 0xce, 0xe0, 0xb4, 0xd8, 0x1d, 0x08, 0x80, 0xd4, 0x6f, 0x8d, 0xeb, 0x71, 0xdf, 0xa7, 0x57,
	0x52, 0xb9, 0x3d, 0xae, 0x3c, 0x75, 0xb0, 0xdb, 0x35, 0xfb, 0x56, 0x78, 0x21, 0x10, 0xf9, 0x2f,
	0x41, 0xad, 0x06, 0xd8, 0xa2, 0xf8, 0x31, 0xe9, 0x18, 0xf8, 0xab, 0x01, 0x0e, 0x29, 0xba, 0x0d,
	0xcb, 0xbe, 0x15, 0x60, 0x8f, 0x66, 0x95, 0x6d, 0x65, 0x27, 0x65, 0xc8, 0x15, 0x2a, 0xc1, 0xc2,
	0x39, 0xe9, 0x64, 0x13, 0xdb, 0xca, 0x4e, 0xba, 0xb4, 0x5d, 0x98, 0x92, 0xca, 0x02, 0xb3, 0xc6,
	0xc0, 0xf9, 0xbb, 0xb0, 0xf6, 0x39, 0xa6, 0x43, 0xc6, 0x11, 0x2c, 0x7a, 0x56, 0x1f, 0x4b, 0xd3,
	0xfc, 0x77, 0xfe, 0x0f, 0x0a, 0xa8, 0x27, 0x7e, 0x77, 0x94, 0x85, 0x3c, 0x4d, 0xb9, 0xc1, 0x69,
	0x68, 0x1f, 0xd2, 0x03, 0x6e, 0x87, 0xbb, 0x28, 0x99, 0xe6, 0xa2, 0xbd, 0x51, 0x14, 0x0a, 0x07,
	0x2c, 0x0a, 0x0d, 0x2b, 0xbc, 0x30, 0x40, 0xc0, 0xd9, 0xef, 0xfc, 0x7d, 0x50, 0x6b, 0xd8, 0xc5,
	0x23, 0x24, 0x26, 0xb1, 0x3d, 0x84, 0xdb, 0x15, 0x56, 0x6e, 0x31, 0x38, 0x9c, 0x15, 0xb8, 0xdb,
	0xb0, 0x2c, 0xaa, 0x89, 0x33, 0x4a, 0x19, 0x72, 0x95, 0xff, 0xb7, 0x02, 0x99, 0xba, 0x13, 0xd2,
	0xb7, 0xb0, 0x81, 0x7e, 0x08, 0xe0, 0x5b, 0x3d, 0x6c, 0x52, 0x72, 0x81, 0xbd, 0xec, 0x02, 0xd7,
	0xa5, 0x98, 0xa4, 0xcd, 0x04, 0x68, 0x0b, 0xf8, 0xc2, 0x0c, 0x9d, 0xaf, 0x71, 0x76, 0x71, 0x5b,
	0xd9, 0x59, 0x32, 0x92, 0x4c, 0xd0, 0x72, 0xbe, 0xc6, 0xe8, 0x17, 0x90, 0x64, 0x9f, 0xe8, 0xa5,
	0x83, 0x9f, 0x67, 0x97, 0xb6, 0x95, 0x9d, 0xf5, 0xd2, 0x8f, 0x67, 0xc5, 0xf9, 0x89, 0x83, 0x9f,
	0x1b, 0x2b, 0xe7, 0xe2, 0x47, 0xfe, 0x5f, 0x0a, 0xa8, 0xd7, 0x0e, 0x84, 0x3e, 0xf1, 0x42, 0x8c,
	0x3e, 0x81, 0xc5, 0x73, 0xd2, 0x09, 0xb3, 0xca, 0xf6, 0xc2, 0x5c, 0x99, 0xe3, 0x68, 0x74, 0x1f,
	0x32, 0x1e, 0x7e, 0x41, 0xcd, 0x21, 0x67, 0x84, 0xa3, 0x6b, 0x4c, 0xdc, 0x8c, 0x1d, 0xd2, 0x21,
	0xd9, 0xc7, 0xd4, 0xea, 0x5a, 0xd4, 0xe2, 0xde, 0xa6, 0x4b, 0x7b, 0x53, 0x4f, 0x88, 0x68, 0x35,
	0xe4, 0x26, 0x23, 0xde, 0x9e, 0xff, 0x36, 0x0d, 0x1b, 0x2d, 0x6c, 0x05, 0xf6, 0xd9, 0x3c, 0x09,
	0x78, 0x06, 0xe9, 0x90, 0x83, 0xcd, 0x3e, 0xe9, 0x62, 0x4e, 0x6e, 0xbd, 0xf4, 0xf3, 0xa9, 0x67,
	0xbf, 0x62, 0x5c, 0x4a, 0x1a, 0xa4, 0x8b, 0x0d, 0x08, 0xe3, 0xdf, 0xe8, 0x29, 0xa8, 0x81, 0x40,
	0x98, 0x63, 0xce, 0x7d, 0x34, 0xc3, 0x39, 0xbe, 0x29, 0xf6, 0x2d, 0x13, 0x8c, 0x0a, 0x50, 0x05,
	0x52, 0x2c, 0xc3, 0x5f, 0x0d, 0x70, 0x70, 0xc5, 0xd3, 0x9f, 0x2e, 0xdd, 0x9b, 0x95, 0x90, 0x5f,
	0x33, 0xb0, 0xc1, 0x2a, 0x83, 0xff, 0x42, 0x0f, 0x60, 0x03, 0x7b, 0x56, 0xc7, 0xc5, 0x66, 0x27,
	0x20, 0x56, 0x17, 0xb3, 0x3e, 0xc5, 0xcb, 0x25, 0x69, 0xa8, 0x42, 0x51, 0x89, 0xe5, 0xe8, 0x33,
	0xd8, 0x62, 0x1c, 0x9c, 0x00, 0x9b, 0x7e, 0x80, 0x6d, 0x27, 0xc4, 0x66, 0x80, 0xc3, 0x81, 0x4b,
	0x45, 0x05, 0x2e, 0xf3, 0x6d, 0x59, 0x09, 0x69, 0x0a, 0x84, 0xc1, 0x01, 0xbc, 0x22, 0xbf, 0x80,
	0x8d, 0xb8, 0x99, 0x72, 0xd6, 0x0e, 0x0e, 0xb3, 0x2b, 0xbc, 0x90, 0x1e, 0x4c, 0xe5, 0x7d, 0x18,
	0xed, 0x12, 0xec, 0xd5, 0xb3, 0xe1, 0xb5, 0x83, 0xc3, 0x91, 0x5a, 0x4f, 0xbe, 0x41, 0xad, 0xb3,
	0xba, 0x20, 0xa7, 0xa7, 0x21, 0xa6, 0xd9, 0x14, 0xff, 0x8c, 0xe4, 0x6a, 0xf4, 0x0b, 0x83, 0xb1,
	0x2f, 0x6c, 0xf4, 0xeb, 0x4c, 0x8f, 0x7f, 0x9d, 0xef, 0x42, 0x92, 0x04, 0x5d, 0x1c, 0x98, 0x9d,
	0xab, 0xec, 0x2a, 0x57, 0xae, 0xf0, 0x75, 0xe5, 0x0a, 0xbd, 0x80, 0x77, 0xba, 0xce, 0x25, 0x0e,
	0x42, 0xe7, 0xd4, 0xb1, 0x79, 0xc3, 0x37, 0x5d, 0x7c, 0x89, 0xdd, 0xec, 0x1a, 0x27, 0x5f, 0xbd,
	0x61, 0xe1, 0xd5, 0x46, 0x6d, 0xd5, 0x99, 0x29, 0x63, 0xb3, 0x3b, 0x41, 0x8a, 0x7c, 0xb8, 0x65,
	0x0f, 0x42, 0x4a, 0xfa, 0x66, 0x60, 0x79, 0x17, 0x8e, 0xd7, 0x33, 0x1d, 0xef, 0x94, 0x64, 0xd7,
	0x79, 0xf5, 0xfc, 0xf2, 0x86, 0xe7, 0x56, 0xb9, 0x25, 0x43, 0x18, 0xd2, 0xbd, 0x53, 0x62, 0x6c,
	0xd8, 0xe3, 0x22, 0x54, 0x62, 0xbe, 0x86, 0xbc, 0xc4, 0x2e, 0xf0, 0xd5, 0x73, 0x12, 0xb0, 0x2b,
	0x8a, 0xda, 0x67, 0x59, 0x95, 0x97, 0xcb, 0x2d, 0xa9, 0xfc, 0x95, 0xd0, 0x35, 0x98, 0x2a, 0xf7,
	0x8f, 0x04, 0x6c, 0xbc, 0x62, 0x1c, 0x7d, 0x03, 0xaa, 0xd3, 0xf7, 0x49, 0x40, 0x2d, 0xcf, 0xc6,
	0x32, 0x60, 0x0a, 0x0f, 0x58, 0xf3, 0x6d, 0x89, 0x17, 0xf4, 0xd8, 0xb0, 0x88, 0x5e, 0xc6, 0x19,
	0x15, 0xa0, 0x3d, 0x40, 0x51, 0xc4, 0xf0, 0x0b, 0x3f, 0xc0, 0x61, 0xe8, 0x90, 0xa8, 0x8b, 0x6d,
	0x48, 0x8d, 0x16, 0x2b, 0xf2, 0x21, 0x64, 0xc6, 0x4c, 0xa2, 0x6d, 0x78, 0x4f, 0x6f, 0x34, 0x8f,
	0x8d, 0x76, 0xf9, 0xa8, 0xaa, 0x99, 0x75, 0xed, 0x89, 0x56, 0x37, 0x4f, 0x8e, 0x5a, 0x4d, 0xad,
	0xaa, 0x1f, 0xe8, 0x5a, 0x4d, 0xfd, 0x01, 0x4a, 0xc2, 0xe2, 0xd1, 0xf1, 0x91, 0xa6, 0x2a, 0x68,
	0x05, 0x16, 0xea, 0xc7, 0x4f, 0xd5, 0x04, 0x13, 0x35, 0xf4, 0x7a, 0x4d, 0x5d, 0x40, 0x00, 0xcb,
	0x0d, 0xad, 0xa6, 0x9f, 0x34, 0xd4, 0x45, 0x26, 0x3d, 0xd4, 0x3f, 0x3f, 0x54, 0x97, 0x50, 0x1a,
	0x56, 0xb4, 0x2f, 0xda, 0x86, 0xd6, 0xd0, 0xd4, 0xe5, 0xbc, 0x01, 0x70, 0xdd, 0x83, 0xd0, 0x16,
	0xdc, 0x69, 0x69, 0x65, 0xa3, 0x7a, 0x68, 0x36, 0x8e, 0x6b, 0xda, 0xd8, 0x51, 0xeb, 0x00, 0x8f,
	0x8f, 0x2b, 0xa6, 0x00, 0xa8, 0x0a, 0xba, 0x03, 0xb7, 0x0e, 0xb4, 0x72, 0xfb, 0xc4, 0xd0, 0x6a,
	0xe6, 0x90, 0x22, 0x91, 0x7f, 0x0a, 0x9b, 0x93, 0xca, 0x0b, 0xdd, 0x83, 0x0f, 0x6a, 0xfa, 0x13,
	0xcd, 0x68, 0xe9, 0x07, 0x7a, 0xb5, 0xdc, 0xd6, 0x8f, 0x8f, 0x26, 0xba, 0xb4, 0x0a, 0xc9, 0x9a,
	0xde, 0x2a, 0x57, 0xea, 0x5a, 0x4d, 0x55, 0x98, 0x0f, 0x2d, 0xbd, 0xd1, 0xac, 0x6b, 0x6a, 0x22,
	0xff, 0x9f, 0x24, 0xa0, 0xe1, 0xcc, 0xc8, 0x0b, 0xe6, 0xb7, 0xb0, 0xc6, 0xcb, 0x83, 0x05, 0x7a,
	0xe8, 0xa6, 0xd9, 0x9f, 0x3b, 0xc3, 0xc2, 0x4e, 0xa1, 0x21, 0x8d, 0xb0, 0x4b, 0x68, 0xb5, 0x7f,
	0xbd, 0x08, 0x91, 0x03, 0x77, 0x46, 0xdb, 0xd0, 0x95, 0xec, 0x62, 0x61, 0x36, 0xc1, 0xcf, 0xfa,
	0xf8, 0x26, 0xcd, 0x88, 0xef, 0x34, 0xde, 0x39, 0x9b, 0x20, 0x9d, 0x78, 0xef, 0x2d, 0x4c, 0xba,
	0xf7, 0x9a, 0xa0, 0xba, 0x44, 0x36, 0x02, 0xf9, 0x34, 0xcd, 0x2e, 0x72, 0x2e, 0xd3, 0x1b, 0x7a,
	0x5d, 0x6e, 0x32, 0x32, 0xd1, 0xf6, 0x03, 0xb1, 0x1b, 0x3d, 0x84, 0x4d, 0x1c, 0x52, 0xa7, 0x6f,
	0x51, 0xdc, 0x35, 0x29, 0xa1, 0x96, 0x2b, 0x7a, 0xd8, 0x12, 0xef, 0x61, 0x28, 0xd6, 0xb5, 0x99,
	0x2a, 0xea, 0x66, 0x43, 0xb8, 0x65, 0x8e, 0x4b, 0xd1, 0x58, 0x3d, 0x7c, 0x35, 0xaf, 0xbc, 0xd5,
	0xd5, 0x8c, 0xf6, 0x21, 0x27, 0x2f, 0x1b, 0xdc, 0x95, 0x09, 0x60, 0x99, 0x36, 0x6d, 0x32, 0xf0,
	0x28, 0xef, 0xdf, 0x4b, 0xc6, 0x9d, 0x18, 0xc1, 0x03, 0xca, 0x12, 0x57, 0x65, 0x6a, 0xf4, 0x0c,
	0xd4, 0xd0, 0xc7, 0xae, 0x6b, 0xda, 0x24, 0x08, 0xb0, 0xcd, 0x7c, 0xe6, 0x3d, 0x3b, 0x5d, 0x2a,
	0x4e, 0x2f, 0x11, 0xb6, 0xc9, 0xf1, 0x7a, 0xd5, 0x78, 0x9b, 0x91, 0xe1, 0x86, 0xae, 0x05, 0xb9,
	0x6f, 0x13, 0x90, 0x1e, 0xaa, 0x9b, 0x37, 0x7a, 0xa5, 0xbe, 0x0f, 0x69, 0x3e, 0x19, 0x0d, 0xfa,
	0x7d, 0x2b, 0xb8, 0x92, 0x0d, 0x02, 0xce, 0x49, 0xa7, 0x25, 0x24, 0x68, 0x17, 0x36, 0x18, 0x80,
	0x3a, 0xd4, 0xc5, 0x66, 0xe8, 0x39, 0xbe, 0x8f, 0xa9, 0xac, 0x8a, 0xcc, 0x39, 0xe9, 0xb4, 0x99,
	0xbc, 0x25, 0xc4, 0xa8, 0x00, 0xb7, 0xe4, 0xb3, 0x84, 0xb2, 0x32, 0x8a, 0xd0, 0x8b, 0xa2, 0xeb,
	0x08, 0x55, 0x1b, 0xbf, 0xa0, 0x11, 0xfe, 0x4b, 0x58, 0x65, 0x33, 0xd0, 0x80, 0x62, 0xd1, 0xd6,
	0x97, 0x38, 0xf3, 0x1b, 0x7f, 0x3b, 0x55, 0x61, 0x83, 0x77, 0xf4, 0xb4, 0x7d, 0xbd, 0xc8, 0xfd,
	0x4d, 0x81, 0xf4, 0x90, 0x12, 0x1d, 0xc2, 0x2a, 0xf3, 0x25, 0x2a, 0x3e, 0x19, 0xa9, 0x39, 0x6b,
	0x96, 0xc5, 0x29, 0x5a, 0xa0, 0x0a, 0x64, 0x68, 0x60, 0x5d, 0x62, 0xd7, 0x8c, 0x46, 0x20, 0xf9,
	0xc0, 0x7f, 0xf7, 0x95, 0x07, 0x7e, 0x4d, 0x02, 0x8c, 0x75, 0xb1, 0x23, 0x5a, 0xef, 0x5e, 0xc2,
	0x8a, 0xbc, 0xd8, 0x51, 0x16, 0x36, 0x59, 0x17, 0x7b, 0xa2, 0x6b, 0x4f, 0xc7, 0x1a, 0xd2, 0x26,
	0xa8, 0xb1, 0x46, 0xaf, 0x99, 0xc7, 0x47, 0xf5, 0xdf, 0xa8, 0xca, 0x88, 0xb4, 0xa1, 0x1f, 0xe9,
	0x8d, 0x72, 0x5d, 0x4d, 0x20, 0x04, 0xeb, 0xb1, 0xb4, 0xd5, 0x28, 0xd7, 0xeb, 0xea, 0x02, 0xda,
	0x80, 0xb5, 0x58, 0x76, 0x70, 0x52, 0xaf, 0xab, 0x8b, 0xa5, 0x7f, 0xa6, 0x00, 0x1e, 0x93, 0x4e,
	0x4b, 0x0c, 0xc3, 0xe8, 0x8f, 0x0a, 0xa4, 0xe2, 0xb1, 0x0b, 0x4d, 0xff, 0x4a, 0xc6, 0xc7, 0xb3,
	0xdc, 0xcc, 0x2a, 0xcb, 0x7f, 0xf4, 0xfb, 0xff, 0xfe, 0xef, 0x2f, 0x89, 0xfb, 0xf9, 0x0f, 0xe2,
	0xa1, 0xf3, 0x1b, 0xf1, 0x88, 0xfd, 0xcc, 0x0f, 0xc8, 0x39, 0xb6, 0x69, 0x58, 0xdc, 0x7d, 0xc9,
	0x06, 0xd1, 0xf0, 0x53, 0x65, 0x17, 0xfd, 0x4e, 0x81, 0x65, 0x31, 0xa3, 0xa1, 0xdd, 0xa9, 0xa6,
	0x47, 0x06, 0xb9, 0x39, 0x68, 0x7c, 0xc8, 0x69, 0xdc, 0x45, 0x43, 0x34, 0xd8, 0x00, 0x35, 0x44,
	0x82, 0x73, 0x28, 0xee, 0xbe, 0x44, 0x7f, 0x52, 0x20, 0x15, 0x4f, 0x80, 0x33, 0x02, 0x32, 0x3e,
	0x29, 0xce, 0xc1, 0xe4, 0x21, 0x67, 0xb2, 0x5b, 0xba, 0x77, 0xcd, 0x84, 0x8d, 0xe1, 0xaf, 0x61,
	0xc3, 0x82, 0xf2, 0x12, 0x52, 0xf1, 0x7c, 0x37, 0x83, 0xcf, 0xf8, 0xd0, 0x98, 0xbb, 0xfd, 0x4a,
	0x3d, 0x6a, 0x6c, 0x26, 0x8f, 0xe2, 0xb1, 0x3b, 0x47, 0x3c, 0xfe, 0xac, 0x40, 0x32, 0x1a, 0xac,
	0xd0, 0xf4, 0x19, 0x60, 0x6c, 0x80, 0xcc, 0xed, 0xcd, 0x89, 0x16, 0x1f, 0xf2, 0xa4, 0x24, 0xbd,
	0xa6, 0x56, 0xd0, 0x5f, 0x15, 0xc8, 0x8c, 0x4d, 0xbe, 0xe8, 0xd1, 0xd4, 0xd3, 0x26, 0xcf, 0xc9,
	0xaf, 0x0d, 0xd0, 0xcf, 0x38, 0x97, 0x52, 0x7e, 0x6f, 0x76, 0xdd, 0x76, 0xae, 0x2d, 0xb3, 0x74,
	0x7d, 0xa7, 0x44, 0xef, 0x1a, 0xce, 0xaa, 0x70, 0xb3, 0xc7, 0x5e, 0xae, 0x78, 0xc3, 0xf6, 0x97,
	0x7f, 0xc4, 0x99, 0xee, 0xe5, 0x77, 0x66, 0x33, 0x15, 0x2d, 0x98, 0x91, 0xfc, 0xbb, 0x32, 0xfc,
	0x9c, 0x39, 0x20, 0x41, 0xd9, 0xc5, 0x01, 0xfd, 0xfe, 0xc9, 0xee, 0x73, 0xb2, 0x3f, 0xcd, 0x3f,
	0x9c, 0x97, 0x6c, 0x44, 0xed, 0x53, 0x65, 0xb7, 0xf2, 0x12, 0xde, 0xb7, 0x49, 0x7f, 0xda, 0x91,
	0x95, 0xcc, 0x75, 0x67, 0x6b, 0xb2, 0x84, 0x36, 0x95, 0x67, 0x65, 0x89, 0xef, 0x11, 0xd7, 0xf2,
	0x7a, 0x05, 0x12, 0xf4, 0x8a, 0x3d, 0xec, 0xf1, 0x74, 0x17, 0x85, 0xca, 0xf2, 0x9d, 0x70, 0xe2,
	0x1f, 0x64, 0xfb, 0x62, 0xf9, 0x5d, 0x62, 0xa1, 0xda, 0x6e, 0x75, 0x96, 0xf9, 0x9e, 0x47, 0xff,
	0x0f, 0x00, 0x00, 0xff, 0xff, 0x51, 0xce, 0x76, 0x0b, 0x68, 0x14, 0x00, 0x00,
}
