// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/tenant.proto

package talent

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum that represents how user data owned by the tenant is used.
type Tenant_DataUsageType int32

const (
	// Default value.
	Tenant_DATA_USAGE_TYPE_UNSPECIFIED Tenant_DataUsageType = 0
	// Data owned by this tenant is used to improve search/recommendation
	// quality across tenants.
	Tenant_AGGREGATED Tenant_DataUsageType = 1
	// Data owned by this tenant is used to improve search/recommendation
	// quality for this tenant only.
	Tenant_ISOLATED Tenant_DataUsageType = 2
)

var Tenant_DataUsageType_name = map[int32]string{
	0: "DATA_USAGE_TYPE_UNSPECIFIED",
	1: "AGGREGATED",
	2: "ISOLATED",
}

var Tenant_DataUsageType_value = map[string]int32{
	"DATA_USAGE_TYPE_UNSPECIFIED": 0,
	"AGGREGATED":                  1,
	"ISOLATED":                    2,
}

func (x Tenant_DataUsageType) String() string {
	return proto.EnumName(Tenant_DataUsageType_name, int32(x))
}

func (Tenant_DataUsageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4b0da31c41aea5f3, []int{0, 0}
}

// A Tenant resource represents a tenant in the service. A tenant is a group or
// entity that shares common access with specific privileges for resources like
// profiles. Customer may create multiple tenants to provide data isolation for
// different groups.
type Tenant struct {
	// Required during tenant update.
	//
	// The resource name for a tenant. This is generated by the service when a
	// tenant is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenants/bar".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Client side tenant identifier, used to uniquely identify the
	// tenant.
	//
	// The maximum number of allowed characters is 255.
	ExternalId string `protobuf:"bytes,2,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Indicates whether data owned by this tenant may be used to provide product
	// improvements across other tenants.
	//
	// Defaults behavior is
	// [DataUsageType.ISOLATED][google.cloud.talent.v4beta1.Tenant.DataUsageType.ISOLATED]
	// if it's unset.
	UsageType Tenant_DataUsageType `protobuf:"varint,3,opt,name=usage_type,json=usageType,proto3,enum=google.cloud.talent.v4beta1.Tenant_DataUsageType" json:"usage_type,omitempty"`
	// A list of keys of filterable
	// [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes],
	// whose corresponding `string_values` are used in keyword searches. Profiles
	// with `string_values` under these specified field keys are returned if any
	// of the values match the search keyword. Custom field values with
	// parenthesis, brackets and special symbols are not searchable as-is,
	// and must be surrounded by quotes.
	KeywordSearchableProfileCustomAttributes []string `protobuf:"bytes,4,rep,name=keyword_searchable_profile_custom_attributes,json=keywordSearchableProfileCustomAttributes,proto3" json:"keyword_searchable_profile_custom_attributes,omitempty"`
	XXX_NoUnkeyedLiteral                     struct{} `json:"-"`
	XXX_unrecognized                         []byte   `json:"-"`
	XXX_sizecache                            int32    `json:"-"`
}

func (m *Tenant) Reset()         { *m = Tenant{} }
func (m *Tenant) String() string { return proto.CompactTextString(m) }
func (*Tenant) ProtoMessage()    {}
func (*Tenant) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b0da31c41aea5f3, []int{0}
}

func (m *Tenant) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tenant.Unmarshal(m, b)
}
func (m *Tenant) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tenant.Marshal(b, m, deterministic)
}
func (m *Tenant) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tenant.Merge(m, src)
}
func (m *Tenant) XXX_Size() int {
	return xxx_messageInfo_Tenant.Size(m)
}
func (m *Tenant) XXX_DiscardUnknown() {
	xxx_messageInfo_Tenant.DiscardUnknown(m)
}

var xxx_messageInfo_Tenant proto.InternalMessageInfo

func (m *Tenant) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tenant) GetExternalId() string {
	if m != nil {
		return m.ExternalId
	}
	return ""
}

func (m *Tenant) GetUsageType() Tenant_DataUsageType {
	if m != nil {
		return m.UsageType
	}
	return Tenant_DATA_USAGE_TYPE_UNSPECIFIED
}

func (m *Tenant) GetKeywordSearchableProfileCustomAttributes() []string {
	if m != nil {
		return m.KeywordSearchableProfileCustomAttributes
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.talent.v4beta1.Tenant_DataUsageType", Tenant_DataUsageType_name, Tenant_DataUsageType_value)
	proto.RegisterType((*Tenant)(nil), "google.cloud.talent.v4beta1.Tenant")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/tenant.proto", fileDescriptor_4b0da31c41aea5f3)
}

var fileDescriptor_4b0da31c41aea5f3 = []byte{
	// 414 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x40, 0xb1, 0x53, 0x55, 0x64, 0x81, 0xaa, 0x5a, 0x2e, 0x51, 0x8b, 0x94, 0xa8, 0xe2, 0xe0,
	0x03, 0xb2, 0x55, 0xe0, 0xc6, 0xc9, 0x49, 0x4c, 0x14, 0x09, 0x15, 0xcb, 0x76, 0x0e, 0x70, 0x60,
	0x35, 0xb6, 0x27, 0xee, 0x0a, 0x7b, 0xd7, 0x5a, 0x8f, 0x0b, 0x39, 0xf2, 0x2b, 0x7c, 0x0b, 0x1f,
	0xc2, 0xa7, 0xa0, 0x78, 0xd3, 0x0a, 0x50, 0xd5, 0xdb, 0xcc, 0xce, 0x7b, 0x3b, 0x33, 0xda, 0x65,
	0x5e, 0xa5, 0x75, 0x55, 0x63, 0x50, 0xd4, 0xba, 0x2f, 0x03, 0x82, 0x1a, 0x15, 0x05, 0x37, 0x6f,
	0x73, 0x24, 0xb8, 0x0c, 0x08, 0x15, 0x28, 0xf2, 0x5b, 0xa3, 0x49, 0xf3, 0x73, 0x4b, 0xfa, 0x03,
	0xe9, 0x5b, 0xd2, 0x3f, 0x90, 0x67, 0x2f, 0x0e, 0xd7, 0x40, 0x2b, 0x03, 0x50, 0x4a, 0x13, 0x90,
	0xd4, 0xaa, 0xb3, 0xea, 0xd9, 0xf4, 0xaf, 0xea, 0x56, 0x62, 0x5d, 0x8a, 0x1c, 0xaf, 0xe1, 0x46,
	0x6a, 0xf3, 0x1f, 0x30, 0x64, 0x79, 0xbf, 0x0d, 0x48, 0x36, 0xd8, 0x11, 0x34, 0xad, 0x05, 0x2e,
	0x7e, 0xb9, 0xec, 0x38, 0x1b, 0xa6, 0xe1, 0x9c, 0x1d, 0x29, 0x68, 0x70, 0xe2, 0xcc, 0x1c, 0x6f,
	0x9c, 0x0c, 0x31, 0x7f, 0xc9, 0x9e, 0xe0, 0x77, 0x42, 0xa3, 0xa0, 0x16, 0xb2, 0x9c, 0xb8, 0xfb,
	0xd2, 0x7c, 0xf4, 0x3b, 0x74, 0x13, 0x76, 0x7b, 0xbe, 0x2e, 0x79, 0xcc, 0x58, 0xdf, 0x41, 0x85,
	0x82, 0x76, 0x2d, 0x4e, 0x46, 0x33, 0xc7, 0x3b, 0x79, 0x7d, 0xe9, 0x3f, 0xb0, 0x96, 0x6f, 0x5b,
	0xfa, 0x4b, 0x20, 0xd8, 0xec, 0xcd, 0x6c, 0xd7, 0x62, 0x32, 0xee, 0x6f, 0x43, 0xfe, 0x85, 0xbd,
	0xfa, 0x8a, 0xbb, 0x6f, 0xda, 0x94, 0xa2, 0x43, 0x30, 0xc5, 0x35, 0xe4, 0x35, 0x8a, 0xd6, 0xe8,
	0xad, 0xac, 0x51, 0x14, 0x7d, 0x47, 0xba, 0x11, 0x40, 0x64, 0x64, 0xde, 0x13, 0x76, 0x93, 0xa3,
	0xd9, 0xc8, 0x1b, 0x27, 0xde, 0xc1, 0x49, 0xef, 0x94, 0xd8, 0x1a, 0x8b, 0x41, 0x08, 0xef, 0xf8,
	0x8b, 0x2b, 0xf6, 0xec, 0x9f, 0xde, 0x7c, 0xca, 0xce, 0x97, 0x61, 0x16, 0x8a, 0x4d, 0x1a, 0xae,
	0x22, 0x91, 0x7d, 0x8a, 0x23, 0xb1, 0xb9, 0x4a, 0xe3, 0x68, 0xb1, 0x7e, 0xbf, 0x8e, 0x96, 0xa7,
	0x8f, 0xf8, 0x09, 0x63, 0xe1, 0x6a, 0x95, 0x44, 0xab, 0x30, 0x8b, 0x96, 0xa7, 0x0e, 0x7f, 0xca,
	0x1e, 0xaf, 0xd3, 0x8f, 0x1f, 0x86, 0xcc, 0x9d, 0xff, 0x70, 0xd8, 0xb4, 0xd0, 0xcd, 0x43, 0x3b,
	0xcf, 0x9f, 0xdb, 0xa5, 0x13, 0xec, 0x74, 0x6f, 0x8a, 0xfd, 0x68, 0xa4, 0x63, 0xe7, 0x73, 0x78,
	0x70, 0x2a, 0x5d, 0x83, 0xaa, 0x7c, 0x6d, 0xaa, 0xa0, 0x42, 0x35, 0xbc, 0x4e, 0x60, 0x4b, 0xd0,
	0xca, 0xee, 0xde, 0x7f, 0xf4, 0xce, 0xa6, 0x3f, 0xdd, 0xd1, 0x22, 0x4b, 0xf3, 0xe3, 0xc1, 0x79,
	0xf3, 0x27, 0x00, 0x00, 0xff, 0xff, 0x62, 0xa7, 0xf7, 0xa7, 0x7a, 0x02, 0x00, 0x00,
}
