// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/service.proto

package automl

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AutoMl.CreateDataset][google.cloud.automl.v1.AutoMl.CreateDataset].
type CreateDatasetRequest struct {
	// The resource name of the project to create the dataset for.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The dataset to create.
	Dataset              *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatasetRequest) Reset()         { *m = CreateDatasetRequest{} }
func (m *CreateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatasetRequest) ProtoMessage()    {}
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{0}
}

func (m *CreateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatasetRequest.Unmarshal(m, b)
}
func (m *CreateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *CreateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatasetRequest.Merge(m, src)
}
func (m *CreateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatasetRequest.Size(m)
}
func (m *CreateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatasetRequest proto.InternalMessageInfo

func (m *CreateDatasetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

// Request message for [AutoMl.GetDataset][google.cloud.automl.v1.AutoMl.GetDataset].
type GetDatasetRequest struct {
	// The resource name of the dataset to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatasetRequest) Reset()         { *m = GetDatasetRequest{} }
func (m *GetDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatasetRequest) ProtoMessage()    {}
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{1}
}

func (m *GetDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatasetRequest.Unmarshal(m, b)
}
func (m *GetDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatasetRequest.Marshal(b, m, deterministic)
}
func (m *GetDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatasetRequest.Merge(m, src)
}
func (m *GetDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatasetRequest.Size(m)
}
func (m *GetDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatasetRequest proto.InternalMessageInfo

func (m *GetDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets].
type ListDatasetsRequest struct {
	// The resource name of the project from which to list datasets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `dataset_metadata` - for existence of the case (e.g.
	//             image_classification_dataset_metadata:*).
	// Some examples of using the filter are:
	//
	//   * `translation_dataset_metadata:*` --> The dataset has
	//                                          translation_dataset_metadata.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size. Server may return fewer results than requested.
	// If unspecified, server will pick a default size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListDatasetsResponse.next_page_token][google.cloud.automl.v1.ListDatasetsResponse.next_page_token] of the previous
	// [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsRequest) Reset()         { *m = ListDatasetsRequest{} }
func (m *ListDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsRequest) ProtoMessage()    {}
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{2}
}

func (m *ListDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsRequest.Unmarshal(m, b)
}
func (m *ListDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsRequest.Marshal(b, m, deterministic)
}
func (m *ListDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsRequest.Merge(m, src)
}
func (m *ListDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsRequest.Size(m)
}
func (m *ListDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsRequest proto.InternalMessageInfo

func (m *ListDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListDatasets][google.cloud.automl.v1.AutoMl.ListDatasets].
type ListDatasetsResponse struct {
	// The datasets read.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListDatasetsRequest.page_token][google.cloud.automl.v1.ListDatasetsRequest.page_token] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsResponse) Reset()         { *m = ListDatasetsResponse{} }
func (m *ListDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsResponse) ProtoMessage()    {}
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{3}
}

func (m *ListDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsResponse.Unmarshal(m, b)
}
func (m *ListDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsResponse.Marshal(b, m, deterministic)
}
func (m *ListDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsResponse.Merge(m, src)
}
func (m *ListDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsResponse.Size(m)
}
func (m *ListDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsResponse proto.InternalMessageInfo

func (m *ListDatasetsResponse) GetDatasets() []*Dataset {
	if m != nil {
		return m.Datasets
	}
	return nil
}

func (m *ListDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [AutoMl.UpdateDataset][google.cloud.automl.v1.AutoMl.UpdateDataset]
type UpdateDatasetRequest struct {
	// The dataset which replaces the resource on the server.
	Dataset *Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDatasetRequest) Reset()         { *m = UpdateDatasetRequest{} }
func (m *UpdateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDatasetRequest) ProtoMessage()    {}
func (*UpdateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{4}
}

func (m *UpdateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatasetRequest.Unmarshal(m, b)
}
func (m *UpdateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatasetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatasetRequest.Merge(m, src)
}
func (m *UpdateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDatasetRequest.Size(m)
}
func (m *UpdateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatasetRequest proto.InternalMessageInfo

func (m *UpdateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

func (m *UpdateDatasetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [AutoMl.DeleteDataset][google.cloud.automl.v1.AutoMl.DeleteDataset].
type DeleteDatasetRequest struct {
	// The resource name of the dataset to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatasetRequest) Reset()         { *m = DeleteDatasetRequest{} }
func (m *DeleteDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatasetRequest) ProtoMessage()    {}
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{5}
}

func (m *DeleteDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatasetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatasetRequest.Merge(m, src)
}
func (m *DeleteDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatasetRequest.Size(m)
}
func (m *DeleteDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatasetRequest proto.InternalMessageInfo

func (m *DeleteDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ImportData][google.cloud.automl.v1.AutoMl.ImportData].
type ImportDataRequest struct {
	// Required. Dataset name. Dataset must already exist. All imported
	// annotations and examples will be added.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired input location and its domain specific semantics,
	// if any.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportDataRequest) Reset()         { *m = ImportDataRequest{} }
func (m *ImportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDataRequest) ProtoMessage()    {}
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{6}
}

func (m *ImportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataRequest.Unmarshal(m, b)
}
func (m *ImportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataRequest.Marshal(b, m, deterministic)
}
func (m *ImportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataRequest.Merge(m, src)
}
func (m *ImportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDataRequest.Size(m)
}
func (m *ImportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataRequest proto.InternalMessageInfo

func (m *ImportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDataRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Request message for [AutoMl.ExportData][google.cloud.automl.v1.AutoMl.ExportData].
type ExportDataRequest struct {
	// Required. The resource name of the dataset.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportDataRequest) Reset()         { *m = ExportDataRequest{} }
func (m *ExportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDataRequest) ProtoMessage()    {}
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{7}
}

func (m *ExportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataRequest.Unmarshal(m, b)
}
func (m *ExportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataRequest.Marshal(b, m, deterministic)
}
func (m *ExportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataRequest.Merge(m, src)
}
func (m *ExportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDataRequest.Size(m)
}
func (m *ExportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataRequest proto.InternalMessageInfo

func (m *ExportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDataRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for [AutoMl.CreateModel][google.cloud.automl.v1.AutoMl.CreateModel].
type CreateModelRequest struct {
	// Resource name of the parent project where the model is being created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The model to create.
	Model                *Model   `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateModelRequest) Reset()         { *m = CreateModelRequest{} }
func (m *CreateModelRequest) String() string { return proto.CompactTextString(m) }
func (*CreateModelRequest) ProtoMessage()    {}
func (*CreateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{8}
}

func (m *CreateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateModelRequest.Unmarshal(m, b)
}
func (m *CreateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateModelRequest.Marshal(b, m, deterministic)
}
func (m *CreateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateModelRequest.Merge(m, src)
}
func (m *CreateModelRequest) XXX_Size() int {
	return xxx_messageInfo_CreateModelRequest.Size(m)
}
func (m *CreateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateModelRequest proto.InternalMessageInfo

func (m *CreateModelRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

// Request message for [AutoMl.GetModel][google.cloud.automl.v1.AutoMl.GetModel].
type GetModelRequest struct {
	// Resource name of the model.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelRequest) Reset()         { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()    {}
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{9}
}

func (m *GetModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelRequest.Unmarshal(m, b)
}
func (m *GetModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelRequest.Marshal(b, m, deterministic)
}
func (m *GetModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelRequest.Merge(m, src)
}
func (m *GetModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelRequest.Size(m)
}
func (m *GetModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelRequest proto.InternalMessageInfo

func (m *GetModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels].
type ListModelsRequest struct {
	// Resource name of the project, from which to list the models.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `model_metadata` - for existence of the case (e.g.
	//             video_classification_model_metadata:*).
	//   * `dataset_id` - for = or !=. Some examples of using the filter are:
	//
	//   * `image_classification_model_metadata:*` --> The model has
	//                                        image_classification_model_metadata.
	//   * `dataset_id=5` --> The model was created from a dataset with ID 5.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListModelsResponse.next_page_token][google.cloud.automl.v1.ListModelsResponse.next_page_token] of the previous
	// [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsRequest) Reset()         { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()    {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{10}
}

func (m *ListModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsRequest.Unmarshal(m, b)
}
func (m *ListModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsRequest.Marshal(b, m, deterministic)
}
func (m *ListModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsRequest.Merge(m, src)
}
func (m *ListModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelsRequest.Size(m)
}
func (m *ListModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsRequest proto.InternalMessageInfo

func (m *ListModelsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListModels][google.cloud.automl.v1.AutoMl.ListModels].
type ListModelsResponse struct {
	// List of models in the requested page.
	Model []*Model `protobuf:"bytes,1,rep,name=model,proto3" json:"model,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListModelsRequest.page_token][google.cloud.automl.v1.ListModelsRequest.page_token] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsResponse) Reset()         { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()    {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{11}
}

func (m *ListModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsResponse.Unmarshal(m, b)
}
func (m *ListModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsResponse.Marshal(b, m, deterministic)
}
func (m *ListModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsResponse.Merge(m, src)
}
func (m *ListModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelsResponse.Size(m)
}
func (m *ListModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsResponse proto.InternalMessageInfo

func (m *ListModelsResponse) GetModel() []*Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *ListModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [AutoMl.DeleteModel][google.cloud.automl.v1.AutoMl.DeleteModel].
type DeleteModelRequest struct {
	// Resource name of the model being deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteModelRequest) Reset()         { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()    {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{12}
}

func (m *DeleteModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteModelRequest.Unmarshal(m, b)
}
func (m *DeleteModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteModelRequest.Marshal(b, m, deterministic)
}
func (m *DeleteModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteModelRequest.Merge(m, src)
}
func (m *DeleteModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteModelRequest.Size(m)
}
func (m *DeleteModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteModelRequest proto.InternalMessageInfo

func (m *DeleteModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.UpdateModel][google.cloud.automl.v1.AutoMl.UpdateModel]
type UpdateModelRequest struct {
	// The model which replaces the resource on the server.
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateModelRequest) Reset()         { *m = UpdateModelRequest{} }
func (m *UpdateModelRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateModelRequest) ProtoMessage()    {}
func (*UpdateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{13}
}

func (m *UpdateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateModelRequest.Unmarshal(m, b)
}
func (m *UpdateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateModelRequest.Marshal(b, m, deterministic)
}
func (m *UpdateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateModelRequest.Merge(m, src)
}
func (m *UpdateModelRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateModelRequest.Size(m)
}
func (m *UpdateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateModelRequest proto.InternalMessageInfo

func (m *UpdateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *UpdateModelRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [AutoMl.GetModelEvaluation][google.cloud.automl.v1.AutoMl.GetModelEvaluation].
type GetModelEvaluationRequest struct {
	// Resource name for the model evaluation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelEvaluationRequest) Reset()         { *m = GetModelEvaluationRequest{} }
func (m *GetModelEvaluationRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelEvaluationRequest) ProtoMessage()    {}
func (*GetModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{14}
}

func (m *GetModelEvaluationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelEvaluationRequest.Unmarshal(m, b)
}
func (m *GetModelEvaluationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelEvaluationRequest.Marshal(b, m, deterministic)
}
func (m *GetModelEvaluationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelEvaluationRequest.Merge(m, src)
}
func (m *GetModelEvaluationRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelEvaluationRequest.Size(m)
}
func (m *GetModelEvaluationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelEvaluationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelEvaluationRequest proto.InternalMessageInfo

func (m *GetModelEvaluationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsRequest struct {
	// Resource name of the model to list the model evaluations for.
	// If modelId is set as "-", this will list model evaluations from across all
	// models of the parent location.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `annotation_spec_id` - for =, !=  or existence. See example below for
	//                          the last.
	//
	// Some examples of using the filter are:
	//
	//   * `annotation_spec_id!=4` --> The model evaluation was done for
	//                             annotation spec with ID different than 4.
	//   * `NOT annotation_spec_id:*` --> The model evaluation was done for
	//                                aggregate of all annotation specs.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return.
	// Typically obtained via
	// [ListModelEvaluationsResponse.next_page_token][google.cloud.automl.v1.ListModelEvaluationsResponse.next_page_token] of the previous
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsRequest) Reset()         { *m = ListModelEvaluationsRequest{} }
func (m *ListModelEvaluationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsRequest) ProtoMessage()    {}
func (*ListModelEvaluationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{15}
}

func (m *ListModelEvaluationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsRequest.Unmarshal(m, b)
}
func (m *ListModelEvaluationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsRequest.Marshal(b, m, deterministic)
}
func (m *ListModelEvaluationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsRequest.Merge(m, src)
}
func (m *ListModelEvaluationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsRequest.Size(m)
}
func (m *ListModelEvaluationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsRequest proto.InternalMessageInfo

func (m *ListModelEvaluationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelEvaluationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsResponse struct {
	// List of model evaluations in the requested page.
	ModelEvaluation []*ModelEvaluation `protobuf:"bytes,1,rep,name=model_evaluation,json=modelEvaluation,proto3" json:"model_evaluation,omitempty"`
	// A token to retrieve next page of results.
	// Pass to the [ListModelEvaluationsRequest.page_token][google.cloud.automl.v1.ListModelEvaluationsRequest.page_token] field of a new
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1.AutoMl.ListModelEvaluations] request to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsResponse) Reset()         { *m = ListModelEvaluationsResponse{} }
func (m *ListModelEvaluationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsResponse) ProtoMessage()    {}
func (*ListModelEvaluationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d14ac936eda1c3a8, []int{16}
}

func (m *ListModelEvaluationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsResponse.Unmarshal(m, b)
}
func (m *ListModelEvaluationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsResponse.Marshal(b, m, deterministic)
}
func (m *ListModelEvaluationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsResponse.Merge(m, src)
}
func (m *ListModelEvaluationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsResponse.Size(m)
}
func (m *ListModelEvaluationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsResponse proto.InternalMessageInfo

func (m *ListModelEvaluationsResponse) GetModelEvaluation() []*ModelEvaluation {
	if m != nil {
		return m.ModelEvaluation
	}
	return nil
}

func (m *ListModelEvaluationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateDatasetRequest)(nil), "google.cloud.automl.v1.CreateDatasetRequest")
	proto.RegisterType((*GetDatasetRequest)(nil), "google.cloud.automl.v1.GetDatasetRequest")
	proto.RegisterType((*ListDatasetsRequest)(nil), "google.cloud.automl.v1.ListDatasetsRequest")
	proto.RegisterType((*ListDatasetsResponse)(nil), "google.cloud.automl.v1.ListDatasetsResponse")
	proto.RegisterType((*UpdateDatasetRequest)(nil), "google.cloud.automl.v1.UpdateDatasetRequest")
	proto.RegisterType((*DeleteDatasetRequest)(nil), "google.cloud.automl.v1.DeleteDatasetRequest")
	proto.RegisterType((*ImportDataRequest)(nil), "google.cloud.automl.v1.ImportDataRequest")
	proto.RegisterType((*ExportDataRequest)(nil), "google.cloud.automl.v1.ExportDataRequest")
	proto.RegisterType((*CreateModelRequest)(nil), "google.cloud.automl.v1.CreateModelRequest")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.automl.v1.GetModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.automl.v1.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.automl.v1.ListModelsResponse")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.automl.v1.DeleteModelRequest")
	proto.RegisterType((*UpdateModelRequest)(nil), "google.cloud.automl.v1.UpdateModelRequest")
	proto.RegisterType((*GetModelEvaluationRequest)(nil), "google.cloud.automl.v1.GetModelEvaluationRequest")
	proto.RegisterType((*ListModelEvaluationsRequest)(nil), "google.cloud.automl.v1.ListModelEvaluationsRequest")
	proto.RegisterType((*ListModelEvaluationsResponse)(nil), "google.cloud.automl.v1.ListModelEvaluationsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1/service.proto", fileDescriptor_d14ac936eda1c3a8)
}

var fileDescriptor_d14ac936eda1c3a8 = []byte{
	// 1203 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0xd1, 0x6e, 0xdc, 0x44,
	0x14, 0xd5, 0xa4, 0x6d, 0x68, 0xef, 0x26, 0x0a, 0x19, 0x42, 0xd8, 0xba, 0xad, 0x1a, 0xb9, 0x85,
	0x04, 0x93, 0xda, 0x64, 0x13, 0xa9, 0x8a, 0xd3, 0xa8, 0x4a, 0xd2, 0x34, 0x8a, 0xd4, 0xa8, 0xd1,
	0x02, 0x7d, 0x40, 0x91, 0x56, 0xee, 0xee, 0x64, 0x6b, 0xe2, 0xf5, 0xb8, 0xf6, 0x38, 0x09, 0xad,
	0x2a, 0x04, 0x42, 0x95, 0x90, 0x50, 0x1f, 0xe8, 0x03, 0xa2, 0x48, 0xf0, 0xc4, 0x37, 0xf0, 0x0b,
	0xa8, 0x8f, 0xf0, 0x0b, 0x3c, 0xf1, 0x15, 0xc8, 0x33, 0xe3, 0x5d, 0xef, 0xda, 0x5e, 0x7b, 0x85,
	0x50, 0xdf, 0x6c, 0xcf, 0x99, 0xb9, 0x67, 0xce, 0xbd, 0x33, 0xe7, 0xee, 0xc2, 0xf5, 0x36, 0xa5,
	0x6d, 0x87, 0x18, 0x4d, 0x87, 0x86, 0x2d, 0xc3, 0x0a, 0x19, 0xed, 0x38, 0xc6, 0xf1, 0x92, 0x11,
	0x10, 0xff, 0xd8, 0x6e, 0x12, 0xdd, 0xf3, 0x29, 0xa3, 0x78, 0x56, 0xa0, 0x74, 0x8e, 0xd2, 0x05,
	0x4a, 0x3f, 0x5e, 0x52, 0x2e, 0xcb, 0xd9, 0x96, 0x67, 0x1b, 0x96, 0xeb, 0x52, 0x66, 0x31, 0x9b,
	0xba, 0x81, 0x98, 0xa5, 0x18, 0x39, 0x6b, 0xf7, 0x90, 0x0d, 0xcf, 0xfa, 0xd2, 0xa1, 0x56, 0x4b,
	0x4e, 0xc8, 0x23, 0xd3, 0xb2, 0x98, 0x15, 0x10, 0x26, 0x51, 0x57, 0x73, 0x50, 0x36, 0x95, 0x00,
	0x35, 0x07, 0xd0, 0xa1, 0x2d, 0xe2, 0x48, 0xcc, 0x8d, 0x61, 0x98, 0x06, 0x39, 0xb6, 0x9c, 0x90,
	0x33, 0x94, 0xf0, 0x6b, 0x12, 0xee, 0x50, 0xb7, 0xed, 0x87, 0xae, 0x6b, 0xbb, 0x6d, 0x83, 0x7a,
	0xc4, 0xef, 0xdb, 0xef, 0x9c, 0x04, 0xf1, 0xb7, 0x87, 0xe1, 0xa1, 0x71, 0x68, 0x13, 0xa7, 0xd5,
	0xe8, 0x58, 0xc1, 0x91, 0x44, 0xbc, 0x97, 0xd0, 0xab, 0xe9, 0xd8, 0xc4, 0x95, 0x7b, 0x52, 0x6d,
	0x98, 0xd9, 0xf2, 0x89, 0xc5, 0xc8, 0x1d, 0xb1, 0xd5, 0x3a, 0x79, 0x1c, 0x92, 0x80, 0xe1, 0x59,
	0x18, 0xf7, 0x2c, 0x9f, 0xb8, 0xac, 0x8a, 0xe6, 0xd0, 0xc2, 0x85, 0xba, 0x7c, 0xc3, 0xab, 0xf0,
	0x96, 0x14, 0xa5, 0x3a, 0x36, 0x87, 0x16, 0x2a, 0xb5, 0xab, 0x7a, 0x76, 0x8a, 0xf4, 0x78, 0xc1,
	0x18, 0xaf, 0xce, 0xc3, 0xf4, 0x0e, 0x61, 0x03, 0x71, 0x30, 0x9c, 0x75, 0xad, 0x0e, 0x91, 0x51,
	0xf8, 0xb3, 0xfa, 0x35, 0x82, 0x77, 0xee, 0xd9, 0x41, 0x0c, 0x0d, 0x8a, 0x38, 0xcd, 0xc2, 0xf8,
	0xa1, 0xed, 0x30, 0xe2, 0x57, 0xcf, 0x88, 0xef, 0xe2, 0x0d, 0x5f, 0x82, 0x0b, 0x9e, 0xd5, 0x26,
	0x8d, 0xc0, 0x7e, 0x42, 0xaa, 0x67, 0xe7, 0xd0, 0xc2, 0xb9, 0xfa, 0xf9, 0xe8, 0xc3, 0x27, 0xf6,
	0x13, 0x82, 0xaf, 0x00, 0xf0, 0x41, 0x46, 0x8f, 0x88, 0x5b, 0x1d, 0xe7, 0x13, 0x39, 0xfc, 0xd3,
	0xe8, 0x83, 0xfa, 0x14, 0x66, 0xfa, 0x29, 0x04, 0x1e, 0x75, 0x03, 0x82, 0xd7, 0xe0, 0xbc, 0xdc,
	0x4f, 0x50, 0x45, 0x73, 0x67, 0xca, 0x08, 0xd0, 0x9d, 0x80, 0x3f, 0x80, 0x29, 0x97, 0x9c, 0xb2,
	0x46, 0x22, 0xf0, 0x18, 0x0f, 0x3c, 0x19, 0x7d, 0xde, 0xef, 0x06, 0x7f, 0x81, 0x60, 0xe6, 0x33,
	0xaf, 0x95, 0xce, 0x4a, 0x42, 0x7d, 0x34, 0x9a, 0xfa, 0x78, 0x0d, 0x2a, 0x21, 0x5f, 0x92, 0x97,
	0x85, 0x4c, 0x9e, 0x12, 0x4f, 0x8f, 0x2b, 0x47, 0xbf, 0x1b, 0x55, 0xce, 0x9e, 0x15, 0x1c, 0xd5,
	0x41, 0xc0, 0xa3, 0x67, 0x55, 0x83, 0x99, 0x3b, 0xc4, 0x21, 0x29, 0x3e, 0x59, 0xd9, 0xa3, 0x30,
	0xbd, 0xdb, 0xf1, 0xa8, 0xcf, 0xb5, 0x1b, 0x02, 0xc4, 0x77, 0x61, 0xc2, 0x76, 0xbd, 0x90, 0x35,
	0x9a, 0xd4, 0x3d, 0xb4, 0xdb, 0x3c, 0x79, 0x95, 0xda, 0xb5, 0xbc, 0x1d, 0xed, 0x46, 0xd8, 0x2d,
	0x0e, 0xad, 0x57, 0xec, 0xde, 0x8b, 0xea, 0xc3, 0xf4, 0xf6, 0x69, 0x99, 0x80, 0xbb, 0x30, 0x49,
	0x43, 0x96, 0x8a, 0x78, 0x3d, 0x2f, 0xe2, 0x7d, 0x0e, 0x96, 0x21, 0x27, 0x68, 0xe2, 0x4d, 0xb5,
	0x00, 0x8b, 0x63, 0xb3, 0x17, 0x1d, 0xdb, 0xa2, 0x02, 0x5d, 0x86, 0x73, 0xfc, 0x78, 0xf3, 0x22,
	0xac, 0xd4, 0xae, 0xe4, 0x05, 0x14, 0x8b, 0x09, 0xac, 0xfa, 0x3e, 0x4c, 0xed, 0x10, 0xd6, 0xb7,
	0x7e, 0x96, 0xdc, 0x5f, 0xc1, 0x74, 0x54, 0xa8, 0x1c, 0xf7, 0x46, 0x4e, 0xca, 0x63, 0xc0, 0x49,
	0x02, 0xf2, 0x9c, 0x74, 0xb7, 0x2c, 0x0e, 0x49, 0xa9, 0x2d, 0x97, 0x3e, 0x1f, 0x0b, 0x80, 0x45,
	0x39, 0x16, 0xaa, 0xf3, 0x1c, 0x01, 0x16, 0x27, 0xa9, 0x0f, 0x9a, 0x60, 0x57, 0x3a, 0x21, 0xff,
	0xed, 0x04, 0x19, 0x70, 0x31, 0xce, 0xe6, 0x76, 0xf7, 0x8e, 0x1f, 0xc6, 0xfc, 0x3b, 0x04, 0x97,
	0xba, 0xba, 0xf6, 0xa6, 0xbc, 0x91, 0x14, 0xbf, 0x42, 0x70, 0x39, 0x9b, 0x8b, 0xcc, 0x76, 0x1d,
	0xde, 0x1e, 0xf4, 0x2f, 0x99, 0xf8, 0xf9, 0xa1, 0xd2, 0x26, 0xa4, 0x98, 0xea, 0xf4, 0x7f, 0x28,
	0x5b, 0x0c, 0xb5, 0x6f, 0x31, 0x8c, 0x6f, 0x84, 0x8c, 0xee, 0x39, 0xf8, 0x67, 0x04, 0x93, 0x7d,
	0x6e, 0x86, 0x17, 0xf3, 0xc2, 0x67, 0x99, 0x9e, 0xd2, 0xad, 0x83, 0x84, 0xdb, 0xea, 0xf7, 0x63,
	0xb7, 0x55, 0xd7, 0xbf, 0xf9, 0xeb, 0xef, 0x97, 0x63, 0x37, 0xd5, 0xc5, 0xc8, 0xaf, 0x9f, 0x0a,
	0xbd, 0xd7, 0x3d, 0x9f, 0x7e, 0x41, 0x9a, 0x2c, 0x30, 0x34, 0xc3, 0xa1, 0x4d, 0xa1, 0x8b, 0xa1,
	0x3d, 0x8b, 0x5b, 0x87, 0xc0, 0xec, 0xde, 0xc0, 0x2f, 0x10, 0x40, 0xcf, 0x00, 0xf1, 0x87, 0x79,
	0xd4, 0x52, 0x26, 0xa9, 0x14, 0xdd, 0xf2, 0xea, 0x0a, 0x67, 0xa6, 0x63, 0xc1, 0x2c, 0xaa, 0x9f,
	0x1c, 0x5e, 0x5d, 0x5a, 0x86, 0xf6, 0x0c, 0xff, 0x8a, 0x60, 0x22, 0x69, 0x72, 0xf8, 0xa3, 0xbc,
	0x38, 0x19, 0x6e, 0xac, 0x2c, 0x96, 0x03, 0x8b, 0x0a, 0x19, 0x60, 0x58, 0x52, 0x3b, 0xfc, 0x1b,
	0x82, 0xc9, 0x3e, 0x23, 0xcc, 0x4f, 0x68, 0x96, 0x5f, 0x16, 0x0b, 0xb7, 0xcd, 0x69, 0xdd, 0xae,
	0xad, 0x70, 0x5a, 0x71, 0xbb, 0x57, 0x52, 0xc0, 0x5e, 0x6a, 0x7f, 0x40, 0x30, 0xd9, 0x67, 0x90,
	0xf9, 0x3c, 0xb3, 0x7c, 0xb4, 0xa8, 0xf0, 0xa4, 0x78, 0xda, 0x68, 0xe9, 0x7d, 0x85, 0x00, 0x7a,
	0x4e, 0x9c, 0x5f, 0x6f, 0x29, 0xb7, 0x2e, 0xa2, 0xb3, 0xc9, 0xe9, 0xdc, 0x52, 0x6f, 0x8e, 0x42,
	0xc7, 0xb4, 0xbb, 0x61, 0x4c, 0xa4, 0x71, 0x72, 0x3d, 0xd7, 0xce, 0x27, 0x97, 0x72, 0xf6, 0xff,
	0x87, 0x1c, 0x39, 0x4d, 0x92, 0x7b, 0x89, 0xa0, 0x92, 0xb0, 0x77, 0xac, 0x0d, 0xbf, 0x45, 0x92,
	0xd6, 0x52, 0x44, 0x6f, 0x95, 0xd3, 0x5b, 0x56, 0xb5, 0x32, 0xe7, 0x80, 0x5f, 0x89, 0x81, 0x29,
	0xfd, 0xe7, 0x39, 0x82, 0xf3, 0xb1, 0x87, 0xe0, 0xf9, 0x21, 0xb7, 0x47, 0x36, 0x9f, 0xcc, 0x0b,
	0x58, 0xad, 0x71, 0x3e, 0x8b, 0x58, 0x2b, 0x94, 0x4b, 0x90, 0x89, 0x0a, 0xeb, 0x47, 0x04, 0xd0,
	0xb3, 0xfc, 0xfc, 0xdc, 0xa5, 0xfa, 0x12, 0x45, 0x2b, 0x03, 0x95, 0x37, 0x46, 0x3f, 0xb3, 0x52,
	0x4a, 0xe1, 0xef, 0x11, 0x54, 0x12, 0x9d, 0x41, 0x7e, 0xe2, 0xd2, 0xed, 0x43, 0x51, 0xe2, 0x24,
	0x1d, 0x6d, 0x14, 0xa1, 0x7e, 0x42, 0x50, 0x49, 0x74, 0x1f, 0xf9, 0x74, 0xd2, 0x2d, 0x4a, 0x51,
	0xde, 0x6e, 0x73, 0x3a, 0xab, 0xb5, 0x8f, 0x39, 0x1d, 0xf1, 0x03, 0xb3, 0x14, 0xa9, 0xb8, 0x9a,
	0x7e, 0x47, 0x80, 0xd3, 0x1d, 0x09, 0x5e, 0x2a, 0xaa, 0xab, 0x54, 0xf7, 0xa2, 0x94, 0xb5, 0xf8,
	0xf8, 0xb2, 0xc5, 0xeb, 0xa5, 0x25, 0x34, 0x06, 0x9a, 0x02, 0xae, 0xea, 0x1f, 0x48, 0xfc, 0x36,
	0x1b, 0xec, 0x46, 0xf0, 0x72, 0x61, 0x75, 0xa5, 0xfb, 0x28, 0x65, 0x65, 0xb4, 0x49, 0xb2, 0x38,
	0xfb, 0xb7, 0x32, 0xb4, 0x38, 0x7b, 0xd2, 0xa7, 0x76, 0xa3, 0xec, 0xbe, 0xde, 0x78, 0x57, 0x46,
	0x14, 0x2c, 0x2c, 0xcf, 0x0e, 0xf4, 0x26, 0xed, 0xfc, 0xb9, 0xa1, 0x3f, 0x62, 0xcc, 0x0b, 0x4c,
	0xc3, 0x38, 0x39, 0x39, 0x19, 0x18, 0x34, 0xac, 0x90, 0x3d, 0x12, 0x7f, 0x20, 0xdc, 0xf0, 0x1c,
	0x8b, 0x1d, 0x52, 0xbf, 0xb3, 0xf9, 0x0b, 0x02, 0xa5, 0x49, 0x3b, 0x39, 0xbb, 0xd9, 0xac, 0x88,
	0x16, 0x69, 0x3f, 0xea, 0x52, 0xf7, 0xd1, 0xe7, 0xb7, 0x24, 0xac, 0x4d, 0x1d, 0xcb, 0x6d, 0xeb,
	0xd4, 0x6f, 0x1b, 0x6d, 0xe2, 0xf2, 0x1e, 0xd6, 0xe8, 0x05, 0x1b, 0xfc, 0x93, 0x62, 0x4d, 0x3c,
	0xbd, 0x1e, 0x9b, 0xdd, 0xe1, 0x98, 0x83, 0xad, 0x68, 0xfc, 0x40, 0x2c, 0x7d, 0xf0, 0x60, 0xe9,
	0x9f, 0xb1, 0x8b, 0x62, 0xc0, 0x34, 0xf9, 0x88, 0x69, 0xf2, 0xa1, 0x7b, 0xa6, 0xf9, 0x60, 0xe9,
	0xe1, 0x38, 0x5f, 0x7d, 0xf9, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x7a, 0x80, 0x37, 0xf9,
	0x11, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AutoMlClient is the client API for AutoMl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoMlClient interface {
	// Creates a dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports data into a dataset.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists models.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a model.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Gets a model evaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
}

type autoMlClient struct {
	cc *grpc.ClientConn
}

func NewAutoMlClient(cc *grpc.ClientConn) AutoMlClient {
	return &autoMlClient{cc}
}

func (c *autoMlClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UpdateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/CreateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/UpdateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/GetModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.AutoMl/ListModelEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoMlServer is the server API for AutoMl service.
type AutoMlServer interface {
	// Creates a dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunning.Operation, error)
	// Gets a dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunning.Operation, error)
	// Imports data into a dataset.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(context.Context, *CreateModelRequest) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists models.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error)
	// Updates a model.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Gets a model evaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
}

// UnimplementedAutoMlServer can be embedded to have forward compatible implementations.
type UnimplementedAutoMlServer struct {
}

func (*UnimplementedAutoMlServer) CreateDataset(ctx context.Context, req *CreateDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (*UnimplementedAutoMlServer) GetDataset(ctx context.Context, req *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (*UnimplementedAutoMlServer) ListDatasets(ctx context.Context, req *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (*UnimplementedAutoMlServer) UpdateDataset(ctx context.Context, req *UpdateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (*UnimplementedAutoMlServer) DeleteDataset(ctx context.Context, req *DeleteDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (*UnimplementedAutoMlServer) ImportData(ctx context.Context, req *ImportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (*UnimplementedAutoMlServer) ExportData(ctx context.Context, req *ExportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (*UnimplementedAutoMlServer) CreateModel(ctx context.Context, req *CreateModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (*UnimplementedAutoMlServer) GetModel(ctx context.Context, req *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (*UnimplementedAutoMlServer) ListModels(ctx context.Context, req *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedAutoMlServer) DeleteModel(ctx context.Context, req *DeleteModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (*UnimplementedAutoMlServer) UpdateModel(ctx context.Context, req *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (*UnimplementedAutoMlServer) GetModelEvaluation(ctx context.Context, req *GetModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluation not implemented")
}
func (*UnimplementedAutoMlServer) ListModelEvaluations(ctx context.Context, req *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluations not implemented")
}

func RegisterAutoMlServer(s *grpc.Server, srv AutoMlServer) {
	s.RegisterService(&_AutoMl_serviceDesc, srv)
}

func _AutoMl_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UpdateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/UpdateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/GetModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.AutoMl/ListModelEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoMl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.AutoMl",
	HandlerType: (*AutoMlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _AutoMl_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _AutoMl_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _AutoMl_ListDatasets_Handler,
		},
		{
			MethodName: "UpdateDataset",
			Handler:    _AutoMl_UpdateDataset_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _AutoMl_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _AutoMl_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _AutoMl_ExportData_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _AutoMl_CreateModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _AutoMl_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _AutoMl_ListModels_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _AutoMl_DeleteModel_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _AutoMl_UpdateModel_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _AutoMl_GetModelEvaluation_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _AutoMl_ListModelEvaluations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/service.proto",
}
