// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/asset.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Asset is a part of an ad which can be shared across multiple ads.
// It can be an image (ImageAsset), a video (YoutubeVideoAsset), etc.
type Asset struct {
	// The resource name of the asset.
	// Asset resource names have the form:
	//
	// `customers/{customer_id}/assets/{asset_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the asset.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Optional name of the asset.
	Name *wrappers.StringValue `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Type of the asset.
	Type enums.AssetTypeEnum_AssetType `protobuf:"varint,4,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.AssetTypeEnum_AssetType" json:"type,omitempty"`
	// The specific type of the asset.
	//
	// Types that are valid to be assigned to AssetData:
	//	*Asset_YoutubeVideoAsset
	//	*Asset_MediaBundleAsset
	//	*Asset_ImageAsset
	//	*Asset_TextAsset
	AssetData            isAsset_AssetData `protobuf_oneof:"asset_data"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Asset) Reset()         { *m = Asset{} }
func (m *Asset) String() string { return proto.CompactTextString(m) }
func (*Asset) ProtoMessage()    {}
func (*Asset) Descriptor() ([]byte, []int) {
	return fileDescriptor_615ce8003e62b64c, []int{0}
}

func (m *Asset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset.Unmarshal(m, b)
}
func (m *Asset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset.Marshal(b, m, deterministic)
}
func (m *Asset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset.Merge(m, src)
}
func (m *Asset) XXX_Size() int {
	return xxx_messageInfo_Asset.Size(m)
}
func (m *Asset) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset.DiscardUnknown(m)
}

var xxx_messageInfo_Asset proto.InternalMessageInfo

func (m *Asset) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Asset) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Asset) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Asset) GetType() enums.AssetTypeEnum_AssetType {
	if m != nil {
		return m.Type
	}
	return enums.AssetTypeEnum_UNSPECIFIED
}

type isAsset_AssetData interface {
	isAsset_AssetData()
}

type Asset_YoutubeVideoAsset struct {
	YoutubeVideoAsset *common.YoutubeVideoAsset `protobuf:"bytes,5,opt,name=youtube_video_asset,json=youtubeVideoAsset,proto3,oneof"`
}

type Asset_MediaBundleAsset struct {
	MediaBundleAsset *common.MediaBundleAsset `protobuf:"bytes,6,opt,name=media_bundle_asset,json=mediaBundleAsset,proto3,oneof"`
}

type Asset_ImageAsset struct {
	ImageAsset *common.ImageAsset `protobuf:"bytes,7,opt,name=image_asset,json=imageAsset,proto3,oneof"`
}

type Asset_TextAsset struct {
	TextAsset *common.TextAsset `protobuf:"bytes,8,opt,name=text_asset,json=textAsset,proto3,oneof"`
}

func (*Asset_YoutubeVideoAsset) isAsset_AssetData() {}

func (*Asset_MediaBundleAsset) isAsset_AssetData() {}

func (*Asset_ImageAsset) isAsset_AssetData() {}

func (*Asset_TextAsset) isAsset_AssetData() {}

func (m *Asset) GetAssetData() isAsset_AssetData {
	if m != nil {
		return m.AssetData
	}
	return nil
}

func (m *Asset) GetYoutubeVideoAsset() *common.YoutubeVideoAsset {
	if x, ok := m.GetAssetData().(*Asset_YoutubeVideoAsset); ok {
		return x.YoutubeVideoAsset
	}
	return nil
}

func (m *Asset) GetMediaBundleAsset() *common.MediaBundleAsset {
	if x, ok := m.GetAssetData().(*Asset_MediaBundleAsset); ok {
		return x.MediaBundleAsset
	}
	return nil
}

func (m *Asset) GetImageAsset() *common.ImageAsset {
	if x, ok := m.GetAssetData().(*Asset_ImageAsset); ok {
		return x.ImageAsset
	}
	return nil
}

func (m *Asset) GetTextAsset() *common.TextAsset {
	if x, ok := m.GetAssetData().(*Asset_TextAsset); ok {
		return x.TextAsset
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Asset) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Asset_YoutubeVideoAsset)(nil),
		(*Asset_MediaBundleAsset)(nil),
		(*Asset_ImageAsset)(nil),
		(*Asset_TextAsset)(nil),
	}
}

func init() {
	proto.RegisterType((*Asset)(nil), "google.ads.googleads.v2.resources.Asset")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/asset.proto", fileDescriptor_615ce8003e62b64c)
}

var fileDescriptor_615ce8003e62b64c = []byte{
	// 508 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0xd1, 0x6e, 0xd3, 0x30,
	0x14, 0x86, 0x49, 0xd6, 0x0d, 0xe6, 0x0d, 0x04, 0xe6, 0xa6, 0x1a, 0x13, 0xea, 0x40, 0x93, 0x0a,
	0x08, 0xa7, 0x04, 0xb4, 0x8b, 0x70, 0x95, 0x4a, 0x68, 0xac, 0xd2, 0xd0, 0x54, 0xa6, 0x4a, 0xa0,
	0x4a, 0xc1, 0xad, 0x0f, 0x91, 0xa5, 0xda, 0x8e, 0x62, 0xa7, 0xac, 0xaf, 0xc3, 0x25, 0x2f, 0x82,
	0xc4, 0xa3, 0xf0, 0x02, 0xdc, 0xa2, 0xd8, 0x71, 0x40, 0x43, 0xa5, 0x77, 0xc7, 0xce, 0xf7, 0x7f,
	0xe7, 0xd4, 0xb5, 0xd1, 0xf3, 0x5c, 0xa9, 0x7c, 0x01, 0x11, 0x65, 0x3a, 0x72, 0x65, 0x5d, 0x2d,
	0xe3, 0xa8, 0x04, 0xad, 0xaa, 0x72, 0x0e, 0x3a, 0xa2, 0x5a, 0x83, 0x21, 0x45, 0xa9, 0x8c, 0xc2,
	0x47, 0x8e, 0x21, 0x94, 0x69, 0xd2, 0xe2, 0x64, 0x19, 0x93, 0x16, 0x3f, 0x18, 0xac, 0x33, 0xce,
	0x95, 0x10, 0x4a, 0x3a, 0x5d, 0x66, 0x56, 0x05, 0x68, 0x27, 0x3d, 0x20, 0xeb, 0x12, 0x20, 0x2b,
	0xa1, 0xff, 0x0a, 0x34, 0xfc, 0xc3, 0x86, 0xb7, 0xab, 0x59, 0xf5, 0x39, 0xfa, 0x52, 0xd2, 0xa2,
	0x80, 0xd2, 0xfb, 0x0e, 0xbd, 0xaf, 0xe0, 0x11, 0x95, 0x52, 0x19, 0x6a, 0xb8, 0x92, 0xcd, 0xd7,
	0x47, 0xdf, 0x3b, 0x68, 0x3b, 0xad, 0x95, 0xf8, 0x31, 0xba, 0xed, 0xc7, 0xce, 0x24, 0x15, 0xd0,
	0x0d, 0x7a, 0x41, 0x7f, 0x77, 0xbc, 0xef, 0x37, 0xdf, 0x51, 0x01, 0xf8, 0x19, 0x0a, 0x39, 0xeb,
	0x86, 0xbd, 0xa0, 0xbf, 0x17, 0x3f, 0x68, 0x26, 0x25, 0xbe, 0x33, 0x39, 0x93, 0xe6, 0xe4, 0xd5,
	0x84, 0x2e, 0x2a, 0x18, 0x87, 0x9c, 0xe1, 0x01, 0xea, 0x58, 0xd1, 0x96, 0xc5, 0x0f, 0xff, 0xc1,
	0xdf, 0x9b, 0x92, 0xcb, 0xdc, 0xf1, 0x96, 0xc4, 0x23, 0xd4, 0xa9, 0x7f, 0x59, 0xb7, 0xd3, 0x0b,
	0xfa, 0x77, 0xe2, 0x13, 0xb2, 0xee, 0x7c, 0xed, 0x51, 0x10, 0x3b, 0xf7, 0xe5, 0xaa, 0x80, 0x37,
	0xb2, 0x12, 0x7f, 0x56, 0x63, 0xeb, 0xc0, 0x73, 0x74, 0x7f, 0xa5, 0x2a, 0x53, 0xcd, 0x20, 0x5b,
	0x72, 0x06, 0x2a, 0xb3, 0x27, 0xd7, 0xdd, 0xb6, 0xc3, 0xbc, 0x58, 0xab, 0x76, 0xff, 0x0b, 0xf9,
	0xe0, 0xa2, 0x93, 0x3a, 0x69, 0xcd, 0x6f, 0x6f, 0x8c, 0xef, 0xad, 0xae, 0x6f, 0xe2, 0x4f, 0x08,
	0x0b, 0x60, 0x9c, 0x66, 0xb3, 0x4a, 0xb2, 0x05, 0x34, 0x3d, 0x76, 0x6c, 0x8f, 0xc1, 0xa6, 0x1e,
	0xe7, 0x75, 0x72, 0x68, 0x83, 0xbe, 0xc5, 0x5d, 0x71, 0x6d, 0x0f, 0x9f, 0xa3, 0x3d, 0x2e, 0x68,
	0xee, 0xd5, 0x37, 0xad, 0xfa, 0xe9, 0x26, 0xf5, 0x59, 0x1d, 0xf1, 0x52, 0xc4, 0xdb, 0x15, 0x1e,
	0x21, 0x64, 0xe0, 0xca, 0x34, 0xb6, 0x5b, 0xd6, 0xf6, 0x64, 0x93, 0xed, 0x12, 0xae, 0x8c, 0x97,
	0xed, 0x1a, 0xbf, 0x18, 0xee, 0x23, 0xe4, 0x6e, 0x23, 0xa3, 0x86, 0x0e, 0x7f, 0x05, 0xe8, 0x78,
	0xae, 0x04, 0xd9, 0xf8, 0x26, 0x86, 0xc8, 0xc6, 0x2f, 0xea, 0x6b, 0x70, 0x11, 0x7c, 0x1c, 0x35,
	0x81, 0x5c, 0x2d, 0xa8, 0xcc, 0x89, 0x2a, 0xf3, 0x28, 0x07, 0x69, 0x2f, 0x89, 0xbf, 0xff, 0x05,
	0xd7, 0xff, 0x79, 0x92, 0xaf, 0xdb, 0xea, 0x6b, 0xb8, 0x75, 0x9a, 0xa6, 0xdf, 0xc2, 0xa3, 0x53,
	0xa7, 0x4c, 0x99, 0x26, 0xae, 0xac, 0xab, 0x49, 0x4c, 0xc6, 0x9e, 0xfc, 0xe1, 0x99, 0x69, 0xca,
	0xf4, 0xb4, 0x65, 0xa6, 0x93, 0x78, 0xda, 0x32, 0x3f, 0xc3, 0x63, 0xf7, 0x21, 0x49, 0x52, 0xa6,
	0x93, 0xa4, 0xa5, 0x92, 0x64, 0x12, 0x27, 0x49, 0xcb, 0xcd, 0x76, 0xec, 0xb0, 0x2f, 0x7f, 0x07,
	0x00, 0x00, 0xff, 0xff, 0x86, 0x36, 0x5e, 0x64, 0x3e, 0x04, 0x00, 0x00,
}
