# Sample Metrics

To understand what metrics are collected by the Telemeter service, we can replicate the request that the Telemeter client makes against a running OpenShift cluster's Prometheus service.
The Telemeter client makes an HTTP GET request to Prometheus' `/federate` endpoint with the [metrics match rules](https://github.com/openshift/telemeter/blob/master/jsonnet/telemeter/metrics.jsonnet) URL encoded as query parameters.

To start, find the URL for the Prometheus service running in the OpenShift cluster:
```shell
$ oc get route prometheus-k8s -n openshift-monitoring -o jsonpath="{.spec.host}"
```

Next, navigate to this URL and run the following query, which will
return the full set of metrics that the Telemeter client captures:

[embedmd]:# (telemeter_query txt)
```txt
{__name__="up"} or {__name__="cluster_version"} or {__name__="cluster_version_available_updates"} or {__name__="cluster_operator_up"} or {__name__="cluster_operator_conditions"} or {__name__="cluster_version_payload"} or {__name__="cluster_installer"} or {__name__="cluster_infrastructure_provider"} or {__name__="cluster_feature_set"} or {__name__="node_uname_info"} or {__name__="instance:etcd_object_counts:sum"} or {__name__="ALERTS",alertstate="firing"} or {__name__="code:apiserver_request_count:rate:sum"} or {__name__="cluster:capacity_cpu_cores:sum"} or {__name__="cluster:capacity_memory_bytes:sum"} or {__name__="cluster:cpu_usage_cores:sum"} or {__name__="cluster:memory_usage_bytes:sum"} or {__name__="openshift:cpu_usage_cores:sum"} or {__name__="openshift:memory_usage_bytes:sum"} or {__name__="workload:cpu_usage_cores:sum"} or {__name__="workload:memory_usage_bytes:sum"} or {__name__="cluster:virt_platform_nodes:sum"} or {__name__="cluster:node_instance_type_count:sum"} or {__name__="cnv:vmi_status_running:count"} or {__name__="node_role_os_version_machine:cpu_capacity_cores:sum"} or {__name__="subscription_sync_total"} or {__name__="ceph_cluster_total_bytes"} or {__name__="ceph_cluster_total_used_raw_bytes"} or {__name__="ceph_health_status"} or {__name__="job:ceph_osd_metadata:count"} or {__name__="job:kube_pv:count"} or {__name__="job:ceph_pools_iops:total"} or {__name__="job:ceph_pools_iops_bytes:total"} or {__name__="job:ceph_versions_running:count"} or {__name__="job:noobaa_total_unhealthy_buckets:sum"} or {__name__="job:noobaa_bucket_count:sum"} or {__name__="job:noobaa_total_object_count:sum"} or {__name__="noobaa_accounts_num"} or {__name__="noobaa_total_usage"} or {__name__="console_url"}
```

For reference, here is an example response produced by a running OpenShift cluster:

[embedmd]:# (../test/timeseries.txt)
```txt
# This file was generated using `make test/timeseries.txt`.
# TYPE ALERTS untyped
ALERTS{alertname="Watchdog",alertstate="firing",severity="none",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168610163
# TYPE cluster:capacity_cpu_cores:sum untyped
cluster:capacity_cpu_cores:sum{label_beta_kubernetes_io_instance_type="m5.large",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 6 1562168616662
cluster:capacity_cpu_cores:sum{label_beta_kubernetes_io_instance_type="m5.xlarge",label_node_role_kubernetes_io="master",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 12 1562168616662
# TYPE cluster:capacity_memory_bytes:sum untyped
cluster:capacity_memory_bytes:sum{label_beta_kubernetes_io_instance_type="m5.large",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 2.41496064e+10 1562168616662
cluster:capacity_memory_bytes:sum{label_beta_kubernetes_io_instance_type="m5.xlarge",label_node_role_kubernetes_io="master",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 4.8987103232e+10 1562168616662
# TYPE cluster:cpu_usage_cores:sum untyped
cluster:cpu_usage_cores:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.6920000000000686 1562168616662
# TYPE cluster:memory_usage_bytes:sum untyped
cluster:memory_usage_bytes:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.4823510016e+10 1562168616662
# TYPE cluster:node_instance_type_count:sum untyped
cluster:node_instance_type_count:sum{label_beta_kubernetes_io_instance_type="m5.large",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 3 1562168616662
cluster:node_instance_type_count:sum{label_beta_kubernetes_io_instance_type="m5.xlarge",label_node_role_kubernetes_io="master",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 3 1562168616662
# TYPE cluster_installer untyped
cluster_installer{endpoint="metrics",instance="10.0.150.196:9099",invoker="alex",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="openshift-install",version="unreleased-master-1209-gfd08f44181f2111486749e2fb38399088f315cfb",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
# TYPE cluster_operator_conditions untyped
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="Ready",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-packageserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="support",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="NoCredentialsFailing",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-packageserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="support",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Disabled",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="support",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="Disabled",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="ReconcilingComplete",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="Ready",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-packageserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="support",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="Disabled",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",reason="AsExpected",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
# TYPE cluster_operator_up untyped
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817_openshift",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="support",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="operator-lifecycle-manager-packageserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
cluster_operator_up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
# TYPE cluster_version untyped
cluster_version{endpoint="metrics",from_version="4.2.0-0.okd-2019-07-03-073817",image="quay.io/crawford/openshift-release@sha256:6a262d69ab8a4013aee6f964d30cc9dccf69a4ed6583b03098fb5fa4460f0a9a",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="cluster",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.562147327e+09 1562168623759
cluster_version{endpoint="metrics",from_version="4.2.0-0.okd-2019-07-03-073817",image="quay.io/crawford/openshift-release@sha256:6a262d69ab8a4013aee6f964d30cc9dccf69a4ed6583b03098fb5fa4460f0a9a",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="current",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.562145933e+09 1562168623759
cluster_version{endpoint="metrics",image="quay.io/crawford/openshift-release@sha256:6a262d69ab8a4013aee6f964d30cc9dccf69a4ed6583b03098fb5fa4460f0a9a",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="completed",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.562148306e+09 1562168623759
cluster_version{endpoint="metrics",image="quay.io/crawford/openshift-release@sha256:6a262d69ab8a4013aee6f964d30cc9dccf69a4ed6583b03098fb5fa4460f0a9a",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="initial",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.562147327e+09 1562168623759
# TYPE cluster_version_available_updates untyped
cluster_version_available_updates{channel="stable-4.2",endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",upstream="https://api.openshift.com/api/upgrades_info/v1/graph",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
# TYPE cluster_version_payload untyped
cluster_version_payload{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="applied",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 399 1562168623759
cluster_version_payload{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",type="pending",version="4.2.0-0.okd-2019-07-03-073817",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1562168623759
# TYPE code:apiserver_request_count:rate:sum untyped
code:apiserver_request_count:rate:sum{code="200",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 33.082456140350565 1562168623634
code:apiserver_request_count:rate:sum{code="201",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 4.231578947368422 1562168623634
code:apiserver_request_count:rate:sum{code="404",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0.5087719298245614 1562168623634
code:apiserver_request_count:rate:sum{code="409",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0.21403508771929822 1562168623634
# TYPE node_uname_info gauge
node_uname_info{domainname="(none)",endpoint="https",instance="10.0.141.152:9100",job="node-exporter",machine="x86_64",namespace="openshift-monitoring",nodename="ip-10-0-141-152",pod="node-exporter-ncdgg",release="4.18.0-80.1.2.el8_0.x86_64",service="node-exporter",sysname="Linux",version="#1 SMP Sun Apr 28 09:21:22 UTC 2019"}    1
node_uname_info{domainname="(none)",endpoint="https",instance="10.0.141.66:9100",job="node-exporter",machine="x86_64",namespace="openshift-monitoring",nodename="ip-10-0-141-66",pod="node-exporter-7rzzv",release="4.18.0-80.1.2.el8_0.x86_64",service="node-exporter",sysname="Linux",version="#1 SMP Sun Apr 28 09:21:22 UTC 2019"}    1
node_uname_info{domainname="(none)",endpoint="https",instance="10.0.148.170:9100",job="node-exporter",machine="x86_64",namespace="openshift-monitoring",nodename="ip-10-0-148-170",pod="node-exporter-q8h8m",release="4.18.0-80.1.2.el8_0.x86_64",service="node-exporter",sysname="Linux",version="#1 SMP Sun Apr 28 09:21:22 UTC 2019"}    1
node_uname_info{domainname="(none)",endpoint="https",instance="10.0.149.139:9100",job="node-exporter",machine="x86_64",namespace="openshift-monitoring",nodename="ip-10-0-149-139",pod="node-exporter-r9vr2",release="4.18.0-80.1.2.el8_0.x86_64",service="node-exporter",sysname="Linux",version="#1 SMP Sun Apr 28 09:21:22 UTC 2019"}    1
node_uname_info{domainname="(none)",endpoint="https",instance="10.0.172.222:9100",job="node-exporter",machine="x86_64",namespace="openshift-monitoring",nodename="ip-10-0-172-222",pod="node-exporter-75p8p",release="4.18.0-80.1.2.el8_0.x86_64",service="node-exporter",sysname="Linux",version="#1 SMP Sun Apr 28 09:21:22 UTC 2019"}    1
node_uname_info{domainname="(none)",endpoint="https",instance="10.0.173.13:9100",job="node-exporter",machine="x86_64",namespace="openshift-monitoring",nodename="ip-10-0-173-13",pod="node-exporter-gxh8t",release="4.18.0-80.1.2.el8_0.x86_64",service="node-exporter",sysname="Linux",version="#1 SMP Sun Apr 28 09:21:22 UTC 2019"}    1
# TYPE instance:etcd_object_counts:sum untyped
instance:etcd_object_counts:sum{instance="10.0.131.31:6443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 2646 1562168616662
instance:etcd_object_counts:sum{instance="10.0.150.196:6443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 2818 1562168616662
instance:etcd_object_counts:sum{instance="10.0.166.205:6443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 2775 1562168616662
instance:etcd_object_counts:sum{instance="10.128.0.31:8443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 515 1562168616662
instance:etcd_object_counts:sum{instance="10.129.0.26:8443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 515 1562168616662
instance:etcd_object_counts:sum{instance="10.130.0.34:8443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 515 1562168616662
# TYPE kube_pod_status_ready:etcd:sum untyped
kube_pod_status_ready:etcd:sum{condition="true",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 3 1562168623634
# TYPE kube_pod_status_ready:image_registry:sum untyped
kube_pod_status_ready:image_registry:sum{condition="true",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623634
# TYPE openshift:cpu_usage_cores:sum untyped
openshift:cpu_usage_cores:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.7143732519333255 1562168616662
# TYPE openshift:memory_usage_bytes:sum untyped
openshift:memory_usage_bytes:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.8395660288e+10 1562168616662
# TYPE job:noobaa_bucket_count:sum untyped
job:noobaa_bucket_count:sum{instance="",prometheus="ocsdemo/example",prometheus_replica="prometheus-example-0"} 4 1564496667435
# TYPE job:noobaa_total_object_count:sum untyped
job:noobaa_total_object_count:sum{instance="",prometheus="ocsdemo/example",prometheus_replica="prometheus-example-0"} 10 1564496667435
# TYPE job:noobaa_total_unhealthy_buckets:sum untyped
job:noobaa_total_unhealthy_buckets:sum{instance="",prometheus="ocsdemo/example",prometheus_replica="prometheus-example-0"} 1 1564496667435
# TYPE noobaa_accounts_num untyped
noobaa_accounts_num{endpoint="mgmt",instance="10.131.1.141:8080",job="noobaa-mgmt",namespace="ocsdemo",pod="noobaa-server-0",service="noobaa-mgmt",prometheus="ocsdemo/example",prometheus_replica="prometheus-example-0"} 3 1564496667435
# TYPE noobaa_total_usage untyped
noobaa_total_usage{endpoint="mgmt",instance="10.131.1.141:8080",job="noobaa-mgmt",namespace="ocsdemo",pod="noobaa-server-0",service="noobaa-mgmt",prometheus="ocsdemo/example",prometheus_replica="prometheus-example-0"} 593096 1564496667435
# TYPE up untyped
up{endpoint="mgmt",instance="10.131.1.141:8080",job="noobaa-mgmt",namespace="ocsdemo",pod="noobaa-server-0",service="noobaa-mgmt",prometheus="ocsdemo/example",prometheus_replica="prometheus-example-0"} 1 1564496664533
up{endpoint="https",instance="10.0.169.146:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-w9fjk",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168612460
up{endpoint="crio",instance="10.0.131.31:9537",job="crio",namespace="kube-system",node="ip-10-0-131-31.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168616576
up{endpoint="crio",instance="10.0.139.97:9537",job="crio",namespace="kube-system",node="ip-10-0-139-97.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168629557
up{endpoint="crio",instance="10.0.150.196:9537",job="crio",namespace="kube-system",node="ip-10-0-150-196.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168610236
up{endpoint="crio",instance="10.0.153.63:9537",job="crio",namespace="kube-system",node="ip-10-0-153-63.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168630433
up{endpoint="crio",instance="10.0.166.205:9537",job="crio",namespace="kube-system",node="ip-10-0-166-205.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168621314
up{endpoint="crio",instance="10.0.169.146:9537",job="crio",namespace="kube-system",node="ip-10-0-169-146.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168613115
up{endpoint="etcd-metrics",instance="10.0.131.31:9979",job="etcd",namespace="openshift-etcd",pod="etcd-member-ip-10-0-131-31.us-west-2.compute.internal",service="etcd",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168617855
up{endpoint="etcd-metrics",instance="10.0.150.196:9979",job="etcd",namespace="openshift-etcd",pod="etcd-member-ip-10-0-150-196.us-west-2.compute.internal",service="etcd",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168628148
up{endpoint="etcd-metrics",instance="10.0.166.205:9979",job="etcd",namespace="openshift-etcd",pod="etcd-member-ip-10-0-166-205.us-west-2.compute.internal",service="etcd",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168637138
up{endpoint="http",instance="10.129.0.23:8080",job="cluster-monitoring-operator",namespace="openshift-monitoring",pod="cluster-monitoring-operator-758fc6d995-5vs7k",service="cluster-monitoring-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168614989
up{endpoint="http",instance="10.129.2.5:8080",job="prometheus-operator",namespace="openshift-monitoring",pod="prometheus-operator-6859c6f7b8-4z9gp",service="prometheus-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168637095
up{endpoint="https",instance="10.0.131.31:10257",job="kube-controller-manager",namespace="openshift-kube-controller-manager",pod="kube-controller-manager-ip-10-0-131-31.us-west-2.compute.internal",service="kube-controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168619982
up{endpoint="https",instance="10.0.131.31:10259",job="scheduler",namespace="openshift-kube-scheduler",pod="openshift-kube-scheduler-ip-10-0-131-31.us-west-2.compute.internal",service="scheduler",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168620884
up{endpoint="https",instance="10.0.131.31:6443",job="apiserver",namespace="default",service="kubernetes",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168627368
up{endpoint="https",instance="10.0.131.31:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-sph4k",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168625122
up{endpoint="https",instance="10.0.139.97:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-vqtjg",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168638862
up{endpoint="https",instance="10.0.150.196:10257",job="kube-controller-manager",namespace="openshift-kube-controller-manager",pod="kube-controller-manager-ip-10-0-150-196.us-west-2.compute.internal",service="kube-controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168620415
up{endpoint="https",instance="10.0.150.196:10259",job="scheduler",namespace="openshift-kube-scheduler",pod="openshift-kube-scheduler-ip-10-0-150-196.us-west-2.compute.internal",service="scheduler",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168628690
up{endpoint="https",instance="10.0.150.196:6443",job="apiserver",namespace="default",service="kubernetes",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168619534
up{endpoint="https",instance="10.0.150.196:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-g4nlq",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168619465
up{endpoint="https",instance="10.0.153.63:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-m9r76",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168632421
up{endpoint="https",instance="10.0.166.205:10257",job="kube-controller-manager",namespace="openshift-kube-controller-manager",pod="kube-controller-manager-ip-10-0-166-205.us-west-2.compute.internal",service="kube-controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168619024
up{endpoint="https",instance="10.0.166.205:10259",job="scheduler",namespace="openshift-kube-scheduler",pod="openshift-kube-scheduler-ip-10-0-166-205.us-west-2.compute.internal",service="scheduler",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168634015
up{endpoint="https",instance="10.0.166.205:6443",job="apiserver",namespace="default",service="kubernetes",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168627766
up{endpoint="https",instance="10.0.166.205:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-mrc4f",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168629550
up{endpoint="5000-tcp",instance="10.131.0.5:5000",job="image-registry",namespace="openshift-image-registry",pod="image-registry-6fb849db55-457xq",service="image-registry",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168610834
up{endpoint="https",instance="10.128.0.10:8443",job="metrics",namespace="openshift-kube-controller-manager-operator",pod="kube-controller-manager-operator-565bbd4d87-mdw4h",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168618120
up{endpoint="https",instance="10.128.0.31:8443",job="api",namespace="openshift-apiserver",pod="apiserver-vmsv9",service="api",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168613252
up{endpoint="https",instance="10.128.0.33:8443",job="controller-manager",namespace="openshift-controller-manager",pod="controller-manager-644kj",service="controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168611038
up{endpoint="https",instance="10.128.0.4:8443",job="metrics",namespace="openshift-kube-apiserver-operator",pod="kube-apiserver-operator-97b9d7789-p5njb",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168625423
up{endpoint="https",instance="10.128.0.6:8443",job="metrics",namespace="openshift-controller-manager-operator",pod="openshift-controller-manager-operator-84bb5b4c8-579sr",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168616570
up{endpoint="https",instance="10.128.0.9:8443",job="metrics",namespace="openshift-apiserver-operator",pod="openshift-apiserver-operator-585b7cdffb-5dqz6",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168629658
up{endpoint="https",instance="10.128.2.4:3000",job="grafana",namespace="openshift-monitoring",pod="grafana-66b94d49dc-g9lrx",service="grafana",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168630842
up{endpoint="https",instance="10.129.0.26:8443",job="api",namespace="openshift-apiserver",pod="apiserver-zpsjj",service="api",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168624750
up{endpoint="https",instance="10.129.0.29:8443",job="controller-manager",namespace="openshift-controller-manager",pod="controller-manager-l5slz",service="controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168608984
up{endpoint="https",instance="10.129.0.33:6443",job="oauth-openshift",namespace="openshift-authentication",pod="oauth-openshift-5d7fddfd46-7zzpc",service="oauth-openshift",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168630484
up{endpoint="https",instance="10.130.0.14:8443",job="metrics",namespace="openshift-service-catalog-controller-manager-operator",pod="openshift-service-catalog-controller-manager-operator-5f7c4nqhb",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168625328
up{endpoint="https",instance="10.130.0.15:8443",job="metrics",namespace="openshift-authentication-operator",pod="authentication-operator-748b6896f4-ggn2k",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168631800
up{endpoint="https",instance="10.130.0.34:8443",job="api",namespace="openshift-apiserver",pod="apiserver-86l6c",service="api",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168636756
up{endpoint="https",instance="10.130.0.38:8443",job="controller-manager",namespace="openshift-controller-manager",pod="controller-manager-dxqkv",service="controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168637239
up{endpoint="https",instance="10.130.0.40:6443",job="oauth-openshift",namespace="openshift-authentication",pod="oauth-openshift-5d7fddfd46-dk8t2",service="oauth-openshift",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168629611
up{endpoint="https",instance="10.131.0.6:8443",job="telemeter-client",namespace="openshift-monitoring",pod="telemeter-client-7864f6d769-kpbjm",service="telemeter-client",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168625392
up{endpoint="https-main",instance="10.131.0.10:8443",job="kube-state-metrics",namespace="openshift-monitoring",pod="kube-state-metrics-7587dcb8d7-b6cbf",service="kube-state-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168608463
up{endpoint="https-metrics",instance="10.0.131.31:10250",job="kubelet",namespace="kube-system",node="ip-10-0-131-31.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168637805
up{endpoint="https-metrics",instance="10.0.139.97:10250",job="kubelet",namespace="kube-system",node="ip-10-0-139-97.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168618792
up{endpoint="https-metrics",instance="10.0.150.196:10250",job="kubelet",namespace="kube-system",node="ip-10-0-150-196.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168631448
up{endpoint="https-metrics",instance="10.0.153.63:10250",job="kubelet",namespace="kube-system",node="ip-10-0-153-63.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168636839
up{endpoint="https-metrics",instance="10.0.166.205:10250",job="kubelet",namespace="kube-system",node="ip-10-0-166-205.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168634127
up{endpoint="https-metrics",instance="10.0.169.146:10250",job="kubelet",namespace="kube-system",node="ip-10-0-169-146.us-west-2.compute.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168632428
up{endpoint="https-metrics",instance="10.128.0.13:8081",job="catalog-operator-metrics",namespace="openshift-operator-lifecycle-manager",pod="catalog-operator-59f94675db-k6rzp",service="catalog-operator-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168610951
up{endpoint="https-metrics",instance="10.128.0.14:8081",job="olm-operator-metrics",namespace="openshift-operator-lifecycle-manager",pod="olm-operator-664fd645b7-khm5n",service="olm-operator-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168626165
up{endpoint="https-self",instance="10.131.0.10:9443",job="kube-state-metrics",namespace="openshift-monitoring",pod="kube-state-metrics-7587dcb8d7-b6cbf",service="kube-state-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168626791
up{endpoint="metrics",instance="10.0.131.31:9101",job="sdn",namespace="openshift-sdn",pod="sdn-cbw5n",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168633759
up{endpoint="metrics",instance="10.0.139.97:9101",job="sdn",namespace="openshift-sdn",pod="sdn-j72jt",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168616210
up{endpoint="metrics",instance="10.0.150.196:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-5cb5f8c9db-st825",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168623759
up{endpoint="metrics",instance="10.0.150.196:9101",job="sdn",namespace="openshift-sdn",pod="sdn-lwwmn",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168618425
up{endpoint="metrics",instance="10.0.153.63:9101",job="sdn",namespace="openshift-sdn",pod="sdn-wmznn",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168614502
up{endpoint="metrics",instance="10.0.166.205:9101",job="sdn",namespace="openshift-sdn",pod="sdn-w8m6v",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168614790
up{endpoint="metrics",instance="10.0.169.146:9101",job="sdn",namespace="openshift-sdn",pod="sdn-wlvd4",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168625620
up{endpoint="metrics",instance="10.128.0.11:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-lxblt",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168638006
up{endpoint="metrics",instance="10.128.2.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-4f9f6",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168620308
up{endpoint="metrics",instance="10.129.0.10:8080",job="cluster-autoscaler-operator",namespace="openshift-machine-api",pod="cluster-autoscaler-operator-758f875f98-7nd5b",service="cluster-autoscaler-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168614931
up{endpoint="metrics",instance="10.129.0.4:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-lms8m",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168617068
up{endpoint="metrics",instance="10.129.2.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-nx5nm",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168615473
up{endpoint="metrics",instance="10.129.2.4:1936",job="router-internal-default",namespace="openshift-ingress",pod="router-default-7d7fc5d857-t2gpw",service="router-internal-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168633608
up{endpoint="metrics",instance="10.130.0.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-22rph",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168611955
up{endpoint="metrics",instance="10.131.0.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-zmk5n",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168629067
up{endpoint="metrics",instance="10.131.0.3:1936",job="router-internal-default",namespace="openshift-ingress",pod="router-default-7d7fc5d857-6pqs4",service="router-internal-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168636295
up{endpoint="web",instance="10.128.2.6:9091",job="prometheus-k8s",namespace="openshift-monitoring",pod="prometheus-k8s-0",service="prometheus-k8s",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168621420
up{endpoint="web",instance="10.128.2.7:9094",job="alertmanager-main",namespace="openshift-monitoring",pod="alertmanager-main-1",service="alertmanager-main",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168619299
up{endpoint="web",instance="10.129.2.6:9094",job="alertmanager-main",namespace="openshift-monitoring",pod="alertmanager-main-0",service="alertmanager-main",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168626501
up{endpoint="web",instance="10.129.2.8:9091",job="prometheus-k8s",namespace="openshift-monitoring",pod="prometheus-k8s-1",service="prometheus-k8s",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168629273
up{endpoint="web",instance="10.131.0.13:9094",job="alertmanager-main",namespace="openshift-monitoring",pod="alertmanager-main-2",service="alertmanager-main",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1562168616104
```
