package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ApplicationManifestsClient is the client for the ApplicationManifests methods of the Servicefabric service.
type ApplicationManifestsClient struct {
	BaseClient
}

// NewApplicationManifestsClient creates an instance of the ApplicationManifestsClient client.
func NewApplicationManifestsClient(timeout *int32) ApplicationManifestsClient {
	return NewApplicationManifestsClientWithBaseURI(DefaultBaseURI, timeout)
}

// NewApplicationManifestsClientWithBaseURI creates an instance of the ApplicationManifestsClient client.
func NewApplicationManifestsClientWithBaseURI(baseURI string, timeout *int32) ApplicationManifestsClient {
	return ApplicationManifestsClient{NewWithBaseURI(baseURI, timeout)}
}

// Get get application manifests
// Parameters:
// applicationTypeName - the name of the application type
// applicationTypeVersion - the version of the application type
func (client ApplicationManifestsClient) Get(ctx context.Context, applicationTypeName string, applicationTypeVersion string) (result ApplicationManifest, err error) {
	req, err := client.GetPreparer(ctx, applicationTypeName, applicationTypeVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationManifestsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationManifestsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationManifestsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ApplicationManifestsClient) GetPreparer(ctx context.Context, applicationTypeName string, applicationTypeVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationTypeName": autorest.Encode("path", applicationTypeName),
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version":            APIVersion,
		"ApplicationTypeVersion": autorest.Encode("query", applicationTypeVersion),
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/ApplicationTypes/{applicationTypeName}/$/GetApplicationManifest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ApplicationManifestsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ApplicationManifestsClient) GetResponder(resp *http.Response) (result ApplicationManifest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
