"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDeviceRow = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _FormFactory = require("../Form/FormFactory");

var _CancelAcceptButtons = require("../CancelAcceptButtons");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const getActions = (valid, device, LoadingComponent, onAccept, onCancel) => device.creating ? _react.default.createElement(LoadingComponent, null) : _react.default.createElement(_CancelAcceptButtons.CancelAcceptButtons, {
  onAccept: onAccept,
  onCancel: onCancel,
  disabled: !valid
});

class CreateDeviceRow extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      valid: false
    });

    _defineProperty(this, "onFormChange", (newValue, key, valid) => {
      this.props.onChange(newValue, key);
      this.setState({
        valid
      });
    });
  }

  render() {
    const _this$props = this.props,
          device = _this$props.device,
          onAccept = _this$props.onAccept,
          onCancel = _this$props.onCancel,
          LoadingComponent = _this$props.LoadingComponent,
          deviceFields = _this$props.deviceFields,
          columnSizes = _this$props.columnSizes;
    const actions = getActions(this.state.valid, device, LoadingComponent, onAccept, onCancel);
    return _react.default.createElement(_FormFactory.ListFormFactory, {
      fields: deviceFields,
      fieldsValues: device,
      actions: actions,
      onFormChange: this.onFormChange,
      columnSizes: columnSizes
    });
  }

}

exports.CreateDeviceRow = CreateDeviceRow;
CreateDeviceRow.propTypes = {
  device: _propTypes.default.object.isRequired,
  onChange: _propTypes.default.func.isRequired,
  onAccept: _propTypes.default.func.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  LoadingComponent: _propTypes.default.func.isRequired,
  deviceFields: _propTypes.default.object.isRequired,
  columnSizes: _propTypes.default.object.isRequired
};