"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateNicRow = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _CreateDeviceRow = require("../CreateDeviceRow");

var _selectors = require("../../utils/selectors");

var _validations = require("../../utils/validations");

var _constants = require("../../constants");

var _strings = require("../Wizard/CreateVmWizard/strings");

var _constants2 = require("../Wizard/CreateVmWizard/constants");

var _Loading = require("../Loading");

var _selectors2 = require("../../k8s/selectors");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const columnSizes = {
  lg: 3,
  md: 3,
  sm: 3,
  xs: 3
};

const getUsedNetworks = vm => {
  const interfaces = (0, _selectors.getInterfaces)(vm);
  const networks = (0, _selectors.getNetworks)(vm);
  const usedNetworks = [];
  interfaces.forEach(i => {
    const network = networks.find(n => n.name === i.name);

    if (network) {
      if (network.pod) {
        usedNetworks.push({
          networkType: _constants2.NETWORK_TYPE_POD
        });
      }

      if (network.multus) {
        usedNetworks.push({
          networkType: _constants2.NETWORK_TYPE_MULTUS,
          name: network.multus.networkName
        });
      }
    }
  });
  return usedNetworks;
};

const getNetworkChoices = (vm, networks) => {
  const usedNetworks = getUsedNetworks(vm);
  const networkChoices = networks.filter(network => network.metadata.namespace === vm.metadata.namespace && !usedNetworks.filter(usedNetwork => usedNetwork.networkType === _constants2.NETWORK_TYPE_MULTUS).find(usedNetwork => usedNetwork.name === (0, _selectors.getName)(network))).map(network => ({
    name: (0, _selectors.getName)(network),
    networkType: _constants2.NETWORK_TYPE_MULTUS
  }));

  if (!usedNetworks.find(usedNetwork => usedNetwork.networkType === _constants2.NETWORK_TYPE_POD)) {
    networkChoices.push({
      name: _constants.POD_NETWORK,
      networkType: _constants2.NETWORK_TYPE_POD
    });
  }

  return networkChoices;
};

const getNicColumns = (nic, networks, LoadingComponent) => {
  let network;

  if (networks) {
    const networkChoices = getNetworkChoices(nic.vm, networks);
    network = {
      id: 'network-type',
      type: 'dropdown',
      defaultValue: networkChoices.length === 0 ? '--- No Network Definition Available ---' : _strings.SELECT_NETWORK,
      choices: networkChoices,
      disabled: nic.creating || networkChoices.length === 0,
      required: true
    };
  } else {
    network = {
      id: 'network-type-loading',
      type: 'loading',
      LoadingComponent,
      required: true
    };
  }

  return {
    name: {
      id: 'nic-name',
      validate: _validations.validateDNS1123SubdomainValue,
      required: true,
      title: _strings.HEADER_NIC_NAME,
      disabled: nic.creating
    },
    model: {
      id: 'nic-model',
      type: 'label'
    },
    network,
    mac: {
      id: 'mac-address',
      title: _strings.HEADER_MAC,
      disabled: nic.creating || (0, _lodash.get)((0, _selectors2.settingsValue)(nic, 'network'), 'networkType') === _constants2.NETWORK_TYPE_POD
    }
  };
};

const onFormChange = (newValue, key, onChange) => {
  if (key === 'network' && (0, _lodash.get)(newValue, 'value.networkType') === _constants2.NETWORK_TYPE_POD) {
    // reset mac value
    onChange({
      value: ''
    }, 'mac');
  }

  onChange(newValue, key);
};

const CreateNicRow = ({
  nic,
  onAccept,
  onCancel,
  onChange: _onChange,
  networks,
  LoadingComponent
}) => _react.default.createElement(_CreateDeviceRow.CreateDeviceRow, {
  onAccept: onAccept,
  onCancel: onCancel,
  onChange: (newValue, key) => onFormChange(newValue, key, _onChange),
  device: nic,
  LoadingComponent: LoadingComponent,
  columnSizes: columnSizes,
  deviceFields: getNicColumns(nic, networks, LoadingComponent)
});

exports.CreateNicRow = CreateNicRow;
CreateNicRow.propTypes = {
  nic: _propTypes.default.object.isRequired,
  onChange: _propTypes.default.func.isRequired,
  onAccept: _propTypes.default.func.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  networks: _propTypes.default.array,
  LoadingComponent: _propTypes.default.func
};
CreateNicRow.defaultProps = {
  networks: undefined,
  LoadingComponent: _Loading.Loading
};