"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flavor = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../../utils");

var _InlineEdit = require("../../InlineEdit/InlineEdit");

var _constants = require("../../../constants");

var _selectors = require("../../../k8s/selectors");

var _Loading = require("../../Loading/Loading");

var _FormFactory = require("../../Form/FormFactory");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Flavor extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "resolveInitialValues", () => {
      const flavor = (0, _utils.getFlavor)(this.props.vm) || _constants.CUSTOM_FLAVOR;

      const cpu = (0, _utils.getCpu)(this.props.vm);
      const memory = (0, _utils.getMemory)(this.props.vm);
      const memoryInt = memory ? parseInt(memory, 10) : undefined;
      this.props.onFormChange({
        value: flavor
      }, 'flavor', flavor !== _constants.CUSTOM_FLAVOR);

      if (flavor === _constants.CUSTOM_FLAVOR) {
        this.props.onFormChange({
          value: cpu
        }, 'cpu', !!cpu);
        this.props.onFormChange({
          value: memoryInt
        }, 'memory', !!memoryInt);
      }
    });

    _defineProperty(this, "getFlavorDescription", () => {
      const cpu = (0, _utils.getCpu)(this.props.vm);
      const memory = (0, _utils.getMemory)(this.props.vm);
      const cpuStr = cpu ? `${cpu} CPU` : '';
      const memoryStr = memory ? `${memory} Memory` : '';
      const resourceStr = cpuStr && memoryStr ? `${cpuStr}, ${memoryStr}` : `${cpuStr}${memoryStr}`;
      return resourceStr ? _react.default.createElement("div", null, resourceStr) : undefined;
    });

    _defineProperty(this, "getFlavorChoices", () => {
      const flavors = [];

      if (this.state.template) {
        flavors.push(...(0, _selectors.getTemplateFlavors)([this.state.template]));
      }

      if (!flavors.some(flavor => flavor === _constants.CUSTOM_FLAVOR)) {
        flavors.push(_constants.CUSTOM_FLAVOR);
      }

      return flavors;
    });

    _defineProperty(this, "flavorFormFields", () => ({
      flavor: {
        id: 'flavor-dropdown',
        type: 'dropdown',
        choices: this.getFlavorChoices()
      },
      cpu: {
        id: 'flavor-cpu',
        title: 'CPU',
        type: 'positive-number',
        required: true,
        isVisible: formValues => (0, _selectors.settingsValue)(formValues, 'flavor') === _constants.CUSTOM_FLAVOR
      },
      memory: {
        id: 'flavor-memory',
        title: 'Memory (GB)',
        type: 'positive-number',
        required: true,
        isVisible: formValues => (0, _selectors.settingsValue)(formValues, 'flavor') === _constants.CUSTOM_FLAVOR
      }
    }));

    this.state = {
      loadingTemplate: false,
      template: null
    };
    this.resolveInitialValues();
  }

  componentDidMount() {
    this.setState({
      loadingTemplate: true
    });
    const promise = (0, _utils.retrieveVmTemplate)(this.props.k8sGet, this.props.vm);
    promise.then(result => {
      this.props.onFormChange(result, 'template', (0, _FormFactory.validateForm)(this.flavorFormFields(), this.props.formValues));
      return this.setState({
        loadingTemplate: false,
        template: result
      });
    }).catch(error => {
      this.props.onLoadError(error.message || 'An error occurred while loading vm flavors. Please try again.');
      return this.setState({
        loadingTemplate: false,
        template: null
      });
    });
  }

  render() {
    const _this$props = this.props,
          editing = _this$props.editing,
          updating = _this$props.updating,
          LoadingComponent = _this$props.LoadingComponent,
          onFormChange = _this$props.onFormChange;
    const formFields = this.flavorFormFields();
    return _react.default.createElement(_InlineEdit.InlineEdit, {
      formFields: formFields,
      editing: editing,
      updating: updating || editing && this.state.loadingTemplate,
      LoadingComponent: LoadingComponent,
      onFormChange: onFormChange,
      fieldsValues: this.props.formValues
    }, _react.default.createElement("div", null, (0, _utils.getFlavor)(this.props.vm) || _constants.CUSTOM_FLAVOR), this.getFlavorDescription());
  }

}

exports.Flavor = Flavor;
Flavor.propTypes = {
  vm: _propTypes.default.object.isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  updating: _propTypes.default.bool,
  editing: _propTypes.default.bool,
  k8sGet: _propTypes.default.func.isRequired,
  LoadingComponent: _propTypes.default.func,
  formValues: _propTypes.default.object,
  onLoadError: _propTypes.default.func
};
Flavor.defaultProps = {
  updating: false,
  editing: false,
  LoadingComponent: _Loading.Loading,
  formValues: undefined,
  onLoadError: () => {}
};