"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicMigrationDialog = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _selectors = require("../../../utils/selectors");

var _migrate = require("../../../k8s/migrate");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const BasicMigrationDialog = ({
  k8sCreate,
  onCancel,
  onClose,
  onMigrationError,
  virtualMachineInstance
}) => {
  const onMigrate = () => {
    onClose();
    (0, _migrate.migrate)(k8sCreate, virtualMachineInstance).catch(onMigrationError);
  };

  const message = `Do you wish to migrate ${(0, _selectors.getName)(virtualMachineInstance)} vmi to another node?`;
  return _react.default.createElement(_patternflyReact.MessageDialog, {
    show: true,
    onHide: onCancel,
    primaryAction: onMigrate,
    secondaryAction: onCancel,
    primaryActionButtonContent: "Migrate",
    secondaryActionButtonContent: "Cancel",
    title: "Migrate Virtual Machine",
    primaryContent: message,
    accessibleName: "migrateConfirmationDialog",
    accessibleDescription: "migrateConfirmationDialogContent"
  });
};

exports.BasicMigrationDialog = BasicMigrationDialog;
BasicMigrationDialog.propTypes = {
  k8sCreate: _propTypes.default.func.isRequired,
  onClose: _propTypes.default.func.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  onMigrationError: _propTypes.default.func.isRequired,
  virtualMachineInstance: _propTypes.default.object.isRequired
};