"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dropdown = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const Dropdown = ({
  id,
  value,
  disabled,
  onChange,
  choices
}) => {
  const title = typeof value === 'object' ? value.name || value.id : value;
  return _react.default.createElement(_patternflyReact.ButtonGroup, {
    justified: true,
    key: id
  }, _react.default.createElement(_patternflyReact.DropdownButton, {
    id: id,
    bsStyle: "default",
    className: "kubevirt-dropdown",
    title: title,
    disabled: disabled,
    onSelect: onChange
  }, choices.map(choice => {
    const isObject = typeof choice === 'object';
    const key = isObject ? choice.id || choice.name : choice;
    const val = isObject ? choice.name : choice;
    return _react.default.createElement(_patternflyReact.MenuItem, {
      key: key,
      eventKey: choice
    }, val);
  })));
};

exports.Dropdown = Dropdown;
Dropdown.defaultProps = {
  onChange: _patternflyReact.noop,
  disabled: false
};
Dropdown.propTypes = {
  id: _propTypes.default.string.isRequired,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]).isRequired,
  choices: _propTypes.default.array.isRequired,
  onChange: _propTypes.default.func,
  disabled: _propTypes.default.bool
};