"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Text = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const Text = ({
  id,
  value,
  disabled,
  defaultValue,
  onChange,
  onBlur
}) => _react.default.createElement(_patternflyReact.FormControl, {
  id: id,
  key: id,
  type: "text",
  value: value,
  defaultValue: defaultValue,
  onBlur: (0, _utils.eventValueHandler)(onBlur),
  onChange: (0, _utils.eventValueHandler)(onChange),
  disabled: disabled
});

exports.Text = Text;
Text.defaultProps = {
  value: undefined,
  defaultValue: undefined,
  onChange: _patternflyReact.noop,
  onBlur: _patternflyReact.noop,
  disabled: false
};
Text.propTypes = {
  id: _propTypes.default.string.isRequired,
  value: _propTypes.default.string,
  defaultValue: _propTypes.default.string,
  onChange: _propTypes.default.func,
  onBlur: _propTypes.default.func,
  disabled: _propTypes.default.bool
};