"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineEdit = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _FormFactory = require("../Form/FormFactory");

var _Loading = require("../Loading/Loading");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const InlineEdit = ({
  updating,
  editing,
  formFields,
  LoadingComponent,
  children,
  onFormChange,
  fieldsValues
}) => {
  if (updating) {
    return _react.default.createElement(LoadingComponent, null);
  }

  if (editing) {
    return _react.default.createElement(_FormFactory.InlineFormFactory, {
      fields: formFields,
      fieldsValues: fieldsValues,
      onFormChange: onFormChange
    });
  }

  return _react.default.createElement("div", null, children);
};

exports.InlineEdit = InlineEdit;
InlineEdit.propTypes = {
  updating: _propTypes.default.bool,
  editing: _propTypes.default.bool,
  formFields: _propTypes.default.object,
  LoadingComponent: _propTypes.default.func,
  children: _propTypes.default.node.isRequired,
  onFormChange: _propTypes.default.func,
  fieldsValues: _propTypes.default.object
};
InlineEdit.defaultProps = {
  updating: false,
  editing: false,
  formFields: {},
  LoadingComponent: _Loading.Loading,
  onFormChange: () => {},
  fieldsValues: {}
};