"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateSource = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _templates = require("../../utils/templates");

var _constants = require("../../constants");

var _selectors = require("../../utils/selectors");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const tooltip = (id, source) => _react.default.createElement(_patternflyReact.Tooltip, {
  id: id
}, source);

const TemplateSource = ({
  template,
  tooltipPlacement
}) => {
  const provisionSource = (0, _templates.getTemplateProvisionSource)(template);

  if (provisionSource) {
    if (provisionSource.type === _constants.PROVISION_SOURCE_PXE) {
      return provisionSource.type;
    }

    return _react.default.createElement("div", {
      className: "kubevirt-template-source__overlay"
    }, _react.default.createElement(_patternflyReact.OverlayTrigger, {
      overlay: tooltip(`${(0, _selectors.getNamespace)(template)}-${(0, _selectors.getName)(template)}`, provisionSource.source),
      placement: tooltipPlacement,
      trigger: ['hover', 'focus'],
      rootClose: false
    }, _react.default.createElement("div", null, provisionSource.type)));
  }

  return '---';
};

exports.TemplateSource = TemplateSource;
TemplateSource.propTypes = {
  template: _propTypes.default.object.isRequired,
  tooltipPlacement: _propTypes.default.string
};
TemplateSource.defaultProps = {
  tooltipPlacement: 'top'
};