"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicSettingsTab = exports.getFormFields = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _FormFactory = require("../../Form/FormFactory");

var _selectors = require("../../../utils/selectors");

var _templates = require("../../../utils/templates");

var _validations = require("../../../utils/validations");

var _strings = require("./strings");

var _selectors2 = require("../../../k8s/selectors");

var _constants = require("../../../constants");

var _constants2 = require("./constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const getProvisionSourceHelp = basicSettings => {
  const provisionSource = (0, _selectors2.settingsValue)(basicSettings, _constants2.PROVISION_SOURCE_TYPE_KEY);

  switch (provisionSource) {
    case _constants.PROVISION_SOURCE_URL:
      return _strings.HELP_PROVISION_SOURCE_URL;

    case _constants.PROVISION_SOURCE_PXE:
      return _strings.HELP_PROVISION_SOURCE_PXE;

    case _constants.PROVISION_SOURCE_CONTAINER:
      return _strings.HELP_PROVISION_SOURCE_CONTAINER;

    default:
      return null;
  }
};

const getFormFields = (basicSettings, namespaces, templates, selectedNamespace, createTemplate) => {
  const userTemplate = (0, _lodash.get)(basicSettings[_constants2.USER_TEMPLATE_KEY], 'value');
  const workloadProfiles = (0, _selectors2.getWorkloadProfiles)(basicSettings, templates, userTemplate);
  const operatingSystems = (0, _selectors2.getOperatingSystems)(basicSettings, templates, userTemplate);
  const flavors = (0, _selectors2.getFlavors)(basicSettings, templates, userTemplate);
  const imageSources = [_constants.PROVISION_SOURCE_PXE, _constants.PROVISION_SOURCE_URL, _constants.PROVISION_SOURCE_CONTAINER];
  const userTemplateNames = (0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_VM).map(_selectors.getName);
  userTemplateNames.push(_strings.NO_TEMPLATE);
  let namespaceDropdown;
  let startVmCheckbox;
  let userTemplateDropdown;

  if (!selectedNamespace) {
    namespaceDropdown = {
      id: 'namespace-dropdown',
      title: 'Namespace',
      type: 'dropdown',
      defaultValue: '--- Select Namespace ---',
      choices: namespaces.map(_selectors.getName),
      required: true
    };
  }

  if (!createTemplate) {
    startVmCheckbox = {
      id: 'start-vm',
      title: 'Start virtual machine on creation',
      type: 'checkbox',
      noBottom: true
    };
    userTemplateDropdown = {
      id: 'template-dropdown',
      title: 'Template',
      type: 'dropdown',
      defaultValue: '--- Select Template ---',
      choices: userTemplateNames
    };
  }

  return {
    [_constants2.NAME_KEY]: {
      id: 'vm-name',
      title: 'Name',
      required: true,
      validate: _validations.validateDNS1123SubdomainValue
    },
    [_constants2.DESCRIPTION_KEY]: {
      id: 'vm-description',
      title: 'Description',
      type: 'textarea'
    },
    [_constants2.NAMESPACE_KEY]: namespaceDropdown,
    [_constants2.USER_TEMPLATE_KEY]: userTemplateDropdown,
    [_constants2.PROVISION_SOURCE_TYPE_KEY]: {
      id: 'image-source-type-dropdown',
      title: 'Provision Source',
      type: 'dropdown',
      defaultValue: '--- Select Provision Source ---',
      choices: imageSources,
      required: true,
      disabled: userTemplate !== undefined,
      help: getProvisionSourceHelp(basicSettings)
    },
    [_constants2.CONTAINER_IMAGE_KEY]: {
      id: 'provision-source-container',
      title: 'Container Image',
      required: true,
      isVisible: basicVmSettings => (0, _selectors2.isImageSourceType)(basicVmSettings, _constants.PROVISION_SOURCE_CONTAINER),
      disabled: userTemplate !== undefined,
      validate: _validations.validateContainer
    },
    [_constants2.IMAGE_URL_KEY]: {
      id: 'provision-source-url',
      title: 'URL',
      required: true,
      isVisible: basicVmSettings => (0, _selectors2.isImageSourceType)(basicVmSettings, _constants.PROVISION_SOURCE_URL),
      disabled: userTemplate !== undefined,
      validate: _validations.validateURL
    },
    [_constants2.OPERATING_SYSTEM_KEY]: {
      id: 'operating-system-dropdown',
      title: 'Operating System',
      type: 'dropdown',
      defaultValue: '--- Select Operating System ---',
      choices: operatingSystems,
      required: true,
      disabled: userTemplate !== undefined,
      help: _strings.HELP_OS
    },
    [_constants2.FLAVOR_KEY]: {
      id: 'flavor-dropdown',
      title: 'Flavor',
      type: 'dropdown',
      defaultValue: '--- Select Flavor ---',
      choices: flavors,
      required: true,
      disabled: userTemplate !== undefined && flavors.length === 1,
      help: _strings.HELP_FLAVOR
    },
    [_constants2.MEMORY_KEY]: {
      id: 'resources-memory',
      title: 'Memory (GB)',
      type: 'positive-number',
      required: true,
      isVisible: basicVmSettings => (0, _selectors2.isFlavorType)(basicVmSettings, _constants.CUSTOM_FLAVOR),
      help: _strings.HELP_MEMORY
    },
    [_constants2.CPU_KEY]: {
      id: 'resources-cpu',
      title: 'CPUs',
      type: 'positive-number',
      required: true,
      isVisible: basicVmSettings => (0, _selectors2.isFlavorType)(basicVmSettings, _constants.CUSTOM_FLAVOR),
      help: _strings.HELP_CPU
    },
    [_constants2.WORKLOAD_PROFILE_KEY]: {
      id: 'workload-profile-dropdown',
      title: 'Workload Profile',
      type: 'dropdown',
      defaultValue: '--- Select Workload Profile ---',
      choices: workloadProfiles,
      required: true,
      help: _strings.HELP_WORKLOAD,
      disabled: userTemplate !== undefined
    },
    [_constants2.START_VM_KEY]: startVmCheckbox,
    [_constants2.CLOUD_INIT_KEY]: {
      id: 'use-cloud-init',
      title: 'Use cloud-init',
      type: 'checkbox'
    },
    [_constants2.USE_CLOUD_INIT_CUSTOM_SCRIPT_KEY]: {
      id: 'use-cloud-init-custom-script',
      title: 'Use custom script',
      type: 'checkbox',
      isVisible: basicVmSettings => (0, _selectors2.settingsValue)(basicVmSettings, _constants2.CLOUD_INIT_KEY, false)
    },
    [_constants2.HOST_NAME_KEY]: {
      id: 'cloud-init-hostname',
      title: 'Hostname',
      isVisible: basicVmSettings => (0, _selectors2.settingsValue)(basicVmSettings, _constants2.CLOUD_INIT_KEY, false) && !(0, _selectors2.settingsValue)(basicVmSettings, _constants2.USE_CLOUD_INIT_CUSTOM_SCRIPT_KEY, false)
    },
    [_constants2.AUTHKEYS_KEY]: {
      id: 'cloud-init-ssh',
      title: 'Authenticated SSH Keys',
      type: 'textarea',
      isVisible: basicVmSettings => (0, _selectors2.settingsValue)(basicVmSettings, _constants2.CLOUD_INIT_KEY, false) && !(0, _selectors2.settingsValue)(basicVmSettings, _constants2.USE_CLOUD_INIT_CUSTOM_SCRIPT_KEY, false)
    },
    [_constants2.CLOUD_INIT_CUSTOM_SCRIPT_KEY]: {
      id: 'cloud-init-custom-script',
      title: 'Custom Script',
      type: 'textarea',
      className: 'kubevirt-create-vm-wizard__custom-cloud-script-textarea',
      isVisible: basicVmSettings => (0, _selectors2.settingsValue)(basicVmSettings, _constants2.CLOUD_INIT_KEY, false) && (0, _selectors2.settingsValue)(basicVmSettings, _constants2.USE_CLOUD_INIT_CUSTOM_SCRIPT_KEY, false)
    }
  };
};

exports.getFormFields = getFormFields;

const asValueObject = (value, validation) => ({
  value,
  validation
});

const publish = ({
  basicSettings,
  templates,
  onChange
}, value, target, formValid, formFields) => {
  const newBasicSettings = _objectSpread({}, basicSettings, {
    [target]: value
  });

  if (target === _constants2.USER_TEMPLATE_KEY) {
    if (value.value === _strings.NO_TEMPLATE) {
      newBasicSettings[target] = asValueObject(undefined);
    } else {
      const allTemplates = (0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_VM);

      if (allTemplates.length > 0) {
        const userTemplate = allTemplates.find(template => template.metadata.name === value.value);
        updateTemplateData(userTemplate, newBasicSettings);
      }
    }

    formValid = (0, _FormFactory.validateForm)(formFields, newBasicSettings);
  }

  onChange(newBasicSettings, formValid);
};

const updateTemplateData = (userTemplate, newBasicSettings) => {
  if (userTemplate) {
    const vm = (0, _selectors2.selectVm)(userTemplate.objects); // update flavor

    const _getTemplateFlavors = (0, _selectors2.getTemplateFlavors)([userTemplate]),
          _getTemplateFlavors2 = _slicedToArray(_getTemplateFlavors, 1),
          flavor = _getTemplateFlavors2[0];

    newBasicSettings[_constants2.FLAVOR_KEY] = asValueObject(flavor);

    if (flavor === _constants.CUSTOM_FLAVOR) {
      newBasicSettings.cpu = asValueObject((0, _selectors.getCpu)(vm));
      const memory = (0, _selectors.getMemory)(vm);
      newBasicSettings.memory = memory ? asValueObject(parseInt(memory, 10)) : undefined;
    } // update os


    const _getTemplateOperating = (0, _selectors2.getTemplateOperatingSystems)([userTemplate]),
          _getTemplateOperating2 = _slicedToArray(_getTemplateOperating, 1),
          os = _getTemplateOperating2[0];

    newBasicSettings[_constants2.OPERATING_SYSTEM_KEY] = asValueObject(os); // update workload profile

    const _getTemplateWorkloadP = (0, _selectors2.getTemplateWorkloadProfiles)([userTemplate]),
          _getTemplateWorkloadP2 = _slicedToArray(_getTemplateWorkloadP, 1),
          workload = _getTemplateWorkloadP2[0];

    newBasicSettings[_constants2.WORKLOAD_PROFILE_KEY] = asValueObject(workload); // update cloud-init

    const cloudInitUserData = (0, _selectors.getCloudInitUserData)(vm);

    if (cloudInitUserData) {
      newBasicSettings[_constants2.CLOUD_INIT_KEY] = asValueObject(true);
      newBasicSettings[_constants2.USE_CLOUD_INIT_CUSTOM_SCRIPT_KEY] = asValueObject(true);
      newBasicSettings[_constants2.CLOUD_INIT_CUSTOM_SCRIPT_KEY] = asValueObject(cloudInitUserData || '');
    } else if ((0, _lodash.get)(newBasicSettings[_constants2.CLOUD_INIT_KEY], 'value')) {
      newBasicSettings[_constants2.CLOUD_INIT_KEY] = asValueObject(false);
      newBasicSettings[_constants2.USE_CLOUD_INIT_CUSTOM_SCRIPT_KEY] = asValueObject(false);
    } // update provision source


    const provisionSource = (0, _templates.getTemplateProvisionSource)(userTemplate);

    if (provisionSource) {
      newBasicSettings[_constants2.PROVISION_SOURCE_TYPE_KEY] = asValueObject(provisionSource.type);

      switch (provisionSource.type) {
        case _constants.PROVISION_SOURCE_CONTAINER:
          newBasicSettings[_constants2.CONTAINER_IMAGE_KEY] = asValueObject(provisionSource.source);
          break;

        case _constants.PROVISION_SOURCE_URL:
          newBasicSettings[_constants2.IMAGE_URL_KEY] = asValueObject(provisionSource.source);
          break;

        case _constants.PROVISION_SOURCE_PXE:
          break;

        default:
          // eslint-disable-next-line
          console.warn(`Unknown provision source ${provisionSource.type}`);
          break;
      }
    } else {
      // eslint-disable-next-line
      console.warn(`Cannot detect provision source for template ${(0, _selectors.getName)(userTemplate)}`);
    }
  }

  return newBasicSettings;
};

class BasicSettingsTab extends _react.default.Component {
  constructor(_props) {
    super(_props);

    _defineProperty(this, "updateSelectedNamespace", props => {
      const basicSettings = props.basicSettings,
            namespaces = props.namespaces,
            selectedNamespace = props.selectedNamespace,
            templates = props.templates,
            createTemplate = props.createTemplate;
      const formFields = getFormFields(basicSettings, namespaces, templates, selectedNamespace, createTemplate);
      const valid = (0, _FormFactory.validateForm)(formFields, basicSettings);
      publish(props, asValueObject((0, _selectors.getName)(selectedNamespace)), _constants2.NAMESPACE_KEY, valid, formFields);
    });

    if (_props.selectedNamespace) {
      this.updateSelectedNamespace(_props);
    }
  }

  componentDidUpdate(prevProps) {
    const newNamespace = this.props.selectedNamespace;
    const oldNamespace = prevProps.selectedNamespace;

    if ((0, _selectors.getName)(newNamespace) !== (0, _selectors.getName)(oldNamespace)) {
      this.updateSelectedNamespace(this.props);
    }
  }

  render() {
    const _this$props = this.props,
          basicSettings = _this$props.basicSettings,
          namespaces = _this$props.namespaces,
          templates = _this$props.templates,
          selectedNamespace = _this$props.selectedNamespace,
          createTemplate = _this$props.createTemplate;
    const formFields = getFormFields(basicSettings, namespaces, templates, selectedNamespace, createTemplate);
    return _react.default.createElement(_FormFactory.FormFactory, {
      fields: formFields,
      fieldsValues: basicSettings,
      onFormChange: (newValue, target, formValid) => publish(this.props, newValue, target, formValid, formFields)
    });
  }

}

exports.BasicSettingsTab = BasicSettingsTab;
BasicSettingsTab.defaultProps = {
  selectedNamespace: undefined,
  createTemplate: false
};
BasicSettingsTab.propTypes = {
  templates: _propTypes.default.array.isRequired,
  namespaces: _propTypes.default.array.isRequired,
  selectedNamespace: _propTypes.default.object,
  // used only in initialization
  basicSettings: _propTypes.default.object.isRequired,
  // eslint-disable-next-line react/no-unused-prop-types
  onChange: _propTypes.default.func.isRequired,
  createTemplate: _propTypes.default.bool
};