"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTab = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _Loading = require("../../Loading");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getCreationText = createTemplate => `Creation of VM ${createTemplate ? 'Template ' : ''}`;

const ResultTab = ({
  result,
  success,
  createTemplate
}) => {
  let value;
  const loadingText = `${getCreationText(createTemplate)}in progress`;
  const successText = `${getCreationText(createTemplate)}was successful`;

  if (success == null) {
    value = _react.default.createElement(_Loading.Loading, {
      text: loadingText
    });
  } else if (success) {
    value = _react.default.createElement("div", {
      className: "wizard-pf-complete blank-slate-pf",
      key: "success"
    }, _react.default.createElement("div", {
      className: "wizard-pf-success-icon"
    }, _react.default.createElement("span", {
      className: "glyphicon glyphicon-ok-circle"
    })), _react.default.createElement("h3", {
      className: "blank-slate-pf-main-action"
    }, successText), _react.default.createElement("pre", {
      className: "blank-slate-pf-secondary-action kubevirt-create-vm-wizard__result-success"
    }, result));
  } else {
    value = _react.default.createElement(_patternflyReact.Alert, {
      key: "fail"
    }, result);
  }

  return value;
};

exports.ResultTab = ResultTab;
ResultTab.defaultProps = {
  result: null,
  success: null,
  createTemplate: false
};
ResultTab.propTypes = {
  result: _propTypes.default.string,
  success: _propTypes.default.bool,
  createTemplate: _propTypes.default.bool
};