"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.containerTemplate = void 0;
const containerTemplate = {
  apiVersion: 'template.openshift.io/v1',
  kind: 'Template',
  metadata: {
    labels: {
      'flavor.template.cnv.io/small': 'true',
      'os.template.cnv.io/fedora29': 'true',
      'template.cnv.io/type': 'vm',
      'template.cnv.ui': 'default_fedora-generic',
      'workload.template.cnv.io/generic': 'true'
    },
    annotations: {
      'name.os.template.cnv.io/fedora29': 'Fedora 29'
    },
    name: 'container-template',
    namespace: 'myproject'
  },
  objects: [{
    apiVersion: 'kubevirt.io/v1alpha3',
    kind: 'VirtualMachine',
    metadata: {
      // eslint-disable-next-line no-template-curly-in-string
      name: '${NAME}'
    },
    spec: {
      template: {
        spec: {
          domain: {
            cpu: {
              cores: 2
            },
            devices: {
              disks: [{
                bootOrder: 1,
                disk: {
                  bus: 'virtio'
                },
                name: 'rootdisk'
              }],
              interfaces: [{
                bridge: {},
                name: 'eth0'
              }],
              rng: {}
            },
            resources: {
              requests: {
                memory: '2G'
              }
            }
          },
          networks: [{
            name: 'eth0',
            pod: {}
          }],
          terminationGracePeriodSeconds: 0,
          volumes: [{
            name: 'rootdisk',
            containerDisk: {
              image: 'fooContainer'
            }
          }]
        }
      }
    }
  }],
  parameters: [{
    description: 'Name for the new VM',
    name: 'NAME'
  }]
};
exports.containerTemplate = containerTemplate;