"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlNoNetworkTemplate = void 0;
const urlNoNetworkTemplate = {
  apiVersion: 'template.openshift.io/v1',
  kind: 'Template',
  metadata: {
    labels: {
      'flavor.template.cnv.io/small': 'true',
      'os.template.cnv.io/fedora29': 'true',
      'template.cnv.io/type': 'vm',
      'template.cnv.ui': 'default_fedora-generic',
      'workload.template.cnv.io/generic': 'true'
    },
    annotations: {
      'name.os.template.cnv.io/fedora29': 'Fedora 29'
    },
    name: 'url-template-nonetwork',
    namespace: 'myproject'
  },
  objects: [{
    apiVersion: 'kubevirt.io/v1alpha3',
    kind: 'VirtualMachine',
    metadata: {
      // eslint-disable-next-line no-template-curly-in-string
      name: '${NAME}'
    },
    spec: {
      dataVolumeTemplates: [{
        metadata: {
          // eslint-disable-next-line no-template-curly-in-string
          name: 'rootdisk-${NAME}'
        },
        spec: {
          pvc: {
            accessModes: ['ReadWriteOnce'],
            resources: {
              requests: {
                storage: '10Gi'
              }
            }
          },
          source: {
            http: {
              url: 'fooUrl'
            }
          }
        }
      }],
      template: {
        spec: {
          domain: {
            cpu: {
              cores: 2
            },
            devices: {
              autoattachPodInterface: false,
              disks: [{
                bootOrder: 1,
                disk: {
                  bus: 'virtio'
                },
                name: 'rootdisk'
              }],
              rng: {}
            },
            resources: {
              requests: {
                memory: '2G'
              }
            }
          },
          terminationGracePeriodSeconds: 0,
          volumes: [{
            dataVolume: {
              // eslint-disable-next-line no-template-curly-in-string
              name: 'rootdisk-${NAME}'
            },
            name: 'rootdisk'
          }]
        }
      }
    }
  }],
  parameters: [{
    description: 'Name for the new VM',
    name: 'NAME'
  }]
};
exports.urlNoNetworkTemplate = urlNoNetworkTemplate;