"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelApi = exports.selectVm = exports.getTemplateAnnotations = exports.isFlavorType = exports.isImageSourceType = exports.getTemplateWorkloadProfiles = exports.getTemplateOperatingSystems = exports.getTemplateFlavors = exports.getFlavors = exports.getFlavorLabel = exports.getWorkloadProfiles = exports.getOperatingSystems = exports.getOsLabel = exports.getWorkloadLabel = exports.getLabel = exports.settingsValue = void 0;

var _lodash = require("lodash");

var _templates = require("../utils/templates");

var _models = require("../models");

var _constants = require("../constants");

var _constants2 = require("../components/Wizard/CreateVmWizard/constants");

const settingsValue = (basicSettings, key, defaultValue) => (0, _lodash.get)(basicSettings, [key, 'value'], defaultValue);

exports.settingsValue = settingsValue;

const getLabel = (basicSettings, labelPrefix, value) => {
  const val = settingsValue(basicSettings, value);

  if (val == null) {
    return undefined;
  }

  const isObject = typeof val === 'object';
  return `${labelPrefix}/${isObject ? val.id : val}`;
};

exports.getLabel = getLabel;

const getWorkloadLabel = basicSettings => getLabel(basicSettings, _constants.TEMPLATE_WORKLOAD_LABEL, _constants2.WORKLOAD_PROFILE_KEY);

exports.getWorkloadLabel = getWorkloadLabel;

const getOsLabel = basicSettings => getLabel(basicSettings, _constants.TEMPLATE_OS_LABEL, _constants2.OPERATING_SYSTEM_KEY);

exports.getOsLabel = getOsLabel;

const getOperatingSystems = (basicSettings, templates, userTemplate) => {
  let templatesWithLabels;

  if (userTemplate) {
    templatesWithLabels = [(0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_VM).find(t => t.metadata.name === userTemplate)];
  } else {
    templatesWithLabels = (0, _templates.getTemplatesWithLabels)((0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_BASE), [getWorkloadLabel(basicSettings), getFlavorLabel(basicSettings)]);
  }

  return getTemplateOperatingSystems(templatesWithLabels);
};

exports.getOperatingSystems = getOperatingSystems;

const getWorkloadProfiles = (basicSettings, templates, userTemplate) => {
  let templatesWithLabels;

  if (userTemplate) {
    templatesWithLabels = [(0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_VM).find(t => t.metadata.name === userTemplate)];
  } else {
    templatesWithLabels = (0, _templates.getTemplatesWithLabels)((0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_BASE), [getOsLabel(basicSettings), getFlavorLabel(basicSettings)]);
  }

  return getTemplateWorkloadProfiles(templatesWithLabels);
};

exports.getWorkloadProfiles = getWorkloadProfiles;

const getFlavorLabel = basicSettings => {
  if ((0, _lodash.has)(basicSettings, [_constants2.FLAVOR_KEY, 'value'])) {
    const flavorValue = basicSettings.flavor.value;

    if (flavorValue !== _constants.CUSTOM_FLAVOR) {
      return `${_constants.TEMPLATE_FLAVOR_LABEL}/${basicSettings.flavor.value}`;
    }
  }

  return undefined;
};

exports.getFlavorLabel = getFlavorLabel;

const getFlavors = (basicSettings, templates, userTemplate) => {
  let templatesWithLabels;

  if (userTemplate) {
    templatesWithLabels = [(0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_VM).find(t => t.metadata.name === userTemplate)];
  } else {
    templatesWithLabels = (0, _templates.getTemplatesWithLabels)((0, _templates.getTemplate)(templates, _constants.TEMPLATE_TYPE_BASE), [getWorkloadLabel(basicSettings), getOsLabel(basicSettings)]);
  }

  const flavors = getTemplateFlavors(templatesWithLabels);

  if (!flavors.some(flavor => flavor === _constants.CUSTOM_FLAVOR)) {
    flavors.push(_constants.CUSTOM_FLAVOR);
  }

  return flavors;
};

exports.getFlavors = getFlavors;

const getTemplateFlavors = templates => (0, _templates.getTemplatesLabelValues)(templates, _constants.TEMPLATE_FLAVOR_LABEL);

exports.getTemplateFlavors = getTemplateFlavors;

const getTemplateOperatingSystems = templates => {
  const osIds = (0, _templates.getTemplatesLabelValues)(templates, _constants.TEMPLATE_OS_LABEL);
  return osIds.map(osId => {
    const nameAnnotation = `${_constants.TEMPLATE_OS_NAME_ANNOTATION}/${osId}`;
    const template = templates.find(t => Object.keys(t.metadata.annotations || []).find(annotation => annotation === nameAnnotation));
    return {
      id: osId,
      name: (0, _lodash.get)(template, ['metadata', 'annotations', nameAnnotation])
    };
  });
};

exports.getTemplateOperatingSystems = getTemplateOperatingSystems;

const getTemplateWorkloadProfiles = templates => (0, _templates.getTemplatesLabelValues)(templates, _constants.TEMPLATE_WORKLOAD_LABEL);

exports.getTemplateWorkloadProfiles = getTemplateWorkloadProfiles;

const isImageSourceType = (basicSettings, type) => settingsValue(basicSettings, _constants2.PROVISION_SOURCE_TYPE_KEY) === type;

exports.isImageSourceType = isImageSourceType;

const isFlavorType = (basicSettings, type) => settingsValue(basicSettings, _constants2.FLAVOR_KEY) === type;

exports.isFlavorType = isFlavorType;

const getTemplateAnnotations = (template, name) => (0, _lodash.get)(template.metadata.annotations, [name]);

exports.getTemplateAnnotations = getTemplateAnnotations;

const selectVm = objects => objects.find(obj => obj.kind === _models.VirtualMachineModel.kind);

exports.selectVm = selectVm;

const getModelApi = model => `${model.apiGroup}/${model.apiVersion}`;

exports.getModelApi = getModelApi;