"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVmiIpAddresses = exports.getHostName = exports.getNodeName = exports.isWindows = exports.getAnnotationValue = exports.getLabelValue = exports.getCloudInitUserData = exports.getCloudInitVolume = exports.getDescription = exports.getVmTemplate = exports.getFlavor = exports.getWorkloadProfile = exports.getOperatingSystemName = exports.getOperatingSystem = exports.getCpu = exports.getMemory = exports.getDataVolumes = exports.getVolumes = exports.getNetworks = exports.getInterfaces = exports.getDisks = exports.getDataVolumeStorageClassName = exports.getPvcStorageClassName = exports.getDataVolumeResources = exports.getPvcResources = exports.getGibStorageSize = exports.getNamespace = exports.getName = exports.getId = void 0;

var _lodash = require("lodash");

var _constants = require("../constants");

const getId = value => `${getNamespace()}/${getName()}`;

exports.getId = getId;

const getName = value => (0, _lodash.get)(value, 'metadata.name');

exports.getName = getName;

const getNamespace = value => (0, _lodash.get)(value, 'metadata.namespace');

exports.getNamespace = getNamespace;

const getGibStorageSize = (units, resources) => {
  const size = (0, _lodash.get)(resources, 'requests.storage');
  return size ? units.dehumanize(size, 'binaryBytesWithoutB').value / 1073741824 : null; // 1024^3
};

exports.getGibStorageSize = getGibStorageSize;

const getPvcResources = pvc => (0, _lodash.get)(pvc, 'spec.resources');

exports.getPvcResources = getPvcResources;

const getDataVolumeResources = dataVolume => (0, _lodash.get)(dataVolume, 'spec.pvc.resources');

exports.getDataVolumeResources = getDataVolumeResources;

const getPvcStorageClassName = pvc => (0, _lodash.get)(pvc, 'spec.storageClassName');

exports.getPvcStorageClassName = getPvcStorageClassName;

const getDataVolumeStorageClassName = dataVolume => (0, _lodash.get)(dataVolume, 'spec.pvc.storageClassName');

exports.getDataVolumeStorageClassName = getDataVolumeStorageClassName;

const getDisks = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.devices.disks', []);

exports.getDisks = getDisks;

const getInterfaces = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.devices.interfaces', []);

exports.getInterfaces = getInterfaces;

const getNetworks = vm => (0, _lodash.get)(vm, 'spec.template.spec.networks', []);

exports.getNetworks = getNetworks;

const getVolumes = vm => (0, _lodash.get)(vm, 'spec.template.spec.volumes', []);

exports.getVolumes = getVolumes;

const getDataVolumes = vm => (0, _lodash.get)(vm, 'spec.dataVolumeTemplates', []);

exports.getDataVolumes = getDataVolumes;

const getMemory = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.resources.requests.memory');

exports.getMemory = getMemory;

const getCpu = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.cpu.cores');

exports.getCpu = getCpu;

const getOperatingSystem = vm => getLabelValue(vm, _constants.TEMPLATE_OS_LABEL);

exports.getOperatingSystem = getOperatingSystem;

const getOperatingSystemName = vm => getAnnotationValue(vm, `${_constants.TEMPLATE_OS_NAME_ANNOTATION}/${getOperatingSystem(vm)}`);

exports.getOperatingSystemName = getOperatingSystemName;

const getWorkloadProfile = vm => getLabelValue(vm, _constants.TEMPLATE_WORKLOAD_LABEL);

exports.getWorkloadProfile = getWorkloadProfile;

const getFlavor = vm => getLabelValue(vm, _constants.TEMPLATE_FLAVOR_LABEL);

exports.getFlavor = getFlavor;

const getVmTemplate = vm => {
  const vmTemplate = getLabelValue(vm, _constants.ANNOTATION_USED_TEMPLATE);

  if (vmTemplate) {
    const templateParts = vmTemplate.split('_');
    return {
      name: templateParts[1],
      namespace: templateParts[0]
    };
  }

  return null;
};

exports.getVmTemplate = getVmTemplate;

const getDescription = vm => (0, _lodash.get)(vm, 'metadata.annotations.description');

exports.getDescription = getDescription;

const getCloudInitVolume = vm => {
  const volumes = getVolumes(vm);
  const cloudInitVolume = volumes.find(volume => volume.cloudInitNoCloud && volume.cloudInitNoCloud.userData);

  if (cloudInitVolume) {
    // make sure volume is used by disk
    const disks = getDisks(vm);

    if (disks.find(disk => disk.name === cloudInitVolume.name)) {
      return cloudInitVolume;
    }
  }

  return null;
};

exports.getCloudInitVolume = getCloudInitVolume;

const getCloudInitUserData = vm => {
  const volume = getCloudInitVolume(vm);
  return volume && volume.cloudInitNoCloud.userData;
};

exports.getCloudInitUserData = getCloudInitUserData;

const getLabelValue = (vm, label) => {
  const labels = (0, _lodash.get)(vm, 'metadata.labels', {});
  return readValueFromObject(labels, label, true);
};

exports.getLabelValue = getLabelValue;

const getAnnotationValue = (vm, annotation) => {
  const annotations = (0, _lodash.get)(vm, 'metadata.annotations', {});
  return readValueFromObject(annotations, annotation, false);
};

exports.getAnnotationValue = getAnnotationValue;

const readValueFromObject = (objects, key, split) => {
  if (objects) {
    const objectKey = Object.keys(objects).find(objKey => objKey.startsWith(key));

    if (!objectKey) {
      return null;
    }

    if (split && objectKey.includes('/')) {
      const objectParts = objectKey.split('/');
      return objectParts[objectParts.length - 1];
    }

    return objects[objectKey];
  }

  return null;
};

const isWindows = vm => (getOperatingSystem(vm) || '').startsWith(_constants.OS_WINDOWS_PREFIX);

exports.isWindows = isWindows;

const getNodeName = pod => (0, _lodash.get)(pod, 'spec.nodeName');

exports.getNodeName = getNodeName;

const getHostName = pod => (0, _lodash.get)(pod, 'spec.hostname');

exports.getHostName = getHostName;

const getVmiIpAddresses = vmi => (0, _lodash.get)(vmi, 'status.interfaces', []).map(i => i.ipAddress).filter(ip => ip && ip.trim().length > 0);

exports.getVmiIpAddresses = getVmiIpAddresses;