"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDiskRow = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _CreateDeviceRow = require("../CreateDeviceRow");

var _selectors = require("../../utils/selectors");

var _validations = require("../../utils/validations");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const columnSizes = {
  lg: 3,
  md: 3,
  sm: 3,
  xs: 3
};

const getDiskColumns = (storage, storageClasses, LoadingComponent) => {
  let storageClass;

  if (storageClasses) {
    storageClass = {
      id: 'disk-storage-class',
      type: 'dropdown',
      defaultValue: storageClasses.length === 0 ? '--- No Storage Class Available ---' : '--- Select Storage Class ---',
      choices: storageClasses.map(sc => (0, _selectors.getName)(sc)),
      disabled: storage.creating || storageClasses.length === 0
    };
  } else {
    storageClass = {
      id: 'disk-storage-class-loading',
      type: 'loading',
      LoadingComponent
    };
  }

  return {
    name: {
      id: 'disk-name',
      validate: _validations.validateDNS1123SubdomainValue,
      required: true,
      title: 'Name',
      disabled: storage.creating
    },
    size: {
      id: 'disk-size',
      type: 'positive-number',
      required: true,
      title: 'Size',
      disabled: storage.creating
    },
    bus: {
      id: 'disk-bus',
      type: 'label'
    },
    storageClass
  };
};

const CreateDiskRow = ({
  storage,
  onAccept,
  onChange,
  onCancel,
  storageClasses,
  LoadingComponent
}) => _react.default.createElement(_CreateDeviceRow.CreateDeviceRow, {
  onAccept: onAccept,
  onCancel: onCancel,
  onChange: onChange,
  LoadingComponent: LoadingComponent,
  device: storage,
  columnSizes: columnSizes,
  deviceFields: getDiskColumns(storage, storageClasses, LoadingComponent)
});

exports.CreateDiskRow = CreateDiskRow;
CreateDiskRow.propTypes = {
  storage: _propTypes.default.object.isRequired,
  onChange: _propTypes.default.func.isRequired,
  onAccept: _propTypes.default.func.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  storageClasses: _propTypes.default.array,
  LoadingComponent: _propTypes.default.func.isRequired
};
CreateDiskRow.defaultProps = {
  storageClasses: undefined
};