"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../../utils");

var _InlineEdit = require("../../InlineEdit");

var _Loading = require("../../Loading");

var _constants = require("../../../constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const descriptionFormFields = {
  description: {
    id: 'description-textarea',
    type: 'textarea'
  }
};

const Description = ({
  formValues,
  vm,
  editing,
  updating,
  LoadingComponent,
  onFormChange
}) => {
  if (!(formValues && formValues.description)) {
    onFormChange({
      value: (0, _utils.getDescription)(vm)
    }, 'description', true);
  }

  return _react.default.createElement(_InlineEdit.InlineEdit, {
    formFields: descriptionFormFields,
    fieldsValues: formValues,
    editing: editing,
    updating: updating,
    LoadingComponent: LoadingComponent,
    onFormChange: onFormChange
  }, (0, _utils.getDescription)(vm) || _constants.DASHES);
};

exports.Description = Description;
Description.propTypes = {
  formValues: _propTypes.default.object,
  vm: _propTypes.default.object.isRequired,
  editing: _propTypes.default.bool,
  updating: _propTypes.default.bool,
  LoadingComponent: _propTypes.default.func,
  onFormChange: _propTypes.default.func
};
Description.defaultProps = {
  formValues: undefined,
  editing: false,
  updating: false,
  LoadingComponent: _Loading.Loading,
  onFormChange: () => {}
};