"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VmDetails = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _patternflyReact = require("patternfly-react");

var _VmStatus = require("../../VmStatus");

var _utils = require("../../../utils");

var _models = require("../../../models");

var _constants = require("../../../constants");

var _selectors = require("../../../k8s/selectors");

var _Flavor = require("../Flavor");

var _Description = require("../Description");

var _Loading = require("../../Loading");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class VmDetails extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "setEditing", editing => this.setState({
      editing
    }));

    _defineProperty(this, "onFormChange", (formKey, newValue, key, valid) => this.setState(state => ({
      form: _objectSpread({}, state.form, {
        [formKey]: {
          value: _objectSpread({}, (0, _lodash.get)(state.form[formKey], 'value') || {}, {
            [key]: newValue
          }),
          valid
        }
      })
    })));

    _defineProperty(this, "onLoadError", error => this.setState({
      k8sError: error
    }));

    _defineProperty(this, "updateVmDetails", () => {
      this.setEditing(false);
      const vmPatch = [];
      const descriptionForm = (0, _lodash.get)(this.state.form.description, 'value');
      const flavorForm = (0, _lodash.get)(this.state.form.flavor, 'value');
      const descriptionPatch = (0, _utils.getUpdateDescriptionPatch)(this.props.vm, (0, _selectors.settingsValue)(descriptionForm, 'description'));
      vmPatch.push(...descriptionPatch);
      const flavor = (0, _selectors.settingsValue)(flavorForm, 'flavor');
      let cpu;
      let memory;

      if (flavor !== _constants.CUSTOM_FLAVOR && flavorForm.template) {
        const templateVm = (0, _selectors.selectVm)(flavorForm.template.objects);
        cpu = (0, _utils.getCpu)(templateVm);
        memory = (0, _utils.getMemory)(templateVm);
      } else {
        cpu = (0, _selectors.settingsValue)(flavorForm, 'cpu');
        memory = `${(0, _selectors.settingsValue)(flavorForm, 'memory')}G`;
      }

      if (flavor && cpu && memory) {
        const flavorPatch = (0, _utils.getUpdateFlavorPatch)(this.props.vm, flavor, cpu, memory);
        vmPatch.push(...flavorPatch);
      }

      if (vmPatch.length > 0) {
        this.setState({
          updating: true,
          k8sError: null
        });
        const updatePromise = this.props.k8sPatch(_models.VirtualMachineModel, this.props.vm, vmPatch);
        updatePromise.then(() => this.setState({
          updating: false
        })).catch(error => this.setState({
          updating: false,
          k8sError: error.message || 'An error occurred. Please try again.'
        }));
      }
    });

    _defineProperty(this, "onErrorDismiss", () => this.setState({
      k8sError: null
    }));

    _defineProperty(this, "isFormValid", () => Object.keys(this.state.form).every(key => this.state.form[key].valid));

    _defineProperty(this, "isVmOff", (vm, launcherPod, importerPods, migration) => {
      const statusDetail = (0, _VmStatus.getVmStatusDetail)(vm, launcherPod, importerPods, migration);
      return statusDetail.status === _constants.VM_STATUS_OFF;
    });

    this.state = {
      editing: false,
      updating: false,
      k8sError: null,
      form: {}
    };
  }

  componentDidUpdate() {
    const _this$props = this.props,
          launcherPod = _this$props.launcherPod,
          importerPods = _this$props.importerPods,
          migration = _this$props.migration,
          vm = _this$props.vm;

    if (this.state.editing && !this.isVmOff(vm, launcherPod, importerPods, migration)) {
      this.setEditing(false);
    }
  }

  render() {
    const _this$props2 = this.props,
          launcherPod = _this$props2.launcherPod,
          importerPods = _this$props2.importerPods,
          migration = _this$props2.migration,
          NodeLink = _this$props2.NodeLink,
          vm = _this$props2.vm,
          vmi = _this$props2.vmi,
          PodResourceLink = _this$props2.PodResourceLink,
          NamespaceResourceLink = _this$props2.NamespaceResourceLink,
          LoadingComponent = _this$props2.LoadingComponent,
          k8sGet = _this$props2.k8sGet;
    const vmIsOff = this.isVmOff(vm, launcherPod, importerPods, migration);
    const nodeName = (0, _utils.getNodeName)(launcherPod);
    const ipAddresses = vmIsOff ? [] : (0, _utils.getVmiIpAddresses)(vmi);
    const hostName = (0, _utils.getHostName)(launcherPod);
    const fqdn = vmIsOff || !hostName ? _constants.DASHES : hostName;
    const template = (0, _utils.getVmTemplate)(vm);

    const editButton = _react.default.createElement(_react.Fragment, null, !vmIsOff && _react.default.createElement("div", {
      className: "kubevirt-vm-details__edit-info"
    }, _react.default.createElement(_patternflyReact.FieldLevelHelp, {
      placement: "top",
      content: "Please turn off the VM before editing"
    })), _react.default.createElement(_patternflyReact.Button, {
      disabled: this.state.updating || !vmIsOff,
      onClick: () => this.setEditing(true)
    }, "Edit"));

    const cancelSaveButton = _react.default.createElement(_react.Fragment, null, _react.default.createElement(_patternflyReact.Button, {
      onClick: () => this.setEditing(false)
    }, "Cancel"), _react.default.createElement(_patternflyReact.Button, {
      bsStyle: "primary",
      disabled: !this.isFormValid(),
      onClick: this.updateVmDetails
    }, "Save"));

    return _react.default.createElement("div", {
      className: "co-m-pane__body"
    }, _react.default.createElement("h1", {
      className: "co-m-pane__heading"
    }, "Virtual Machine Overview", _react.default.createElement("div", null, this.state.editing ? cancelSaveButton : editButton)), this.state.k8sError && _react.default.createElement(_patternflyReact.Alert, {
      onDismiss: this.onErrorDismiss
    }, this.state.k8sError), _react.default.createElement(_patternflyReact.Row, null, _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "name-description-column"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Name"), _react.default.createElement("dd", null, vm.metadata.name), _react.default.createElement("dt", null, "Description"), _react.default.createElement("dd", null, _react.default.createElement("div", {
      className: "kubevirt-vm-details__description"
    }, _react.default.createElement(_Description.Description, {
      editing: this.state.editing,
      updating: this.state.updating,
      LoadingComponent: LoadingComponent,
      formValues: (0, _lodash.get)(this.state.form.description, 'value'),
      onFormChange: (newValue, key, valid) => this.onFormChange('description', newValue, key, valid),
      vm: vm
    }))))), _react.default.createElement(_patternflyReact.Col, {
      lg: 8,
      md: 8,
      sm: 8,
      xs: 8,
      id: "details-column"
    }, _react.default.createElement(_patternflyReact.Row, null, _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "details-column-1"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Status"), _react.default.createElement("dd", null, _react.default.createElement(_VmStatus.VmStatuses, {
      vm: this.props.vm,
      launcherPod: launcherPod,
      importerPods: importerPods,
      migration: migration
    })), _react.default.createElement("dt", null, "Operating System"), _react.default.createElement("dd", null, (0, _utils.getOperatingSystemName)(vm) || (0, _utils.getOperatingSystem)(vm) || _constants.DASHES), _react.default.createElement("dt", null, "IP Addresses"), _react.default.createElement("dd", null, ipAddresses.length > 0 ? ipAddresses.join(', ') : _constants.DASHES), _react.default.createElement("dt", null, "Workload Profile"), _react.default.createElement("dd", null, (0, _utils.getWorkloadProfile)(vm) || _constants.DASHES), _react.default.createElement("dt", null, "Template"), _react.default.createElement("dd", null, template ? `${template.namespace}/${template.name}` : _constants.DASHES))), _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "details-column-2"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "FQDN"), _react.default.createElement("dd", null, fqdn), _react.default.createElement("dt", null, "Namespace"), _react.default.createElement("dd", null, NamespaceResourceLink ? _react.default.createElement(NamespaceResourceLink, null) : _constants.DASHES), _react.default.createElement("dt", null, "Pod"), _react.default.createElement("dd", null, PodResourceLink ? _react.default.createElement(PodResourceLink, null) : _constants.DASHES))), _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "details-column-3"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Node"), _react.default.createElement("dd", null, nodeName && NodeLink ? _react.default.createElement(NodeLink, {
      name: nodeName
    }) : _constants.DASHES), _react.default.createElement("dt", null, "Flavor"), _react.default.createElement("dd", null, _react.default.createElement(_Flavor.Flavor, {
      vm: vm,
      editing: this.state.editing,
      updating: this.state.updating,
      LoadingComponent: LoadingComponent,
      onFormChange: (newValue, key, valid) => this.onFormChange('flavor', newValue, key, valid),
      k8sGet: k8sGet,
      formValues: (0, _lodash.get)(this.state.form.flavor, 'value'),
      onLoadError: this.onLoadError
    }))))))));
  }

}

exports.VmDetails = VmDetails;
VmDetails.propTypes = {
  vm: _propTypes.default.object.isRequired,
  vmi: _propTypes.default.object,
  launcherPod: _propTypes.default.object,
  importerPods: _propTypes.default.array,
  migration: _propTypes.default.object,
  NodeLink: _propTypes.default.func,
  NamespaceResourceLink: _propTypes.default.func,
  PodResourceLink: _propTypes.default.func,
  k8sPatch: _propTypes.default.func.isRequired,
  k8sGet: _propTypes.default.func.isRequired,
  LoadingComponent: _propTypes.default.func
};
VmDetails.defaultProps = {
  vmi: undefined,
  launcherPod: undefined,
  importerPods: undefined,
  migration: undefined,
  NamespaceResourceLink: undefined,
  PodResourceLink: undefined,
  LoadingComponent: _Loading.Loading,
  NodeLink: undefined
};