"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VmStatus = exports.VmStatuses = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRouterDom = require("react-router-dom");

var _constants = require("../../constants");

var _utils = require("../../utils");

var _models = require("../../models");

var _getVmStatus = require("./getVmStatus");

var _selectors = require("../../utils/selectors");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const getAdditionalImportText = pod => ` (${pod.metadata.labels[`${_constants.CDI_KUBEVIRT_IO}/${_constants.STORAGE_IMPORT_PVC_NAME}`]})`;

const StateValue = ({
  iconClass,
  children,
  linkTo,
  message
}) => _react.default.createElement(_react.Fragment, null, _react.default.createElement("span", {
  className: `kubevirt-vm-status__icon ${iconClass}`,
  "aria-hidden": "true"
}), linkTo ? _react.default.createElement(_reactRouterDom.Link, {
  to: linkTo,
  title: message
}, children) : children);

StateValue.propTypes = {
  children: _propTypes.default.any,
  iconClass: _propTypes.default.string.isRequired,
  linkTo: _propTypes.default.string,
  message: _propTypes.default.string
};
StateValue.defaultProps = {
  children: null,
  linkTo: undefined,
  message: undefined
};

const StateRunning = (_ref) => {
  let props = _extends({}, _ref);

  return _react.default.createElement(StateValue, _extends({
    iconClass: "pficon pficon-on-running"
  }, props), "Running");
};

const StateOff = () => _react.default.createElement(StateValue, {
  iconClass: "pficon pficon-off"
}, "Off");

const StateUnknown = () => _react.default.createElement(StateValue, {
  iconClass: "pficon pficon-unknown"
}, "Unknown");

const StateMigrating = () => _react.default.createElement(StateValue, {
  iconClass: "pficon pficon-migration"
}, "Migrating");

const StateVmiWaiting = (_ref2) => {
  let props = _extends({}, _ref2);

  return _react.default.createElement(StateValue, _extends({
    iconClass: "pficon pficon-pending"
  }, props), "Pending");
};

const StateStarting = (_ref3) => {
  let props = _extends({}, _ref3);

  return _react.default.createElement(StateValue, _extends({
    iconClass: "pficon pficon-pending"
  }, props), "Starting");
};

const StateImporting = (_ref4) => {
  let additionalText = _ref4.additionalText,
      props = _objectWithoutProperties(_ref4, ["additionalText"]);

  return _react.default.createElement(StateValue, _extends({
    iconClass: "pficon pficon-import"
  }, props), "Importing", additionalText);
};

const StateError = (_ref5) => {
  let children = _ref5.children,
      props = _objectWithoutProperties(_ref5, ["children"]);

  return _react.default.createElement(StateValue, _extends({
    iconClass: "pficon pficon-error-circle-o"
  }, props), children);
};

const VmStatuses = props => {
  const vm = props.vm,
        launcherPod = props.launcherPod,
        importerPods = props.importerPods,
        migration = props.migration;
  const statusDetail = (0, _getVmStatus.getVmStatusDetail)(vm, launcherPod, importerPods, migration);

  if (importerPods && importerPods.length > 1) {
    switch (statusDetail.status) {
      case _constants.VM_STATUS_IMPORTING:
      case _constants.VM_STATUS_IMPORT_ERROR:
        return _react.default.createElement(_react.default.Fragment, null, importerPods.map(pod => _react.default.createElement("div", {
          key: (0, _selectors.getId)(pod)
        }, _react.default.createElement(VmStatus, _extends({}, props, {
          importerPods: [pod],
          verbose: true
        })))));

      default:
    }
  }

  return _react.default.createElement("div", {
    key: importerPods && importerPods.length > 0 ? (0, _selectors.getId)(importerPods[0]) : '6d0c77-has-no-importer-pods'
  }, _react.default.createElement(VmStatus, props));
};

exports.VmStatuses = VmStatuses;
VmStatuses.defaultProps = {
  launcherPod: undefined,
  importerPods: undefined,
  migration: undefined
};
VmStatuses.propTypes = {
  vm: _propTypes.default.object.isRequired,
  launcherPod: _propTypes.default.object,
  importerPods: _propTypes.default.array,
  migration: _propTypes.default.object
};

const VmStatus = ({
  vm,
  launcherPod,
  importerPods,
  migration,
  verbose
}) => {
  const statusDetail = (0, _getVmStatus.getVmStatusDetail)(vm, launcherPod, importerPods, migration);

  switch (statusDetail.status) {
    case _constants.VM_STATUS_OFF:
      return _react.default.createElement(StateOff, null);

    case _constants.VM_STATUS_RUNNING:
      return _react.default.createElement(StateRunning, {
        linkTo: (0, _utils.getSubPagePath)(launcherPod, _models.PodModel)
      });

    case _constants.VM_STATUS_VMI_WAITING:
      return _react.default.createElement(StateVmiWaiting, {
        linkTo: (0, _utils.getSubPagePath)(vm, _models.VirtualMachineModel, 'events')
      });

    case _constants.VM_STATUS_STARTING:
      return _react.default.createElement(StateStarting, {
        linkTo: (0, _utils.getSubPagePath)(launcherPod, _models.PodModel, 'events'),
        message: statusDetail.message
      });

    case _constants.VM_STATUS_IMPORTING:
      return _react.default.createElement(StateImporting, {
        linkTo: (0, _utils.getSubPagePath)(statusDetail.pod, _models.PodModel, 'events'),
        additionalText: verbose ? getAdditionalImportText(statusDetail.pod) : ''
      });

    case _constants.VM_STATUS_MIGRATING:
      return _react.default.createElement(StateMigrating, null);
    // TODO: add linkTo once migration monitoring page is available

    case _constants.VM_STATUS_POD_ERROR:
      return _react.default.createElement(StateError, {
        linkTo: (0, _utils.getSubPagePath)(launcherPod, _models.PodModel, 'events'),
        message: statusDetail.message
      }, "Pod Error");

    case _constants.VM_STATUS_IMPORT_ERROR:
      return _react.default.createElement(StateError, {
        linkTo: (0, _utils.getSubPagePath)(statusDetail.pod, _models.PodModel, 'events'),
        message: statusDetail.message
      }, "Importer Error", verbose ? getAdditionalImportText(statusDetail.pod) : '');

    case _constants.VM_STATUS_ERROR:
      return _react.default.createElement(StateError, {
        linkTo: (0, _utils.getSubPagePath)(vm, _models.VirtualMachineModel, 'events'),
        message: statusDetail.message
      }, "VM Error");

    default:
      return _react.default.createElement(StateUnknown, null);
    // Let's hope this state is tentative and will fit former conditions soon
  }
};

exports.VmStatus = VmStatus;
VmStatus.defaultProps = {
  launcherPod: undefined,
  importerPods: undefined,
  migration: undefined
};
VmStatus.propTypes = {
  vm: _propTypes.default.object.isRequired,
  launcherPod: _propTypes.default.object,
  importerPods: _propTypes.default.array,
  migration: _propTypes.default.object
};