"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateVmWizard = exports.rootDataVolumeDisk = exports.rootContainerDisk = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _patternflyReact = require("patternfly-react");

var _BasicSettingsTab = require("./BasicSettingsTab");

var _StorageTab = require("./StorageTab");

var _ResultTab = require("./ResultTab");

var _NetworksTab = require("./NetworksTab");

var _loadingWizardTab = require("../loadingWizardTab");

var _selectors = require("../../../k8s/selectors");

var _request = require("../../../k8s/request");

var _constants = require("../../../constants");

var _constants2 = require("./constants");

var _strings = require("./strings");

var _templates = require("../../../utils/templates");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const LoadingBasicWizardTab = (0, _loadingWizardTab.loadingWizardTab)(_BasicSettingsTab.BasicSettingsTab);
const LoadingStorageTab = (0, _loadingWizardTab.loadingWizardTab)(_StorageTab.StorageTab);
const LoadingNetworksTab = (0, _loadingWizardTab.loadingWizardTab)(_NetworksTab.NetworksTab);

const getBasicSettingsValue = (stepData, key) => (0, _selectors.settingsValue)(stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value, key);

const getInitialDisks = provisionSource => {
  switch (provisionSource) {
    case _constants.PROVISION_SOURCE_URL:
      return rootDataVolumeDisk;

    case _constants.PROVISION_SOURCE_CONTAINER:
      return rootContainerDisk;

    case _constants.PROVISION_SOURCE_PXE:
      return null;

    default:
      // eslint-disable-next-line
      console.warn(`Unknown provision source ${provisionSource}`);
      return null;
  }
};

const onUserTemplateChangedInStorageTab = (stepData, newUserTemplate) => {
  const withoutDiscardedTemplateStorage = stepData[_constants2.STORAGE_TAB_KEY].value.filter(storage => !(storage.templateStorage || storage.rootStorage));

  const rows = [...withoutDiscardedTemplateStorage];

  if (newUserTemplate) {
    const templateStorages = (0, _templates.getTemplateStorages)(newUserTemplate).map(storage => ({
      templateStorage: storage
    }));
    rows.push(...templateStorages);
  } else {
    const basicSettings = stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value;
    const storage = getInitialDisks((0, _selectors.settingsValue)(basicSettings, _constants2.PROVISION_SOURCE_TYPE_KEY));

    if (storage) {
      rows.push(storage);
    }
  }

  return _objectSpread({}, stepData, {
    [_constants2.STORAGE_TAB_KEY]: _objectSpread({}, stepData[_constants2.STORAGE_TAB_KEY], {
      value: rows
    })
  });
};

const onUserTemplateChangedInNetworksTab = (stepData, newUserTemplate) => {
  const withoutDiscardedTemplateNetworks = stepData[_constants2.NETWORKS_TAB_KEY].value.filter(network => !network.templateNetwork);

  const rows = [...withoutDiscardedTemplateNetworks];

  if (!rows.find(row => row.rootNetwork)) {
    rows.push(podNetwork);
  }

  if (newUserTemplate) {
    const templateInterfaces = (0, _templates.getTemplateInterfaces)(newUserTemplate);
    const networks = templateInterfaces.map(i => ({
      templateNetwork: i
    })); // do not add root interface if there already is one or autoAttachPodInterface is set to false

    if (networks.some(network => network.templateNetwork.network.pod) || !(0, _templates.hasAutoAttachPodInterface)(newUserTemplate)) {
      const index = (0, _lodash.findIndex)(rows, network => network.rootNetwork);
      rows.splice(index, 1);
    }

    rows.push(...networks);
  }

  return _objectSpread({}, stepData, {
    [_constants2.NETWORKS_TAB_KEY]: _objectSpread({}, stepData[_constants2.NETWORKS_TAB_KEY], {
      value: rows
    })
  });
};

const rootDisk = {
  rootStorage: {},
  name: 'rootdisk',
  isBootable: true
};

const rootContainerDisk = _objectSpread({}, rootDisk, {
  storageType: _constants2.STORAGE_TYPE_CONTAINER
});

exports.rootContainerDisk = rootContainerDisk;

const rootDataVolumeDisk = _objectSpread({}, rootDisk, {
  storageType: _constants2.STORAGE_TYPE_DATAVOLUME,
  size: 10
});

exports.rootDataVolumeDisk = rootDataVolumeDisk;

const onImageSourceTypeChangedInStorageTab = stepData => {
  const withoutRootStorage = stepData[_constants2.STORAGE_TAB_KEY].value.filter(storage => !storage.rootStorage);

  const rows = [...withoutRootStorage];
  const basicSettings = stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value;

  if (!(0, _selectors.settingsValue)(basicSettings, _constants2.USER_TEMPLATE_KEY)) {
    const storage = getInitialDisks((0, _selectors.settingsValue)(basicSettings, _constants2.PROVISION_SOURCE_TYPE_KEY));

    if (storage) {
      rows.push(storage);
    }
  }

  return _objectSpread({}, stepData, {
    [_constants2.STORAGE_TAB_KEY]: _objectSpread({}, stepData[_constants2.STORAGE_TAB_KEY], {
      value: rows
    })
  });
};

const onUserTemplateChanged = (props, stepData) => {
  const userTemplateName = getBasicSettingsValue(stepData, _constants2.USER_TEMPLATE_KEY);
  const userTemplate = userTemplateName ? (0, _templates.getUserTemplate)(props.templates, userTemplateName) : undefined;
  const newStepData = onUserTemplateChangedInStorageTab(stepData, userTemplate);
  return onUserTemplateChangedInNetworksTab(newStepData, userTemplate);
};

const onImageSourceTypeChanged = (props, stepData) => onImageSourceTypeChangedInStorageTab(stepData);

const podNetwork = {
  rootNetwork: {},
  id: 0,
  name: 'nic0',
  mac: '',
  network: _constants.POD_NETWORK,
  editable: true,
  edit: false,
  networkType: _constants2.NETWORK_TYPE_POD
};

class CreateVmWizard extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      activeStepIndex: 0,
      stepData: {
        [_constants2.BASIC_SETTINGS_TAB_KEY]: {
          // Basic Settings
          value: {},
          valid: false
        },
        [_constants2.NETWORKS_TAB_KEY]: {
          value: [podNetwork],
          valid: true
        },
        [_constants2.STORAGE_TAB_KEY]: {
          value: [],
          // Storages
          valid: true // empty Storages are valid

        },
        [_constants2.RESULT_TAB_KEY]: {
          value: '',
          valid: null // result of the request

        }
      }
    });

    _defineProperty(this, "getLastStepIndex", () => this.wizardStepsNewVM.length - 1);

    _defineProperty(this, "lastStepReached", () => this.state.activeStepIndex === this.getLastStepIndex());

    _defineProperty(this, "callbacks", [{
      field: _constants2.USER_TEMPLATE_KEY,
      callback: onUserTemplateChanged
    }, {
      field: _constants2.PROVISION_SOURCE_TYPE_KEY,
      callback: onImageSourceTypeChanged
    }]);

    _defineProperty(this, "onStepDataChanged", (key, value, valid) => {
      this.setState((state, props) => {
        let stepData = _objectSpread({}, state.stepData);

        stepData[key] = {
          value,
          valid
        };

        if (key === _constants2.BASIC_SETTINGS_TAB_KEY) {
          this.callbacks.forEach(callback => {
            const oldValue = getBasicSettingsValue(state.stepData, callback.field);
            const newValue = getBasicSettingsValue(stepData, callback.field);

            if (oldValue !== newValue) {
              stepData = callback.callback(props, stepData);
            }
          });
        }

        return {
          stepData
        };
      });
    });

    _defineProperty(this, "onStepChanged", newActiveStepIndex => {
      if (!this.lastStepReached() && ( // do not allow going back once last step is reached
      newActiveStepIndex < this.state.activeStepIndex || // allow going back to past steps
      this.state.stepData[this.wizardStepsNewVM[newActiveStepIndex - 1].key].valid)) {
        if (newActiveStepIndex === this.getLastStepIndex()) {
          this.finish();
        }

        this.setState({
          activeStepIndex: newActiveStepIndex
        });
      }
    });

    _defineProperty(this, "wizardStepsNewVM", [{
      title: _strings.STEP_BASIC_SETTINGS,
      key: _constants2.BASIC_SETTINGS_TAB_KEY,
      render: () => {
        const loadingData = {
          namespaces: this.props.namespaces,
          templates: this.props.templates
        };
        return _react.default.createElement(LoadingBasicWizardTab, {
          key: "1",
          selectedNamespace: this.props.selectedNamespace,
          basicSettings: this.state.stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value,
          onChange: (value, valid) => this.onStepDataChanged(_constants2.BASIC_SETTINGS_TAB_KEY, value, valid),
          loadingData: loadingData,
          createTemplate: this.props.createTemplate
        });
      }
    }, {
      title: _strings.STEP_NETWORK,
      key: _constants2.NETWORKS_TAB_KEY,
      render: () => {
        const loadingData = {
          networkConfigs: this.props.networkConfigs
        };
        const sourceType = getBasicSettingsValue(this.state.stepData, _constants2.PROVISION_SOURCE_TYPE_KEY);
        return _react.default.createElement(LoadingNetworksTab, {
          onChange: (value, valid) => this.onStepDataChanged(_constants2.NETWORKS_TAB_KEY, value, valid),
          networkConfigs: this.props.networkConfigs,
          networks: this.state.stepData[_constants2.NETWORKS_TAB_KEY].value || [],
          sourceType: sourceType,
          namespace: this.state.stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value.namespace.value,
          loadingData: loadingData
        });
      }
    }, {
      title: _strings.STEP_STORAGE,
      key: _constants2.STORAGE_TAB_KEY,
      render: () => {
        const loadingData = {
          storageClasses: this.props.storageClasses,
          persistentVolumeClaims: this.props.persistentVolumeClaims
        };
        const sourceType = getBasicSettingsValue(this.state.stepData, _constants2.PROVISION_SOURCE_TYPE_KEY);
        return _react.default.createElement(LoadingStorageTab, {
          initialStorages: this.state.stepData[_constants2.STORAGE_TAB_KEY].value,
          onChange: (value, valid) => this.onStepDataChanged(_constants2.STORAGE_TAB_KEY, value, valid),
          units: this.props.units,
          sourceType: sourceType,
          namespace: this.state.stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value.namespace.value,
          loadingData: loadingData
        });
      }
    }, {
      title: _strings.STEP_RESULT,
      key: _constants2.RESULT_TAB_KEY,
      render: () => {
        const stepData = this.state.stepData[_constants2.RESULT_TAB_KEY];
        return _react.default.createElement(_ResultTab.ResultTab, {
          result: stepData.value,
          success: stepData.valid,
          createTemplate: this.props.createTemplate
        });
      }
    }]);
  }

  finish() {
    const create = this.props.createTemplate ? _request.createVmTemplate : (k8sCreate, templates, basicSettings, networks, storage) => (0, _request.createVm)(k8sCreate, templates, basicSettings, networks, storage, this.props.persistentVolumeClaims);
    create(this.props.k8sCreate, this.props.templates, this.state.stepData[_constants2.BASIC_SETTINGS_TAB_KEY].value, this.state.stepData[_constants2.NETWORKS_TAB_KEY].value, this.state.stepData[_constants2.STORAGE_TAB_KEY].value).then(results => {
      const result = Array.isArray(results) ? results[results.length - 1] : results;
      return this.onStepDataChanged(_constants2.RESULT_TAB_KEY, JSON.stringify(result, null, 1), true);
    }).catch(error => this.onStepDataChanged(_constants2.RESULT_TAB_KEY, error.message, false));
  }

  render() {
    const beforeLastStepReached = this.state.activeStepIndex === this.wizardStepsNewVM.length - 2;
    const lastStepReached = this.lastStepReached();
    const createVmText = this.props.createTemplate ? _strings.CREATE_VM_TEMPLATE : _strings.CREATE_VM;
    return _react.default.createElement(_patternflyReact.Wizard.Pattern, {
      show: true,
      onHide: this.props.onHide,
      steps: this.wizardStepsNewVM,
      activeStepIndex: this.state.activeStepIndex,
      onStepChanged: index => this.onStepChanged(index),
      previousStepDisabled: lastStepReached,
      cancelButtonDisabled: lastStepReached,
      stepButtonsDisabled: lastStepReached,
      nextStepDisabled: !this.state.stepData[this.wizardStepsNewVM[this.state.activeStepIndex].key].valid,
      nextText: beforeLastStepReached ? createVmText : _strings.NEXT,
      title: createVmText,
      dialogClassName: "modal-lg wizard-pf kubevirt-wizard kubevirt-create-vm-wizard"
    });
  }

}

exports.CreateVmWizard = CreateVmWizard;
CreateVmWizard.defaultProps = {
  templates: null,
  namespaces: null,
  selectedNamespace: null,
  networkConfigs: null,
  persistentVolumeClaims: null,
  storageClasses: null,
  createTemplate: false
};
CreateVmWizard.propTypes = {
  onHide: _propTypes.default.func.isRequired,
  templates: _propTypes.default.array,
  namespaces: _propTypes.default.array,
  selectedNamespace: _propTypes.default.object,
  k8sCreate: _propTypes.default.func.isRequired,
  networkConfigs: _propTypes.default.array,
  persistentVolumeClaims: _propTypes.default.array,
  storageClasses: _propTypes.default.array,
  units: _propTypes.default.object.isRequired,
  createTemplate: _propTypes.default.bool
};