"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.containerMultusTemplate = void 0;
const containerMultusTemplate = {
  apiVersion: 'template.openshift.io/v1',
  kind: 'Template',
  metadata: {
    labels: {
      'flavor.template.cnv.io/small': 'true',
      'os.template.cnv.io/fedora29': 'true',
      'template.cnv.io/type': 'vm',
      'template.cnv.ui': 'default_fedora-generic',
      'workload.template.cnv.io/generic': 'true'
    },
    annotations: {
      'name.os.template.cnv.io/fedora29': 'Fedora 29'
    },
    name: 'container-template-multus',
    namespace: 'myproject'
  },
  objects: [{
    apiVersion: 'kubevirt.io/v1alpha3',
    kind: 'VirtualMachine',
    metadata: {
      // eslint-disable-next-line no-template-curly-in-string
      name: '${NAME}'
    },
    spec: {
      template: {
        spec: {
          domain: {
            cpu: {
              cores: 2
            },
            devices: {
              autoattachPodInterface: false,
              disks: [{
                bootOrder: 1,
                disk: {
                  bus: 'virtio'
                },
                name: 'rootdisk'
              }],
              interfaces: [{
                bridge: {},
                name: 'eth1'
              }],
              rng: {}
            },
            resources: {
              requests: {
                memory: '2G'
              }
            }
          },
          networks: [{
            multus: {
              networkName: 'pxe-net-conf'
            },
            name: 'eth1'
          }],
          terminationGracePeriodSeconds: 0,
          volumes: [{
            name: 'rootdisk',
            containerDisk: {
              image: 'fooContainer'
            }
          }]
        }
      }
    }
  }],
  parameters: [{
    description: 'Name for the new VM',
    name: 'NAME'
  }]
};
exports.containerMultusTemplate = containerMultusTemplate;