'use strict'

const norm = require('./')
const assert = require('assert')
const getBounds = require('array-bounds')

let a = [-Infinity, -1, 0, 1, Infinity]
assert.deepEqual(norm(a.slice()), [0, 0.5, 0.5, 0.5, 1])

let b = [0, .5, 1]
assert.deepEqual(norm(b.slice()), b)

let c = [0, 50, 100]
assert.deepEqual(norm(c.slice()), [0, .5, 1])

let d = [0, 0, .1, .2, 1, 2]
assert.deepEqual(norm(d.slice(), 2), [0, 0, .1, .1, 1, 1])

let e = [0, 0, .1, .2, 1, 2]
assert.deepEqual(norm(e.slice(), 2, getBounds(e, 2)), [0, 0, .1, .1, 1, 1])

let f = [0, .25, 1, .25]
assert.deepEqual(norm(f, 2, [0, .5, 1, .5]), [0, .5, 1, .5])
