/** @module  color-rgba */

'use strict'

var parse = require('color-parse')
var hsl = require('color-space/hsl')
var clamp = require('clamp')

module.exports = function rgba (color, normalize) {
	if (Array.isArray(color)) return color;

	if (normalize == null) normalize = true

	var parsed = parse(color);

	if (!parsed.space) return [];

	var values = parsed.values, i, l = values.length;
	for (i = 0; i < l; i++) {
		values[i] = clamp(values[i], 0, 255)
	}

	if (parsed.space[0] === 'h') {
		values = hsl.rgb(values)
	}

	if (normalize) {
		for (i = 0; i < l; i++) {
			values[i] /= 255
		}
	}

	values.push(clamp(parsed.alpha, 0, 1))

	return values
}

