'use strict';Object.defineProperty(exports, "__esModule", { value: true });var _path;














function _load_path() {return _path = _interopRequireDefault(require('path'));}var _jestUtil;
function _load_jestUtil() {return _jestUtil = require('jest-util');}var _gracefulFs;
function _load_gracefulFs() {return _gracefulFs = _interopRequireDefault(require('graceful-fs'));}var _get_no_test_found_message;
function _load_get_no_test_found_message() {return _get_no_test_found_message = _interopRequireDefault(require('./get_no_test_found_message'));}var _search_source;
function _load_search_source() {return _search_source = _interopRequireDefault(require('./search_source'));}var _test_scheduler;
function _load_test_scheduler() {return _test_scheduler = _interopRequireDefault(require('./test_scheduler'));}var _test_sequencer;
function _load_test_sequencer() {return _test_sequencer = _interopRequireDefault(require('./test_sequencer'));}var _test_result_helpers;
function _load_test_result_helpers() {return _test_result_helpers = require('./test_result_helpers');}function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}function _asyncToGenerator(fn) {return function () {var gen = fn.apply(this, arguments);return new Promise(function (resolve, reject) {function step(key, arg) {try {var info = gen[key](arg);var value = info.value;} catch (error) {reject(error);return;}if (info.done) {resolve(value);} else {return Promise.resolve(value).then(function (value) {step("next", value);}, function (err) {step("throw", err);});}}return step("next");});};} /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This source code is licensed under the MIT license found in the
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * LICENSE file in the root directory of this source tree.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */const setConfig = (contexts, newConfig) => contexts.forEach(context => context.config = Object.freeze(Object.assign({}, context.config, newConfig)));


const getTestPaths = (() => {var _ref = _asyncToGenerator(function* (
  globalConfig,
  context,
  outputStream,
  changedFilesPromise)
  {
    const source = new (_search_source || _load_search_source()).default(context);
    let data = yield source.getTestPaths(globalConfig, changedFilesPromise);

    if (!data.tests.length && globalConfig.onlyChanged && data.noSCM) {
      if (globalConfig.watch) {
        data = yield source.getTestPaths(globalConfig);
      } else {
        new (_jestUtil || _load_jestUtil()).Console(outputStream, outputStream).log(
        'Jest can only find uncommitted changed files in a git or hg ' +
        'repository. If you make your project a git or hg ' +
        'repository (`git init` or `hg init`), Jest will be able ' +
        'to only run tests related to files changed since the last ' +
        'commit.');

      }
    }
    return data;
  });return function getTestPaths(_x, _x2, _x3, _x4) {return _ref.apply(this, arguments);};})();

const processResults = (runResults, options) => {const
  outputFile = options.outputFile;
  if (options.testResultsProcessor) {
    /* $FlowFixMe */
    runResults = require(options.testResultsProcessor)(runResults);
  }
  if (options.isJSON) {
    if (outputFile) {
      const filePath = (_path || _load_path()).default.resolve(process.cwd(), outputFile);

      (_gracefulFs || _load_gracefulFs()).default.writeFileSync(filePath, JSON.stringify((0, (_jestUtil || _load_jestUtil()).formatTestResults)(runResults)));
      process.stdout.write(
      `Test results written to: ` +
      `${(_path || _load_path()).default.relative(process.cwd(), filePath)}\n`);

    } else {
      process.stdout.write(JSON.stringify((0, (_jestUtil || _load_jestUtil()).formatTestResults)(runResults)));
    }
  }
  return options.onComplete && options.onComplete(runResults);
};exports.default = (() => {var _ref3 = _asyncToGenerator(

  function* (_ref2)















  {let contexts = _ref2.contexts,globalConfig = _ref2.globalConfig,outputStream = _ref2.outputStream,testWatcher = _ref2.testWatcher,startRun = _ref2.startRun,changedFilesPromise = _ref2.changedFilesPromise,onComplete = _ref2.onComplete;
    const sequencer = new (_test_sequencer || _load_test_sequencer()).default();
    let allTests = [];
    const testRunData = yield Promise.all(
    contexts.map((() => {var _ref4 = _asyncToGenerator(function* (context) {
        const matches = yield getTestPaths(
        globalConfig,
        context,
        outputStream,
        changedFilesPromise);

        allTests = allTests.concat(matches.tests);
        return { context, matches };
      });return function (_x6) {return _ref4.apply(this, arguments);};})()));


    allTests = sequencer.sort(allTests);

    if (globalConfig.listTests) {
      const testsPaths = allTests.map(function (test) {return test.path;});
      if (globalConfig.json) {
        console.log(JSON.stringify(testsPaths));
      } else {
        console.log(testsPaths.join('\n'));
      }

      onComplete && onComplete((0, (_test_result_helpers || _load_test_result_helpers()).makeEmptyAggregatedTestResult)());
      return null;
    }

    if (!allTests.length) {
      new (_jestUtil || _load_jestUtil()).Console(outputStream, outputStream).log(
      (0, (_get_no_test_found_message || _load_get_no_test_found_message()).default)(testRunData, globalConfig));

    } else if (
    allTests.length === 1 &&
    globalConfig.silent !== true &&
    globalConfig.verbose !== false)
    {
      globalConfig = Object.freeze(
      Object.assign({}, globalConfig, { verbose: true }));

    }

    // When using more than one context, make all printed paths relative to the
    // current cwd. Do not modify rootDir, since will be used by custom resolvers.
    // If --runInBand is true, the resolver saved a copy during initialization,
    // however, if it is running on spawned processes, the initiation of the
    // custom resolvers is done within each spawned process and it needs the
    // original value of rootDir. Instead, use the {cwd: Path} property to resolve
    // paths when printing.
    setConfig(contexts, { cwd: process.cwd() });

    const results = yield new (_test_scheduler || _load_test_scheduler()).default(globalConfig, {
      startRun }).
    scheduleTests(allTests, testWatcher);

    sequencer.cacheResults(allTests, results);

    return processResults(results, {
      isJSON: globalConfig.json,
      onComplete,
      outputFile: globalConfig.outputFile,
      testResultsProcessor: globalConfig.testResultsProcessor });

  });function runJest(_x5) {return _ref3.apply(this, arguments);}return runJest;})();