"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../../utils");

var _InlineEdit = require("../../InlineEdit");

var _Loading = require("../../Loading");

var _constants = require("../../../constants");

var _Form = require("../../Form");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getDescriptionFormFields = id => ({
  description: {
    id: (0, _utils.prefixedId)(id, 'textarea'),
    type: _Form.TEXT_AREA
  }
});

const Description = ({
  formValues,
  obj,
  editing,
  updating,
  LoadingComponent,
  onFormChange,
  id
}) => {
  if (!(formValues && formValues.description)) {
    onFormChange({
      value: (0, _utils.getDescription)(obj)
    }, 'description', true);
  }

  return _react.default.createElement(_InlineEdit.InlineEdit, {
    id: id,
    formFields: getDescriptionFormFields(id),
    fieldsValues: formValues,
    editing: editing,
    updating: updating,
    LoadingComponent: LoadingComponent,
    onFormChange: onFormChange
  }, (0, _utils.getDescription)(obj) || _constants.DASHES);
};

exports.Description = Description;
Description.propTypes = {
  formValues: _propTypes.default.object,
  obj: _propTypes.default.object.isRequired,
  // vm, vmTemplate
  editing: _propTypes.default.bool,
  updating: _propTypes.default.bool,
  LoadingComponent: _propTypes.default.func,
  onFormChange: _propTypes.default.func,
  id: _propTypes.default.string
};
Description.defaultProps = {
  formValues: undefined,
  editing: false,
  updating: false,
  LoadingComponent: _Loading.Loading,
  onFormChange: () => {},
  id: undefined
};