"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactDnd = require("react-dnd");

var _reactDndHtml5Backend = _interopRequireDefault(require("react-dnd-html5-backend"));

var dnd = _interopRequireWildcard(require("reactabular-dnd"));

var _lodash = require("lodash");

var _patternflyReact = require("patternfly-react");

var _FormFactory = require("../Form/FormFactory");

var _utils = require("../../utils/utils");

var _InlineEditRow = require("./InlineEditRow");

var _constants = require("./constants");

var _Form = require("../Form");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class EditableDraggableTable extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      editing: false
    });

    _defineProperty(this, "flagUpdate", (rows, editingInProgress) => rows.forEach(row => row.editingInProgress = editingInProgress));

    _defineProperty(this, "inlineEditController", {
      isEditing: ({
        rowData
      }) => rowData.backup !== undefined,
      onActivate: ({
        rowData
      }) => {
        if (!this.state.editing) {
          const editing = true;
          const id = rowData.id;
          const rows = (0, _lodash.cloneDeep)(this.props.rows);
          const index = (0, _lodash.findIndex)(rows, {
            id
          });

          if (index !== -1) {
            const row = rows[index];

            if (row.editable) {
              delete row.edit; // remove edit signal

              row.backup = (0, _lodash.cloneDeep)(row);
              this.flagUpdate(rows, editing);
              this.setState({
                editing
              });
              this.props.onChange(rows, {
                type: _constants.ON_ACTIVATE,
                id,
                editing
              });
            }
          }
        }
      },
      onConfirm: ({
        rowData
      }) => {
        const editing = false;
        const id = rowData.id;
        const rows = (0, _lodash.cloneDeep)(this.props.rows);
        const index = (0, _lodash.findIndex)(rows, {
          id
        });
        delete rows[index].backup;
        this.flagUpdate(rows, editing);
        this.setState({
          editing
        });
        this.props.onChange(rows, {
          type: _constants.ON_CONFIRM,
          id,
          editing
        });
      },
      onCancel: ({
        rowData
      }) => {
        const editing = false;
        const id = rowData.id;
        const rows = (0, _lodash.cloneDeep)(this.props.rows);
        const index = (0, _lodash.findIndex)(rows, {
          id
        });
        rows[index] = (0, _lodash.cloneDeep)(rows[index].backup);
        delete rows[index].backup;
        this.flagUpdate(rows, editing);
        this.setState({
          editing
        });
        this.props.onChange(rows, {
          type: _constants.ON_CANCEL,
          id,
          editing
        });
      },
      onChange: (value, {
        rowData,
        property
      }) => {
        const editing = true;
        const id = rowData.id;
        const rows = (0, _lodash.cloneDeep)(this.props.rows);
        const index = (0, _lodash.findIndex)(rows, {
          id
        });
        rows[index][property] = value;
        this.props.onChange(rows, {
          type: _constants.ON_CHANGE,
          id,
          editing
        });
      }
    });

    _defineProperty(this, "crudController", {
      onDelete: ({
        rowData
      }) => {
        const id = rowData.id;
        this.props.onChange(this.props.rows.filter(row => row.id !== id), {
          type: _constants.ON_DELETE,
          editing: false,
          id
        });
      }
    });

    _defineProperty(this, "getActionButton", (action, additionalData, id) => {
      switch (action.actionType) {
        case _constants.DELETE_ACTION:
          return _react.default.createElement(_patternflyReact.MenuItem, {
            id: id,
            key: id,
            onSelect: () => this.crudController.onDelete(additionalData)
          }, action.text);

        default:
          return null;
      }
    });

    _defineProperty(this, "getActionButtons", (additionalData, isEditing) => {
      const renderConfig = this.getRenderConfig(additionalData);
      let result;

      if (renderConfig) {
        const id = (0, _utils.prefixedId)(renderConfig.id, additionalData.rowKey);
        result = isEditing && !renderConfig.visibleOnEdit ? null : _react.default.createElement(_patternflyReact.DropdownKebab, {
          className: "kubevirt-editable-table__row-actions",
          id: id,
          key: id,
          pullRight: true
        }, renderConfig.actions.map((action, idx) => this.getActionButton(action, additionalData, (0, _utils.prefixedId)(idx, id))));
      }

      return _react.default.createElement("td", {
        className: "editable"
      }, result);
    });

    _defineProperty(this, "isDropdown", additionalData => (0, _lodash.get)(this.getRenderConfig(additionalData), 'type') === _Form.DROPDOWN);

    _defineProperty(this, "getRenderConfig", additionalData => {
      const renderConfig = additionalData.column.renderConfig;
      return renderConfig ? renderConfig(additionalData.rowData) : null;
    });

    _defineProperty(this, "resolveRenderedValue", (value, additionalData, editable) => {
      const renderConfig = this.getRenderConfig(additionalData);
      let result;

      if (this.isDropdown(additionalData)) {
        result = (0, _lodash.get)(renderConfig.choices.find(clazz => clazz.id === value), 'name');
      }

      if (!result) {
        result = value;
      }

      if (!editable && additionalData.column.hasAddendum) {
        const addendum = additionalData.rowData.addendum;

        if (addendum) {
          result = result ? `${result} ${addendum}` : addendum;
        }
      }

      return result;
    });

    _defineProperty(this, "inlineEditFormatter", (0, _patternflyReact.inlineEditFormatterFactory)({
      isEditing: additionalData => this.inlineEditController.isEditing(additionalData) && this.getRenderConfig(additionalData),
      renderValue: (value, additionalData) => {
        const data = this.resolveRenderedValue(value, additionalData, false);
        const _additionalData$rowDa = additionalData.rowData,
              errors = _additionalData$rowDa.errors,
              isBootable = _additionalData$rowDa.isBootable;
        let errorField;

        if (errors && additionalData.columnIndex + 1 < errors.length) {
          const error = errors[additionalData.columnIndex + 1];

          if (error) {
            errorField = _react.default.createElement("div", {
              className: (0, _classnames.default)('form-group has-error kubevirt-editable-table__cell-error', {
                'kubevirt-editable-table__cell-error--bootable': !data && isBootable
              })
            }, _react.default.createElement(_patternflyReact.HelpBlock, null, error));
          }
        }

        return _react.default.createElement("td", {
          className: "editable kubevirt-editable-table__cell",
          onClick: () => this.inlineEditController.onActivate(additionalData)
        }, _react.default.createElement("div", {
          className: "static"
        }, data, errorField));
      },
      renderEdit: (value, additionalData) => {
        const renderConfig = this.getRenderConfig(additionalData);
        const isDropdown = this.isDropdown(additionalData);

        const onChange = v => this.inlineEditController.onChange(v, additionalData);

        return _react.default.createElement("td", {
          className: "editable editing kubevirt-editable-table__cell"
        }, (0, _FormFactory.getFormElement)(_objectSpread({}, renderConfig, {
          id: (0, _utils.prefixedId)(renderConfig.id, additionalData.rowKey),
          value: this.resolveRenderedValue(value, additionalData, true),
          defaultValue: this.resolveRenderedValue(value, additionalData, true) || renderConfig.initialValue,
          onChange: isDropdown ? onChange : null,
          // onChange for dropdowns
          onBlur: isDropdown ? null : onChange // onBlur for text

        })));
      }
    }));

    _defineProperty(this, "inlineEditButtonsFormatter", (0, _patternflyReact.inlineEditFormatterFactory)({
      isEditing: additionalData => this.state.editing,
      renderValue: (value, additionalData) => this.getActionButtons(additionalData, false),
      renderEdit: (value, additionalData) => this.getActionButtons(additionalData, true)
    }));

    _defineProperty(this, "onRow", (rowData, {
      rowIndex
    }) => ({
      rowId: rowData.id,
      role: 'row',
      onMove: ({
        sourceRowId,
        targetRowId
      }) => {
        if (!this.state.editing) {
          const rows = dnd.moveRows({
            sourceRowId,
            targetRowId
          })(this.props.rows);

          if (rows) {
            this.props.onChange(rows, {
              type: _constants.ON_MOVE,
              id: sourceRowId,
              targetRowId,
              editing: false
            });
          }
        }
      },
      isEditing: () => this.inlineEditController.isEditing({
        rowData
      }),
      onCancel: () => this.inlineEditController.onCancel({
        rowData,
        rowIndex
      }),
      onConfirm: () => this.inlineEditController.onConfirm({
        rowData,
        rowIndex
      }),
      last: rowIndex > 3 && rowIndex === this.props.rows.length - 1
    }));
  }

  componentDidUpdate() {
    const editRow = this.props.rows.find(row => row.edit);

    if (editRow) {
      this.inlineEditController.onActivate({
        rowData: editRow
      });
    }
  } // needed for refiring row renders
  // eslint-disable-next-line no-return-assign


  render() {
    // setup our custom formatter for the cells
    const columns = this.props.columns.map(column => _objectSpread({}, column, {
      cell: _objectSpread({}, column.cell, {
        formatters: [column.type === _constants.ACTIONS_TYPE ? this.inlineEditButtonsFormatter : this.inlineEditFormatter]
      })
    }));
    const renderers = {
      body: {
        row: dnd.draggableRow(_InlineEditRow.InlineEditRow),
        cell: cellProps => cellProps.children
      }
    };
    return _react.default.createElement(_patternflyReact.TablePfProvider, {
      striped: true,
      bordered: true,
      hover: true,
      dataTable: true,
      inlineEdit: true,
      columns: columns,
      renderers: renderers,
      key: "TablePfProvider",
      className: "kubevirt-editable-table"
    }, _react.default.createElement(_patternflyReact.Table.Header, {
      key: "Table.Header"
    }), _react.default.createElement(_patternflyReact.Table.Body, {
      key: "Table.Body",
      rows: this.props.rows,
      rowKey: "id",
      onRow: this.onRow
    }));
  }

}

EditableDraggableTable.propTypes = {
  rows: _propTypes.default.array.isRequired,
  columns: _propTypes.default.array.isRequired,
  onChange: _propTypes.default.func.isRequired
};

var _default = (0, _reactDnd.DragDropContext)(_reactDndHtml5Backend.default)(EditableDraggableTable);

exports.default = _default;