"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DesktopViewerSelector = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactConsole = require("@patternfly/react-console");

var _patternflyReact = require("patternfly-react");

var _lodash = require("lodash");

var _Form = require("../Form");

var _selectors = require("../../k8s/selectors");

var _constants = require("../../constants");

var _VmConsoles = require("./VmConsoles");

var _strings = require("./strings");

var _constants2 = require("./constants");

var _constants3 = require("../Wizard/CreateVmWizard/constants");

var _vmBuilder = require("../../k8s/vmBuilder");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const getForm = networks => ({
  [_constants2.NIC_KEY]: {
    id: 'nic-dropdown',
    title: _strings.NIC,
    type: 'dropdown',
    defaultValue: _strings.SELECT_NETWORK_INTERFACE,
    choices: networks,
    help: _strings.RDP_NETWORK_INTERFACE_HELP
  }
});

const getVmRdpNetworks = (vm, vmi) => {
  const networks = (0, _vmBuilder.getNetworks)(vm).filter(n => n.multus || n.pod);
  return (0, _lodash.get)(vmi, 'status.interfaces', []).filter(i => networks.some(n => n.name === i.name)).map(i => {
    let ip = i.ipAddress;

    if (i.ipAddress) {
      const subnetIndex = i.ipAddress.indexOf('/');

      if (subnetIndex > 0) {
        ip = i.ipAddress.slice(0, subnetIndex);
      }
    }

    const network = networks.find(n => n.name === i.name);
    return {
      name: i.name,
      type: (0, _lodash.get)(network, 'multus') ? _constants3.NETWORK_TYPE_MULTUS : _constants3.NETWORK_TYPE_POD,
      ip
    };
  });
};

const getDefaultNetwork = networks => {
  if (networks.length === 1) {
    return networks[0];
  }

  if (networks.length > 1) {
    return networks.find(n => n.type === _constants3.NETWORK_TYPE_MULTUS && n.ipAddress) || networks.find(n => n.type === _constants3.NETWORK_TYPE_MULTUS);
  }

  return null;
};

class DesktopViewerSelector extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onFormChange", (newValue, target) => {
      this.setState({
        [target]: newValue
      });
    });

    const networks = getVmRdpNetworks(props.vm, props.vmi);
    this.state = {
      [_constants2.NIC_KEY]: {
        value: getDefaultNetwork(networks)
      }
    };
  }

  render() {
    const networks = getVmRdpNetworks(this.props.vm, this.props.vmi);
    let content;

    switch ((0, _lodash.get)((0, _selectors.settingsValue)(this.state, _constants2.NIC_KEY), 'type')) {
      case _constants3.NETWORK_TYPE_MULTUS:
        if (!this.props.guestAgent) {
          content = _react.default.createElement(_patternflyReact.Alert, {
            type: "warning"
          }, _strings.GUEST_AGENT_WARNING);
        } else if (!(0, _selectors.settingsValue)(this.state, _constants2.NIC_KEY).ip) {
          content = _react.default.createElement(_patternflyReact.Alert, {
            type: "warning"
          }, `${_strings.NO_IP_ADDRESS} ${(0, _selectors.settingsValue)(this.state, _constants2.NIC_KEY).name}`);
        } else {
          const rdp = {
            address: (0, _selectors.settingsValue)(this.state, _constants2.NIC_KEY).ip,
            port: _constants.DEFAULT_RDP_PORT
          };
          content = _react.default.createElement(_reactConsole.DesktopViewer, {
            rdp: rdp
          });
        }

        break;

      case _constants3.NETWORK_TYPE_POD:
        content = this.props.rdpServiceManual || this.props.vncServiceManual ? _react.default.createElement(_reactConsole.DesktopViewer, {
          rdp: this.props.rdpServiceManual,
          vnc: this.props.vncServiceManual
        }) : _react.default.createElement(_VmConsoles.RdpServiceNotConfigured, {
          vm: this.props.vm
        });
        break;

      default:
        // eslint-disable-next-line no-console
        console.warn(`Unknown network interface type ${(0, _lodash.get)((0, _selectors.settingsValue)(this.state, _constants2.NIC_KEY), 'type')}`);
    }

    return _react.default.createElement("div", {
      className: "kubevirt-desktop-viewer-selector"
    }, _react.default.createElement(_Form.FormFactory, {
      fields: getForm(networks),
      fieldsValues: this.state,
      onFormChange: this.onFormChange
    }), content);
  }

}

exports.DesktopViewerSelector = DesktopViewerSelector;
DesktopViewerSelector.defaultProps = {
  guestAgent: false,
  rdpServiceManual: null,
  vncServiceManual: null
};
DesktopViewerSelector.propTypes = {
  vm: _propTypes.default.object.isRequired,
  vmi: _propTypes.default.object.isRequired,
  guestAgent: _propTypes.default.bool,
  rdpServiceManual: _propTypes.default.object,
  vncServiceManual: _propTypes.default.object
};