"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _patternflyReact = require("patternfly-react");

var _Form = require("../../../Form");

var _constants = require("../constants");

var _selectors = require("../../../../k8s/selectors");

var _VMWareProviderStatus = _interopRequireDefault(require("./VMWareProviderStatus"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

// workaround to wrap two components at a single row
const VMWarePasswordAndCheck = ({
  onChange: _onChange,
  id,
  value,
  extraProps
}) => {
  const onCheckConnection = extraProps.onCheckConnection,
        basicSettings = extraProps.basicSettings;
  const pwdValue = (0, _lodash.get)(value, _constants.PROVIDER_VMWARE_USER_PWD_KEY);
  const connValue = (0, _lodash.get)(value, _constants.PROVIDER_VMWARE_CONNECTION);
  return _react.default.createElement(_react.Fragment, null, _react.default.createElement(_Form.Text, {
    type: _Form.PASSWORD,
    id: `${id}-text`,
    value: pwdValue || '',
    onChange: newValue => _onChange({
      [_constants.PROVIDER_VMWARE_USER_PWD_KEY]: newValue,
      [_constants.PROVIDER_VMWARE_CONNECTION]: connValue
    })
  }), _react.default.createElement("div", {
    className: "kubevirt-create-vm-wizard__import-vmware-passwordcheck-button-section"
  }, _react.default.createElement(_patternflyReact.Button, {
    id: `${id}-check-button`,
    className: "kubevirt-create-vm-wizard__import-vmware-passwordcheck-button",
    disabled: !(0, _selectors.settingsValue)(basicSettings, _constants.PROVIDER_VMWARE_URL_KEY),
    onClick: () => {
      onCheckConnection(newValue => _onChange({
        [_constants.PROVIDER_VMWARE_USER_PWD_KEY]: pwdValue,
        [_constants.PROVIDER_VMWARE_CONNECTION]: newValue
      }));
    }
  }, "Check"), _react.default.createElement(_VMWareProviderStatus.default, {
    connValue: connValue,
    extraProps: extraProps
  })));
};

VMWarePasswordAndCheck.defaultProps = {
  id: undefined,
  value: undefined
};
VMWarePasswordAndCheck.propTypes = {
  onChange: _propTypes.default.func.isRequired,
  extraProps: _propTypes.default.object.isRequired,
  id: _propTypes.default.string,
  value: _propTypes.default.object
};
var _default = VMWarePasswordAndCheck;
exports.default = _default;