"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startV2VVMWareController = void 0;

var _models = require("../../../../models");

var _constants = require("../constants");

// eslint-disable-next-line no-console
const rejectLogger = title => reason => console.warn(`Failed to create ${title}, reason`, reason); // The controller is namespace-scoped, especially due to security reasons
// Let's make sure its started within the desired namespace (which is not by default).
// The V2VVmware CRD is expected to be already created within the cluster (by Web UI installation)


const startV2VVMWareController = async ({
  k8sCreate,
  k8sGet,
  namespace
}) => {
  try {
    await k8sGet(_models.DeploymentModel, _constants.V2VVMWARE_DEPLOYMENT_NAME, namespace);
  } catch (_unused) {
    // Deployment does not exist or the does not have permissions to see Deployments in this namespace
    // TODO: notify the user in other way not just the console.log
    // eslint-disable-next-line no-console
    console.info('V2V VMWare controller deployment not found, so creating one ...');
    const params = {
      k8sCreate,
      namespace
    };
    /* eslint-disable promise/catch-or-return */

    createServiceAccount(params).then(undefined, rejectLogger('Service Account'));
    createRole(params).then(undefined, rejectLogger('Role'));
    createRoleBinding(params).then(undefined, rejectLogger('Role Binding'));
    createOperator(params).then(undefined, rejectLogger('V2V VMWare controller'));
    /* eslint-enable promise/catch-or-return */
  }
};

exports.startV2VVMWareController = startV2VVMWareController;

const createServiceAccount = ({
  k8sCreate,
  namespace
}) => k8sCreate(_models.ServiceAccountModel, {
  apiVersion: _models.ServiceAccountModel.apiVersion,
  kind: _models.ServiceAccountModel.kind,
  metadata: {
    name: _constants.V2VVMWARE_DEPLOYMENT_NAME,
    namespace
  }
});

const createRole = ({
  k8sCreate,
  namespace
}) => k8sCreate(_models.RoleModel, {
  apiVersion: `${_models.RoleModel.apiGroup}/${_models.RoleModel.apiVersion}`,
  kind: _models.RoleModel.kind,
  metadata: {
    name: _constants.V2VVMWARE_DEPLOYMENT_NAME,
    namespace
  },
  rules: [{
    apiGroups: [''],
    attributeRestrictions: null,
    resources: [// TODO: review what's really needed
    'configmaps', 'endpoints', 'events', 'persistentvolumeclaims', 'pods', 'secrets', 'services'],
    verbs: ['*']
  }, {
    apiGroups: [''],
    attributeRestrictions: null,
    resources: ['namespaces'],
    verbs: ['get']
  }, {
    apiGroups: ['apps'],
    attributeRestrictions: null,
    resources: ['daemonsets', 'deployments', 'replicasets', 'statefulsets'],
    verbs: ['*']
  }, {
    apiGroups: ['monitoring.coreos.com'],
    attributeRestrictions: null,
    resources: ['servicemonitors'],
    verbs: ['create', 'get']
  }, {
    apiGroups: ['kubevirt.io'],
    attributeRestrictions: null,
    resources: ['*'],
    verbs: ['*']
  }]
});

const createRoleBinding = ({
  k8sCreate,
  namespace
}) => k8sCreate(_models.RoleBindingModel, {
  kind: _models.RoleBindingModel.kind,
  apiVersion: `${_models.RoleBindingModel.apiGroup}/${_models.RoleBindingModel.apiVersion}`,
  metadata: {
    name: _constants.V2VVMWARE_DEPLOYMENT_NAME,
    namespace
  },
  roleRef: {
    kind: _models.RoleModel.kind,
    name: _constants.V2VVMWARE_DEPLOYMENT_NAME,
    apiGroup: _models.RoleModel.apiGroup
  },
  subjects: [{
    kind: _models.ServiceAccountModel.kind,
    name: _constants.V2VVMWARE_DEPLOYMENT_NAME
  }]
}); // TODO: Do not use Deployment, just run the pod directly to simplify upgrades


const createOperator = ({
  k8sCreate,
  namespace
}) => k8sCreate(_models.DeploymentModel, {
  apiVersion: `${_models.DeploymentModel.apiGroup}/${_models.DeploymentModel.apiVersion}`,
  kind: _models.DeploymentModel.kind,
  metadata: {
    name: _constants.V2VVMWARE_DEPLOYMENT_NAME,
    namespace
  },
  spec: {
    replicas: 1,
    selector: {
      matchLabels: {
        name: _constants.V2VVMWARE_DEPLOYMENT_NAME
      }
    },
    template: {
      metadata: {
        labels: {
          name: _constants.V2VVMWARE_DEPLOYMENT_NAME
        }
      },
      spec: {
        serviceAccountName: _constants.V2VVMWARE_DEPLOYMENT_NAME,
        containers: [{
          name: _constants.V2VVMWARE_DEPLOYMENT_NAME,
          image: 'quay.io/mareklibra/v2v-vmware:v0.0.1',
          // TODO: parametrize from configuration (Web UI's ConfigMap)
          imagePullPolicy: 'Always',
          command: ['kubevirt-vmware'],
          env: [{
            name: 'WATCH_NAMESPACE',
            valueFrom: {
              fieldRef: {
                apiVersion: 'v1',
                fieldPath: 'metadata.namespace'
              }
            }
          }, {
            name: 'POD_NAME',
            valueFrom: {
              fieldRef: {
                apiVersion: 'v1',
                fieldPath: 'metadata.name'
              }
            }
          }, {
            name: 'OPERATOR_NAME',
            value: _constants.V2VVMWARE_DEPLOYMENT_NAME
          }]
        }]
      }
    }
  }
});