"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVMWareSection = exports.isNewVmwareInstanceSelected = exports.isVmwareNewInstance = void 0;

var _selectors = require("../../../../k8s/selectors");

var _strings = require("../strings");

var _validations = require("../../../../utils/validations");

var _constants = require("../constants");

var _VMWarePasswordAndCheck = _interopRequireDefault(require("./VMWarePasswordAndCheck"));

var _VCenterInstances = _interopRequireDefault(require("./VCenterInstances"));

var _vmwareActions = require("./vmwareActions");

var _VCenterVms = _interopRequireDefault(require("./VCenterVms"));

var _Form = require("../../../Form");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const isVmwareNewInstance = basicSettings => (0, _selectors.settingsValue)(basicSettings, _constants.PROVIDER_VMWARE_VCENTER_KEY) === _strings.CONNECT_TO_NEW_INSTANCE;

exports.isVmwareNewInstance = isVmwareNewInstance;

const isNewVmwareInstanceSelected = basicVmSettings => (0, _selectors.isImportProviderType)(basicVmSettings, _constants.PROVIDER_VMWARE) && isVmwareNewInstance(basicVmSettings);

exports.isNewVmwareInstanceSelected = isNewVmwareInstanceSelected;

const getVMWareNewConnectionSection = (basicSettings, WithResources, k8sCreate) => ({
  [_constants.PROVIDER_VMWARE_URL_KEY]: {
    id: 'vcenter-url-dropdown',
    title: 'vCenter URL',
    required: true,
    isVisible: isNewVmwareInstanceSelected,
    validate: settings => (0, _validations.validateVmwareURL)((0, _selectors.settingsValue)(settings, _constants.PROVIDER_VMWARE_URL_KEY)),
    defaultValue: 'https://host:port/',
    help: 'Address to be used for connection to a vCenter instance. The "https://" protocol will be added automatically. Example: "my.domain.com:1234".'
  },
  [_constants.PROVIDER_VMWARE_USER_NAME_KEY]: {
    id: 'vcenter-username',
    title: 'vCenter User Name',
    required: true,
    isVisible: isNewVmwareInstanceSelected,
    help: 'User name to be used for connection to a vCenter instance.'
  },
  [_constants.PROVIDER_VMWARE_USER_PWD_AND_CHECK_KEY]: {
    id: 'vcenter-userpwd',
    title: 'vCenter Password',
    type: _Form.CUSTOM,
    CustomComponent: _VMWarePasswordAndCheck.default,
    extraProps: {
      onCheckConnection: onConnectionStateChanged => (0, _vmwareActions.onVmwareCheckConnection)(basicSettings, onConnectionStateChanged, k8sCreate),
      WithResources,
      basicSettings
    },
    required: true,
    isVisible: isNewVmwareInstanceSelected,
    // validate: settings => validateVmwareConnection(settingsValue(settings, PROVIDER_VMWARE_CONNECTION)),
    help: 'User password to be used for connection to a vCenter instance.'
  },
  [_constants.PROVIDER_VMWARE_USER_PWD_REMEMBER_KEY]: {
    id: 'vcenter-remember-credentials',
    title: 'Remember vCenter credentials',
    type: _Form.CHECKBOX,
    isVisible: isNewVmwareInstanceSelected,
    help: 'If checked, new secret keeping connection details will be created for later use.' // text is recently not rendered

  }
});

const getVMWareSection = (basicSettings, WithResources, k8sCreate, k8sGet, k8sPatch) => _objectSpread({
  [_constants.PROVIDER_VMWARE_VCENTER_KEY]: {
    id: 'vcenter-instance-dropdown',
    title: 'vCenter Instance',
    type: _Form.CUSTOM,
    CustomComponent: _VCenterInstances.default,
    extraProps: {
      WithResources,
      basicSettings
    },
    onChange: (...props) => (0, _vmwareActions.onVCenterInstanceSelected)(k8sCreate, ...props),
    required: true,
    isVisible: basicVmSettings => (0, _selectors.isImportProviderType)(basicVmSettings, _constants.PROVIDER_VMWARE),
    defaultValue: '--- Select vCenter Instance Secret ---',
    help: 'Select secret containing connection details for a vCenter instance.'
  }
}, getVMWareNewConnectionSection(basicSettings, WithResources, k8sCreate), {
  [_constants.PROVIDER_VMWARE_VM_KEY]: {
    id: 'vcenter-vm-dropdown',
    title: 'VM to Import',
    type: _Form.CUSTOM,
    CustomComponent: _VCenterVms.default,
    extraProps: {
      WithResources,
      basicSettings
    },
    onChange: (...props) => (0, _vmwareActions.onVCenterVmSelectedConnected)(k8sCreate, k8sGet, k8sPatch, ...props),
    required: true,
    isVisible: basicVmSettings => (0, _selectors.isImportProviderType)(basicVmSettings, _constants.PROVIDER_VMWARE),
    defaultValue: _strings.PROVIDER_SELECT_VM,
    help: 'Select a vCenter virtual machine to import. Loading of their list might take some time. The list will be enabled for selection once data are loaded.'
  }
});

exports.getVMWareSection = getVMWareSection;