"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getV2VVMwareObject = exports.getImportProviderSecretObject = exports.getDefaultSecretName = void 0;

var _models = require("../../../../models");

var _constants = require("../../../../constants");

/**
 * Based on V2V Provider Pod manifest.yaml
 */
const getDefaultSecretName = ({
  username,
  url
}) => {
  if (!url) {
    throw new Error('VMWare URL can not be empty.');
  }

  if (!url.startsWith('https://') && !url.startsWith('http://')) {
    url = `https://${url}`;
  }

  const u = new URL(url);
  const host = u.host || 'nohost';
  username = username || 'nousername';
  const user = username.replace('@', '-at-');
  return `${host}-${user}`;
};

exports.getDefaultSecretName = getDefaultSecretName;

const getImportProviderSecretObject = ({
  url,
  username,
  password,
  secretName,
  namespace,
  isTemporary = false
}) => {
  const _secretName = secretName || `${getDefaultSecretName({
    username,
    url
  })}-`;

  const labels = {
    [_constants.VCENTER_TYPE_LABEL]: 'true'
  };

  if (isTemporary) {
    // if set, the Secret is not listed for selection within the dropdown box and is automatically garbage-collected (by controller)
    labels[_constants.VCENTER_TEMPORARY_LABEL] = 'true'; // will be automatically garbage-collected by the controller
  }

  const secret = {
    kind: _models.SecretModel.kind,
    apiVersion: _models.SecretModel.apiVersion,
    metadata: {
      generateName: _secretName,
      namespace,
      labels
    },
    type: 'Opaque',
    data: {
      username: btoa(username),
      password: btoa(password),
      url: btoa(url)
    }
  };
  return secret;
};

exports.getImportProviderSecretObject = getImportProviderSecretObject;

const getV2VVMwareObject = ({
  name,
  namespace,
  connectionSecretName,
  isTemporary = false
}) => {
  const labels = {};

  if (isTemporary) {
    // if set, the Secret is not listed for selection within the dropdown box and is automatically garbage-collected (by controller)
    labels[_constants.VCENTER_TEMPORARY_LABEL] = 'true'; // will be automatically garbage-collected by the controller
  }

  return {
    apiVersion: `${_models.V2VVMwareModel.apiGroup}/${_models.V2VVMwareModel.apiVersion}`,
    kind: _models.V2VVMwareModel.kind,
    metadata: {
      generateName: name,
      namespace,
      labels
    },
    spec: {
      connection: connectionSecretName
    }
  };
};

exports.getV2VVMwareObject = getV2VVMwareObject;