"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataVolumeTemplateSpec = exports.getTemplateLabels = exports.getLabels = exports.getAnnotations = exports.getNetworks = exports.getDataVolumeTemplates = exports.getDevice = exports.getSpec = exports.getVmSpec = exports.getVolumes = exports.getInterfaces = exports.getDomain = exports.getDisks = exports.getDevices = exports.removeInterfacesAndNetworks = exports.removeDisksAndVolumes = exports.addTemplateLabel = exports.addLabel = exports.addAnnotation = exports.addNetwork = exports.addInterface = exports.addDataVolumeTemplate = exports.addVolume = exports.addPvcVolume = exports.addDataVolume = exports.addContainerVolume = exports.addDisk = void 0;

var _lodash = require("lodash");

var _constants = require("../constants");

var _constants2 = require("../components/Wizard/CreateVmWizard/constants");

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const addDisk = (vm, defaultDisk, storage, getSetting) => {
  const diskSpec = _objectSpread({}, storage.templateStorage ? storage.templateStorage.disk : defaultDisk, {
    name: storage.name
  });

  if (storage.isBootable) {
    const imageSource = getSetting(_constants2.PROVISION_SOURCE_TYPE_KEY);
    diskSpec.bootOrder = imageSource === _constants.PROVISION_SOURCE_PXE ? _constants.BOOT_ORDER_SECOND : _constants.BOOT_ORDER_FIRST;
  } else {
    delete diskSpec.bootOrder;
  }

  const disks = getDisks(vm);
  disks.push(diskSpec);
};

exports.addDisk = addDisk;

const addContainerVolume = (vm, storage, getSetting) => {
  const volume = _objectSpread({}, storage.templateStorage ? storage.templateStorage.volume : {}, {
    name: storage.name,
    containerDisk: _objectSpread({}, storage.templateStorage ? storage.templateStorage.volume.containerDisk : {})
  });

  if (storage.rootStorage) {
    volume.containerDisk.image = getSetting(_constants2.CONTAINER_IMAGE_KEY);
  }

  addVolume(vm, volume);
};

exports.addContainerVolume = addContainerVolume;

const addDataVolume = (vm, storage) => {
  const volume = _objectSpread({}, storage.templateStorage ? storage.templateStorage.volume : {}, {
    name: storage.name,
    dataVolume: _objectSpread({}, storage.templateStorage ? storage.templateStorage.volume.dataVolume : {}, {
      name: storage.dvName
    })
  });

  addVolume(vm, volume);
};

exports.addDataVolume = addDataVolume;

const addPvcVolume = (vm, storage) => {
  const volume = _objectSpread({}, storage.templateStorage ? storage.templateStorage.volume : {}, {
    name: storage.name,
    persistentVolumeClaim: _objectSpread({}, storage.templateStorage ? storage.templateStorage.volume.persistentVolumeClaim : {}, {
      claimName: storage.name
    })
  });

  addVolume(vm, volume);
};

exports.addPvcVolume = addPvcVolume;

const addVolume = (vm, volumeSpec) => {
  const volumes = getVolumes(vm);
  volumes.push(volumeSpec);
};

exports.addVolume = addVolume;

const addDataVolumeTemplate = (vm, dataVolumeTemplate) => {
  const dataVolumeTemplates = getDataVolumeTemplates(vm);
  dataVolumeTemplates.push(dataVolumeTemplate);
  return dataVolumeTemplate;
};

exports.addDataVolumeTemplate = addDataVolumeTemplate;

const addInterface = (vm, defaultInterface, network) => {
  const interfaceSpec = _objectSpread({}, network.templateNetwork ? network.templateNetwork.interface : defaultInterface, {
    name: network.name
  });

  if (network.mac) {
    interfaceSpec.macAddress = network.mac;
  }

  if (network.isBootable) {
    interfaceSpec.bootOrder = _constants.BOOT_ORDER_FIRST;
  } else {
    delete interfaceSpec.bootOrder;
  }

  const interfaces = getInterfaces(vm);
  interfaces.push(interfaceSpec);
};

exports.addInterface = addInterface;

const addNetwork = (vm, network) => {
  const networkSpec = _objectSpread({}, network.templateNetwork ? network.templateNetwork.network : {}, {
    name: network.name
  }); // TODO support unknown types


  switch (network.networkType) {
    case _constants2.NETWORK_TYPE_MULTUS:
      networkSpec.multus = _objectSpread({}, network.templateNetwork ? network.templateNetwork.network.multus : {}, {
        networkName: network.network
      });
      break;

    case _constants2.NETWORK_TYPE_POD:
    default:
      networkSpec.pod = {};
      break;
  }

  const networks = getNetworks(vm);
  networks.push(networkSpec);
};

exports.addNetwork = addNetwork;

const addAnnotation = (vm, key, value) => {
  const annotations = getAnnotations(vm);
  annotations[key] = value;
};

exports.addAnnotation = addAnnotation;

const addLabel = (vm, key, value) => {
  const labels = getLabels(vm);
  labels[key] = value;
};

exports.addLabel = addLabel;

const addTemplateLabel = (vm, key, value) => {
  const labels = getTemplateLabels(vm);
  labels[key] = value;
};

exports.addTemplateLabel = addTemplateLabel;

const removeDisksAndVolumes = vm => {
  delete vm.spec.template.spec.domain.devices.disks;
  delete vm.spec.template.spec.volumes;
  delete vm.spec.dataVolumeTemplates;
};

exports.removeDisksAndVolumes = removeDisksAndVolumes;

const removeInterfacesAndNetworks = vm => {
  delete vm.spec.template.spec.domain.devices.interfaces;
  delete vm.spec.template.spec.networks;
};

exports.removeInterfacesAndNetworks = removeInterfacesAndNetworks;

const getDevices = vm => {
  const domain = getDomain(vm);

  if (!domain.devices) {
    domain.devices = {};
  }

  return domain.devices;
};

exports.getDevices = getDevices;

const getDisks = vm => {
  const devices = getDevices(vm);

  if (!devices.disks) {
    devices.disks = [];
  }

  return devices.disks;
};

exports.getDisks = getDisks;

const getDomain = vm => {
  const spec = getSpec(vm);

  if (!spec.domain) {
    spec.domain = {};
  }

  return spec.domain;
};

exports.getDomain = getDomain;

const getInterfaces = vm => {
  const devices = getDevices(vm);

  if (!devices.interfaces) {
    devices.interfaces = [];
  }

  return devices.interfaces;
};

exports.getInterfaces = getInterfaces;

const getVolumes = vm => {
  const spec = getSpec(vm);

  if (!spec.volumes) {
    spec.volumes = [];
  }

  return spec.volumes;
};

exports.getVolumes = getVolumes;

const getVmSpec = vm => {
  if (!vm.spec) {
    vm.spec = {};
  }

  return vm.spec;
};

exports.getVmSpec = getVmSpec;

const getSpec = vm => {
  const vmSpec = getVmSpec(vm);

  if (!vmSpec.template) {
    vmSpec.template = {
      spec: {}
    };
  } else if (!vmSpec.template.spec) {
    vmSpec.template.spec = {};
  }

  return vmSpec.template.spec;
};

exports.getSpec = getSpec;

const getDevice = (vm, deviceType, deviceName) => (0, _lodash.get)(getDevices(vm), deviceType, []).find(device => device.name === deviceName);

exports.getDevice = getDevice;

const getDataVolumeTemplates = vm => {
  const spec = getVmSpec(vm);

  if (!spec.dataVolumeTemplates) {
    spec.dataVolumeTemplates = [];
  }

  return spec.dataVolumeTemplates;
};

exports.getDataVolumeTemplates = getDataVolumeTemplates;

const getNetworks = vm => {
  const spec = getSpec(vm);

  if (!spec.networks) {
    spec.networks = [];
  }

  return spec.networks;
};

exports.getNetworks = getNetworks;

const getAnnotations = vm => {
  if (!vm.metadata.annotations) {
    vm.metadata.annotations = {};
  }

  return vm.metadata.annotations;
};

exports.getAnnotations = getAnnotations;

const getLabels = vm => {
  if (!vm.metadata.labels) {
    vm.metadata.labels = {};
  }

  return vm.metadata.labels;
};

exports.getLabels = getLabels;

const getTemplateLabels = vm => {
  const spec = getVmSpec(vm);

  if (!spec.template) {
    spec.template = {};
  }

  if (!spec.template.metadata) {
    spec.template.metadata = {};
  }

  if (!spec.template.metadata.labels) {
    spec.template.metadata.labels = {};
  }

  return spec.template.metadata.labels;
};

exports.getTemplateLabels = getTemplateLabels;

const getDataVolumeTemplateSpec = (storage, dvSource) => {
  let source;

  switch (dvSource.type) {
    case _constants2.DATA_VOLUME_SOURCE_URL:
      source = {
        http: {
          url: dvSource.url
        }
      };
      break;

    case _constants2.DATA_VOLUME_SOURCE_BLANK:
    default:
      source = {
        blank: {}
      };
  }

  return {
    metadata: {
      name: storage.dvName
    },
    spec: {
      pvc: {
        accessModes: [_constants.PVC_ACCESSMODE_RWO],
        resources: {
          requests: {
            storage: `${storage.size}Gi`
          }
        },
        storageClassName: storage.storageClass
      },
      source
    }
  };
};

exports.getDataVolumeTemplateSpec = getDataVolumeTemplateSpec;