"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubPagePath = void 0;

var _lodash = require("lodash");

const getSubPagePath = (apiObj, model, subPage) => {
  if (!apiObj || !model) {
    return undefined;
  }

  const ns = (0, _lodash.get)(apiObj, 'metadata.namespace', 'default');
  const name = (0, _lodash.get)(apiObj, 'metadata.name');
  subPage = subPage ? `/${subPage}` : '';
  return `/k8s/ns/${ns}/${model.path}/${name}${subPage}`;
};

exports.getSubPagePath = getSubPagePath;