"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactStyles = require("@patternfly/react-styles");

var _reactIcons = require("@patternfly/react-icons");

var _stylesCss = _interopRequireDefault(require("../../@patternfly/patternfly-next/components/DataList/styles.css.js"));

var _Button = require("../Button");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var DataListToggle = function DataListToggle(_ref) {
  var className = _ref.className,
      isExpanded = _ref.isExpanded,
      ariaLabel = _ref['aria-label'],
      ariaLabelledBy = _ref['aria-labelledby'],
      id = _ref.id,
      props = _objectWithoutProperties(_ref, ["className", "isExpanded", "aria-label", "aria-labelledby", "id"]);

  return _react.default.createElement("div", _extends({
    className: (0, _reactStyles.css)(_stylesCss.default.dataListToggle, className)
  }, props), _react.default.createElement(_Button.Button, {
    id: id,
    variant: "plain",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    "aria-expanded": isExpanded
  }, _react.default.createElement(_reactIcons.AngleRightIcon, null)));
};

DataListToggle.propTypes = {
  /** Additional classes added to the DataList cell */
  className: _propTypes.default.string,

  /** Flag to show if the expanded content of the DataList item is visible */
  isExpanded: _propTypes.default.bool,

  /** Identify the DataList toggle number */
  id: _propTypes.default.string.isRequired,

  /** Adds accessible text to the DataList toggle */
  'aria-labelledby': _propTypes.default.string.isRequired,

  /** Adds accessible text to the DataList toggle */
  'aria-label': _propTypes.default.string.isRequired
};
DataListToggle.defaultProps = {
  className: '',
  isExpanded: false
};
var _default = DataListToggle;
exports.default = _default;