var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { css as emotionCSS, cx, injectGlobal } from 'emotion';
import { formatClassName, getCSSClasses, isModifier, createStyleDeclaration, isValidStyleDeclaration, getClassName } from './utils';

export var StyleSheet = {
  create: function create(styleObj) {
    var keys = Object.keys(styleObj);
    if (keys.length > 0) {
      return keys.reduce(function (prev, key) {
        return _extends({}, prev, _defineProperty({}, key, emotionCSS(styleObj[key])));
      }, {});
    }
    return emotionCSS(styleObj);
  },
  parse: function parse(input) {
    var classes = getCSSClasses(input);
    if (!classes) {
      return {};
    }

    return classes.reduce(function (map, className) {
      var key = formatClassName(className);
      if (map[key]) {
        return map;
      }

      var value = createStyleDeclaration(className, input);

      if (isModifier(className)) {
        map.modifiers[key] = value;
      } else {
        map[key] = value;
      }

      return map;
    }, {
      modifiers: {},
      inject: function inject() {
        return injectGlobal(input);
      },
      raw: input
    });
  }
};

export function css() {
  var filteredStyles = [];

  for (var _len = arguments.length, styles = Array(_len), _key = 0; _key < _len; _key++) {
    styles[_key] = arguments[_key];
  }

  styles.forEach(function (style) {
    if (isValidStyleDeclaration(style)) {
      style.__inject();
      filteredStyles.push(getClassName(style));
      return;
    }
    filteredStyles.push(style);
  });

  return cx.apply(undefined, filteredStyles);
}