'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStyles = exports.getSelectors = undefined;

var _css = require('css');

var css = _interopRequireWildcard(_css);

var _jsdom = require('jsdom');

var jsdom = _interopRequireWildcard(_jsdom);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var JSDOM = jsdom.JSDOM;


function getSelectors(nodes) {
  return nodes.reduce(function (selectors, node) {
    var props = typeof node.props === 'function' ? node.props() : node.props;
    return [].concat(_toConsumableArray(selectors), [getSelectorsFromProps(props)]);
  }, []);
}

function getSelectorsFromProps() {
  var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var className = props.className || props.class;
  if (className) {
    return className.toString().split(' ').map(function (cn) {
      return '.' + cn;
    });
  }
  return [];
}

function componentToHex(c) {
  var hex = c.toString(16);
  return hex.length === 1 ? '0' + hex : hex;
}

function rgbToHex(r, g, b) {
  return '#' + componentToHex(r) + componentToHex(g) + componentToHex(b);
}

function getComputedStyles(classNames, cssStr) {
  var dom = new JSDOM('<!DOCTYPE html>\n      <head><style>' + cssStr + '</style></head>\n      <body><div class="' + classNames + '"></div>\n      </body>');
  var cs = dom.window.getComputedStyle(dom.window.document.body.children[0]);
  var values = {};
  for (var i = 0; i < cs.length; i++) {
    var key = cs[i];
    var value = cs.getPropertyValue(key).replace(/rgb\(([\d|,|\s]+)\)/g, function (full, match) {
      return rgbToHex.apply(undefined, _toConsumableArray(match.split(',').map(function (n) {
        return parseInt(n, 10);
      })));
    });
    values[key] = value;
  }
  return values;
}

function getStylesAST(bufferedStyles) {
  var globalCSS = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

  var ast = css.parse(globalCSS + '\n' + bufferedStyles);
  var vars = {};
  var getVarValue = function getVarValue(value) {
    return value.replace(/var\(([\w|-]*)\)/g, function (full, match) {
      return vars[match];
    });
  };
  ast.stylesheet.rules = ast.stylesheet.rules.map(function (rule) {
    if (rule.type === 'rule') {
      rule.declarations = rule.declarations.map(function (decl) {
        if (decl.type === 'declaration') {
          var property = decl.property,
              value = decl.value;

          if (property.startsWith('--')) {
            vars[property] = getVarValue(value);
          }
          decl.value = getVarValue(value);
        }
        return decl;
      });
    }
    return rule;
  });
  return ast;
}

function formatComputedStyles(nodeSelectors, computedStyles) {
  var selector = nodeSelectors.join('');
  var cssString = selector + ' {\n    ' + Object.keys(computedStyles).map(function (k) {
    return k + ': ' + computedStyles[k] + ';';
  }).join('\n') + '\n  }';
  return css.stringify(css.parse(cssString));
}

function getStyles(nodeSelectors, insertedStyles, globalCSS) {
  if (!nodeSelectors.length) {
    return '';
  }
  var ast = getStylesAST(insertedStyles, globalCSS);
  return nodeSelectors.reduce(function (acc, sel) {
    if (!sel.length) {
      return acc;
    }

    var re = new RegExp('(' + sel.join('|') + ')', 'g');
    if (!re.test(insertedStyles)) {
      return acc;
    }

    var computedStyles = getComputedStyles(sel.map(function (s) {
      return s.replace('.', '');
    }).join(' '), css.stringify(ast));

    return [].concat(_toConsumableArray(acc), [formatComputedStyles(sel, computedStyles)]);
  }, []).join('\n');
}

exports.getSelectors = getSelectors;
exports.getStyles = getStyles;