# color-rgba

Convert color string to array with channels: `rgba(127,127,127,.1)` → `[.5,.5,.5,.1]`

## Usage

[![npm install color-rgba](https://nodei.co/npm/color-rgba.png?mini=true)](https://npmjs.org/package/color-rgba/)

### `rgba(string|array, normalize = true)`

Returns array with channel values, optionally normalized to _0..1_ range.

```js
const rgba = require('color-rgba')

rgba('rgba(80, 120, 160, .5)') // [.31, .47, .62, .5]
rgba('rgba(80, 120, 160, .5)', false) // [80, 120, 160, .5]
rgba('hsla(170, 50%, 45%, 1)') // [.225, .675, .6, 1]
rgba([255, 255, 255, 1]) // [1, 1, 1, 1]
```

## Related

* [color-alpha](https://github.com/dfcreative/color-alpha) — change alpha of a color string
* [color-interpolate](https://github.com/dfcreative/color-interpolate) — interpolate by color palette
* [color-parse](https://github.com/dfcreative/color-parse) — comprehensive color string parser

## License

MIT.
