const atlasSDF = require('./')
const atlas = require('font-atlas')
const createPanel = require('settings-panel')
const assign = require('object-assign')

let c1 = document.body.appendChild(document.createElement('canvas'))
let c2 = document.body.appendChild(document.createElement('canvas'))

let opts = {
	family: 'sans-serif',
	size: 64,
	// chars: [100, 120]
	chars: '◣●#◢✝+xyz▲▼_'.split('')
}
function update (o) {
	console.time('sdf')
	assign(opts, o)

	let w = Math.min(512, opts.size*16)
	let size = opts.size
	let step = size*2.2

	atlasSDF({
		canvas: c1,
	  family: opts.family
	  , size: opts.size
	  , shape: [w,w]
	  , step: [step, step],
	  chars: opts.chars,
	  align: true,
	  fit: true
	})
	console.timeEnd('sdf')


	console.time('bm')
	atlas({
		canvas: c2,
	  family: opts.family
	  , size: opts.size
	  , shape: [w,w]
	  , step: [step, step],
	  chars: opts.chars
	})
	console.timeEnd('bm')

	//render lines
	let ctx1 = c1.getContext('2d')
	let ctx2 = c2.getContext('2d')
	for (let i = 0; i <= w/step; i++) {
		ctx1.fillStyle = 'rgba(255,200,200,.5)'
		ctx2.fillStyle = 'rgba(255,200,200,.5)'
		ctx1.fillRect(i*step - step/2 - .5,0,1,w)
		ctx2.fillRect(i*step - step/2 - .5,0,1,w)
		ctx1.fillRect(0, i*step - step/2 - .5,w,1)
		ctx2.fillRect(0, i*step - step/2 - .5,w,1)

		ctx1.fillStyle = 'rgba(200,200,255,.5)'
		ctx2.fillStyle = 'rgba(200,200,255,.5)'
		ctx1.fillRect(i*step - .5,0,1,w)
		ctx2.fillRect(i*step - .5,0,1,w)
		ctx1.fillRect(0, i*step - .5,w,1)
		ctx2.fillRect(0, i*step - .5,w,1)
	}
}

createPanel([
{id: 'size', type: 'range', min: 1, max: 128, value: opts.size, step: 1, change: v => {
	update({size: v})
}},
{id: 'family', type: 'text', value: opts.family, change: v => {
	update({family: v})
}},
{id: 'chars', type: 'text', value: opts.chars, change: v => {
	v = v.split(',')
	update({chars: v})
}}
// {id: 'step', type: 'range', min: 1, max: 128, value: 21, step: 1, change: v => {
// 	update({size: v})
// }}
])
