gl-scatter2d
============
WebGL 2D scatter plots for lots of points

## Example
For now, see [`gl-plot2d`](https://github.com/gl-vis/gl-plot2d).

## Install
Using [npm](https://docs.npmjs.com/), you can install this module as follows:

```
npm i gl-scatter2d
```

## API

### Constructor

#### `var scatter = require('gl-scatter2d')(plot, options)`
Creates a new 2D scatter plot.

* `plot` is a reference to a `gl-plot2d` object
* `options` is a JSON object containing the parameters which are passed to the object when it is updated.

`options` has the following properties:

* `positions` is a packed 2*n length array of the unrolled xy coordinates of the points (required)
* `size` is a number giving the diameter of a marker in pixels (default `12`)
* `color` is the color of a marker as a length 4 RGBA array (default `[1,0,0,1]`)
* `borderSize` is the width of the border around each point in pixels (default `1`)
* `borderColor` is the color of the border of each point (default `[0,0,0,1]`)
* `snapPoints` defines whether points should be grouped hierarchically to optimize rendering of huge number of points

**Returns** A new scatter plot object, which is also registered to `plot`

### Methods

#### `scatter.update(options)`
Updates the scatter plot.

* `options` is an object with the same properties as in the scatter plot constructor

#### `scatter.dispose()`
Destroys the scatter plot and all associated resources.

## License
(c) 2015 Mikola Lysenko. MIT License

Development supported by plot.ly
