precision highp float;

attribute vec2 positionHi, positionLo;
attribute float weight;

uniform vec2 scaleHi, scaleLo, translateHi, translateLo;
uniform float pointSize, useWeight;

varying float fragWeight;

#pragma glslify: pfx = require("./precise.glsl")

void main() {
  gl_Position = pfx(scaleHi, scaleLo, translateHi, translateLo, positionHi, positionLo);
  gl_PointSize = pointSize;
  fragWeight = mix(1.0, weight, useWeight);
}