"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flavor = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../../utils");

var _InlineEdit = require("../../InlineEdit/InlineEdit");

var _constants = require("../../../constants");

var _selectors = require("../../../k8s/selectors");

var _Loading = require("../../Loading/Loading");

var _Form = require("../../Form");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Flavor extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "resolveInitialValues", () => {
      const _this$props = this.props,
            flavor = _this$props.flavor,
            vm = _this$props.vm;
      const cpu = (0, _utils.getCpu)(vm);
      const memory = (0, _utils.getMemory)(vm);
      const memoryInt = memory ? parseInt(memory, 10) : undefined;
      this.props.onFormChange({
        value: flavor
      }, 'flavor', flavor !== _constants.CUSTOM_FLAVOR);

      if (flavor === _constants.CUSTOM_FLAVOR) {
        this.props.onFormChange({
          value: cpu
        }, 'cpu', !!cpu);
        this.props.onFormChange({
          value: memoryInt
        }, 'memory', !!memoryInt);
      }
    });

    _defineProperty(this, "getFlavorChoices", () => {
      const flavors = [];

      if (this.state.template) {
        flavors.push(...(0, _selectors.getTemplateFlavors)([this.state.template]));
      }

      if (!flavors.some(flavor => flavor === _constants.CUSTOM_FLAVOR)) {
        flavors.push(_constants.CUSTOM_FLAVOR);
      }

      return flavors;
    });

    _defineProperty(this, "flavorFormFields", () => {
      const id = this.props.id;
      return {
        flavor: {
          id: (0, _utils.prefixedId)(id, 'flavor-dropdown'),
          type: _Form.DROPDOWN,
          choices: this.getFlavorChoices()
        },
        cpu: {
          id: (0, _utils.prefixedId)(id, 'flavor-cpu'),
          title: 'CPU',
          type: _Form.POSITIVE_NUMBER,
          required: true,
          isVisible: formValues => (0, _selectors.settingsValue)(formValues, 'flavor') === _constants.CUSTOM_FLAVOR
        },
        memory: {
          id: (0, _utils.prefixedId)(id, 'flavor-memory'),
          title: 'Memory (GB)',
          type: _Form.POSITIVE_NUMBER,
          required: true,
          isVisible: formValues => (0, _selectors.settingsValue)(formValues, 'flavor') === _constants.CUSTOM_FLAVOR
        }
      };
    });

    this.state = {
      loadingTemplate: false,
      template: null
    };
    this.resolveInitialValues();
  }

  componentDidMount() {
    this.setState({
      loadingTemplate: true
    });
    this.props.retrieveVmTemplate().then(result => {
      this.props.onFormChange(result, 'template', (0, _Form.validateForm)(this.flavorFormFields(), this.props.formValues));
      return this.setState({
        loadingTemplate: false,
        template: result
      });
    }).catch(error => {
      this.props.onLoadError(error.message || 'An error occurred while loading vm flavors. Please try again.');
      return this.setState({
        loadingTemplate: false,
        template: null
      });
    });
  }

  render() {
    const _this$props2 = this.props,
          id = _this$props2.id,
          editing = _this$props2.editing,
          updating = _this$props2.updating,
          LoadingComponent = _this$props2.LoadingComponent,
          onFormChange = _this$props2.onFormChange,
          flavor = _this$props2.flavor;
    const formFields = this.flavorFormFields();
    return _react.default.createElement(_InlineEdit.InlineEdit, {
      formFields: formFields,
      editing: editing,
      updating: updating || editing && this.state.loadingTemplate,
      LoadingComponent: LoadingComponent,
      onFormChange: onFormChange,
      fieldsValues: this.props.formValues
    }, _react.default.createElement("div", {
      id: (0, _utils.prefixedId)(id, 'flavor')
    }, flavor), _react.default.createElement("div", {
      id: (0, _utils.prefixedId)(id, 'flavor-description')
    }, (0, _utils.getFlavorDescription)(this.props.vm)));
  }

}

exports.Flavor = Flavor;
Flavor.propTypes = {
  flavor: _propTypes.default.string,
  id: _propTypes.default.string.isRequired,
  vm: _propTypes.default.object.isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  updating: _propTypes.default.bool,
  editing: _propTypes.default.bool,
  retrieveVmTemplate: _propTypes.default.func.isRequired,
  LoadingComponent: _propTypes.default.func,
  formValues: _propTypes.default.object,
  onLoadError: _propTypes.default.func
};
Flavor.defaultProps = {
  flavor: _constants.CUSTOM_FLAVOR,
  updating: false,
  editing: false,
  LoadingComponent: _Loading.Loading,
  formValues: undefined,
  onLoadError: () => {}
};