"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Checkbox = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const Checkbox = ({
  id,
  title,
  disabled,
  checked,
  onChange,
  onBlur,
  className
}) => _react.default.createElement(_patternflyReact.Checkbox, {
  id: id,
  checked: checked,
  onBlur: (0, _utils.checkboxHandler)(onBlur),
  onChange: (0, _utils.checkboxHandler)(onChange),
  className: className,
  disabled: disabled
}, title);

exports.Checkbox = Checkbox;
Checkbox.defaultProps = {
  title: '',
  checked: false,
  onChange: _patternflyReact.noop,
  onBlur: _patternflyReact.noop,
  className: undefined,
  disabled: false
};
Checkbox.propTypes = {
  id: _propTypes.default.string.isRequired,
  title: _propTypes.default.string,
  checked: _propTypes.default.bool,
  onChange: _propTypes.default.func,
  onBlur: _propTypes.default.func,
  className: _propTypes.default.string,
  disabled: _propTypes.default.bool
};