"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateSource = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Url = require("../Details/Url");

var _templates = require("../../utils/templates");

var _constants = require("../../constants");

var _selectors = require("../../utils/selectors");

var _utils = require("../../utils/utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const Type = ({
  type,
  source,
  id,
  isInline
}) => _react.default.createElement("div", {
  id: id,
  title: source,
  className: isInline ? 'kubevirt-template-source__overlay' : ''
}, type);

Type.propTypes = {
  type: _propTypes.default.string.isRequired,
  source: _propTypes.default.string,
  id: _propTypes.default.string,
  isInline: _propTypes.default.bool
};
Type.defaultProps = {
  source: undefined,
  id: undefined,
  isInline: false
};

const Source = ({
  type,
  source,
  id
}) => {
  if (!source) {
    return null;
  }

  const sourceElem = type === _constants.PROVISION_SOURCE_URL ? _react.default.createElement(_Url.Url, {
    url: source,
    short: true
  }) : source;
  return _react.default.createElement("div", {
    id: id,
    className: "kubevirt-template-source__source"
  }, sourceElem);
};

Source.propTypes = {
  type: _propTypes.default.string.isRequired,
  source: _propTypes.default.string,
  id: _propTypes.default.string
};
Source.defaultProps = {
  source: undefined,
  id: undefined
};

const TemplateSource = ({
  template,
  dataVolumes,
  detailed
}) => {
  const provisionSource = (0, _templates.getTemplateProvisionSource)(template, dataVolumes);

  if (!provisionSource) {
    return '---';
  }

  const type = provisionSource.type,
        source = provisionSource.source;
  const id = (0, _selectors.getId)(template);
  const typeId = (0, _utils.prefixedId)(id, 'type');
  const sourceId = (0, _utils.prefixedId)(id, 'source');

  if (!detailed) {
    return _react.default.createElement(Type, {
      id: typeId,
      type: type,
      source: source,
      isInline: true
    });
  }

  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(Type, {
    id: typeId,
    type: type,
    source: source
  }), _react.default.createElement(Source, {
    id: sourceId,
    type: type,
    source: source
  }));
};

exports.TemplateSource = TemplateSource;
TemplateSource.propTypes = {
  template: _propTypes.default.object.isRequired,
  dataVolumes: _propTypes.default.array,
  detailed: _propTypes.default.bool
};
TemplateSource.defaultProps = {
  dataVolumes: [],
  detailed: false
};